

package org.gcube.accounting.datamodel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.gcube.accounting.datamodel.serialization.PropertiesAdapter;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class User extends Consumer {

	private String firstName;
	private String lastName;
	private String email;
	private Map<String, List<String>> properties;

	public User() {
		super();
		this.properties = new HashMap<String, List<String>>();
	}

	/**
	 * 
	 * @param name
	 *            the name of the user
	 */
	public User(String firstName, String lastName) {
		this();
		this.setFirstName(firstName);
		this.setLastName(lastName);
	}

	/**
	 * @return the name
	 */
	public String getFirstName() {
		return firstName;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	/**
	 * @return the surname
	 */
	public String getLastName() {
		return lastName;
	}

	/**
	 * @param surname
	 *            the surname to set
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	
	public String getName() {
		String out = "";
		if(this.getFirstName()!=null)
			out+=this.getFirstName();
		out+=" ";
		if(this.getLastName()!=null)
			out+=this.getLastName();
		out=out.trim();
		if(!"".equals(out))
			return null;
		return out;
	}
	
	public void setName(String name) {
		this.setFirstName(name);
		this.setLastName(name);
	}

	/**
	 * @return the email
	 */
	public String getEmail() {
		return email;
	}

	/**
	 * @param email
	 *            the email to set
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * @return the properties
	 */
	@XmlJavaTypeAdapter(PropertiesAdapter.class)
	public Map<String, List<String>> getProperties() {
		return properties;
	}

	/**
	 * @param properties
	 *            the properties to set
	 */
	public void setProperties(Map<String, List<String>> properties) {
		this.properties = properties;
	}

	public void addProperty(String name, String value) {
		List<String> values = this.properties.get(name);
		if(values==null) {
			values = new Vector<String>();
			this.properties.put(name, values);
		}
		values.add(value);
	}
	
	public void addProperty(String name, List<String> values) {
		this.properties.put(name, values);
	}

	public List<String> getProperty(String name) {
		return this.properties.get(name);
	}

}
