package org.gcube.accounting.datamodel.reports;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.adapter.FiltersAdapter;
import org.gcube.accounting.datamodel.adapter.ObjectAdapter;
import org.gcube.accounting.datamodel.reports.aggregation.Granule;
import org.gcube.accounting.datamodel.reports.storagestatus.StorageStatusReportFilter;
import org.gcube.accounting.ut.UsageTrackerRestAPI;

@XmlRootElement(name = "report")
@XmlAccessorType(XmlAccessType.FIELD)
public class Report implements Serializable{

	/**
	 * 
	 */
	private static Logger logger = Logger.getLogger(Report.class);
	private static final long serialVersionUID = 8928933204099690196L;


	private String resourceType;
	private String reportType;
	private String reportProperty;

	@XmlJavaTypeAdapter(FiltersAdapter.class)
	private Map<String,List<String>> filters;
	private Date startPeriod;
	private Date endPeriod;
	private String dimension;
	private String aggregationGranule;



	public Report(String resourceType, String reportType, String reportProperty,
			Map<String, List<String>> filters, Date startPeriod,
			Date endPeriod, String dimension, String aggregationGranule) {
		super();
		this.resourceType = resourceType;
		this.reportType = reportType;
		this.reportProperty = reportProperty;
		this.filters = filters;
		this.startPeriod = startPeriod;
		this.endPeriod = endPeriod;
		this.dimension = dimension;
		this.aggregationGranule = aggregationGranule;
	}


	public Report() {
		super();
	}


	public String getResourceType() {
		return resourceType;
	}

	public void setResourceType(String resourceType) {
		this.resourceType = resourceType;
	}

	//	@XmlElement (name="type")
	public String getReportType() {
		return reportType;
	}

	public void setReportType(String reportType) {
		this.reportType = reportType;
	}

	

	public String getReportProperty() {
		return reportProperty;
	}


	public void setReportProperty(String reportProperty) {
		this.reportProperty = reportProperty;
	}


	//@XmlElement (name="startPeriod")
	public Date getStartPeriod() {
		return startPeriod;
	}


	public void setStartPeriod(Date startPeriod) {
		this.startPeriod = startPeriod;
	}


	//@XmlElement (name="endPeriod")
	public Date getEndPeriod() {
		return endPeriod;
	}


	public void setEndPeriod(Date endPeriod) {
		this.endPeriod = endPeriod;
	}


	public String getAggregationGranule() {
		return aggregationGranule;
	}

	public void setAggregationGranule(String aggregationGranule) {
		this.aggregationGranule = aggregationGranule;

	}

	public String getDimension() {
		return dimension;
	}


	public void setDimension(String dimension) {
		this.dimension = dimension;

	}


	public Map<String, List<String>> getFilters() {
		return filters;
	}
	
	public void setFilters(Map<String, List<String>> filters) {
		this.filters = filters;

	}


	@Override
	public String toString() {
		return "Report [resourceType=" + resourceType + ", reportType="
				+ reportType + ", reportProperty=" + reportProperty
				+ ", filters=" + filters + ", startPeriod=" + startPeriod
				+ ", endPeriod=" + endPeriod + ", dimension=" + dimension
				+ ", aggregationGranule=" + aggregationGranule + "]";
	}

	
	

	
	



}
