

package org.gcube.accounting.exception.rest;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.sun.jersey.api.client.ClientResponse.Status;

public class NotFoundException extends WebApplicationException {

	private static final long serialVersionUID = -5422459346645796367L;

	public NotFoundException() {
		super(Response.status(Status.NOT_FOUND).type(MediaType.APPLICATION_XML).build());
	}

	public NotFoundException(String message) {
		super(Response.status(Status.NOT_FOUND).entity(message).type(MediaType.TEXT_PLAIN).build());
	}

}
