

package org.gcube.accounting.webservice.configuration;

public abstract class BaseConfiguration implements NetworkConfiguration,
		SecurityConfiguration {

	public boolean isAuthnEnabled() {
		return this.getBoolean("authn.enabled", false);
	}

	public boolean isAuthzEnabled() {
		return this.getBoolean("authz.enabled", false);
	}
	
	public String getRealm() {
		String realm = this.getString("authn.realm");
		if(realm==null || realm.trim().equals(""))
			realm = "unknown";
		return realm;
	}

	public String getProxyHost() {
		return this.getString("proxyHost");
	}

	public String getProxyPort() {
		return this.getString("proxyPort");
	}

	public String getProxyUser() {
		return this.getString("proxyUser");
	}

	public String getProxyPassword() {
		return this.getString("proxyPassword");
	}

	public abstract String getString(String key);

	public abstract Boolean getBoolean(String key);

	public abstract Boolean getBoolean(String key, Boolean def);

}
