package org.gcube.accounting.datamodel.reports.aggregation;


public enum Granule {

	DAY("day"),
	WEEK("week"),
	MONTH("month"),
	YEAR("year");
	
	private String name;

	private Granule(String name) {
		this.name = name;
	}

	public String toName() {
		return this.name;
	}
	
	public static Granule toEnum(String text) {
		if (text != null) {
			for (Granule b : Granule.values()) {
				if (text.equalsIgnoreCase(b.toName())) {
					return b;
				}
			}
		}
		return null;
	}
}
