/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.common.helper;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class TimeHelper {
    private static Logger logger = Logger.getLogger(TimeHelper.class);

    public static Calendar getStart(int year, int week) {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(7, 1);
        c.set(1, year);
        c.set(3, week);
        return c;
    }

    public static Calendar getMonthStart(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(5, 1);
        c.set(2, month);
        c.set(1, year);
        return c;
    }

    public static Calendar getEnd(int year, int week) {
        Calendar c = TimeHelper.getStart(year, week);
        c.add(3, 1);
        return c;
    }

    public static Calendar getMonthEnd(int year, int month) {
        Calendar c = TimeHelper.getMonthStart(year, month);
        c.add(2, 1);
        return c;
    }

    public static String format(Calendar c, boolean time) {
        if (c == null) {
            return "undefined";
        }
        if (time) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(c.getTime());
        }
        SimpleDateFormat sdf = new SimpleDateFormat("EEE dd MMM yyyy");
        return sdf.format(c.getTime());
    }

    public static Calendar getCalendar(long timestamp) {
        Date d = new Date(timestamp);
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal;
    }

    public static Calendar getCalendar(String timestamp) throws NumberFormatException {
        try {
            Long millis = Long.parseLong(timestamp);
            return TimeHelper.getCalendar(millis);
        }
        catch (NumberFormatException e) {
            Double millis = Double.parseDouble(timestamp);
            return TimeHelper.getCalendar(Math.round(millis));
        }
    }

    public static String getHumanReadableTime(long seconds) {
        String s = "";
        long days = (long)Math.floor(seconds / 60L / 60L / 24L);
        long hours = (long)Math.floor(seconds / 60L / 60L - days * 24L);
        long minutes = (long)Math.floor(seconds / 60L - (days * 24L * 60L + hours * 60L));
        long rSeconds = (long)Math.floor(seconds - (days * 24L * 60L * 60L + hours * 60L * 60L + minutes * 60L));
        if (days > 0L) {
            s = s + days + (days > 1L ? " days, " : " day, ");
        }
        if (days > 0L || hours > 0L) {
            s = s + hours + (hours > 1L ? " hours, " : " hour, ");
        }
        if (days > 0L || hours > 0L || minutes > 0L) {
            s = s + minutes + (minutes > 1L ? " minutes, " : " minute, ");
        }
        s = s + rSeconds + (rSeconds > 1L ? " seconds" : " second");
        return s;
    }

    public static String getISO8601(long seconds) {
        String s = "P";
        long days = (long)Math.floor(seconds / 60L / 60L / 24L);
        if (days > 0L) {
            s = s + days + "D";
        }
        s = s + "T";
        long hours = (long)Math.floor(seconds / 60L / 60L - days * 24L);
        if (days > 0L || hours > 0L) {
            s = s + hours + "H";
        }
        long minutes = (long)Math.floor(seconds / 60L - (days * 24L * 60L + hours * 60L));
        if (days > 0L || hours > 0L || minutes > 0L) {
            s = s + minutes + "M";
        }
        long rSeconds = (long)Math.floor(seconds - (days * 24L * 60L * 60L + hours * 60L * 60L + minutes * 60L));
        s = s + rSeconds + "S";
        return s;
    }
}

