/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.webservice.configuration;

import org.gcube.accounting.webservice.configuration.NetworkConfiguration;
import org.gcube.accounting.webservice.configuration.SecurityConfiguration;

public abstract class BaseConfiguration
implements NetworkConfiguration,
SecurityConfiguration {
    @Override
    public boolean isAuthnEnabled() {
        return this.getBoolean("authn.enabled", false);
    }

    @Override
    public boolean isAuthzEnabled() {
        return this.getBoolean("authz.enabled", false);
    }

    @Override
    public String getRealm() {
        String realm = this.getString("authn.realm");
        if (realm == null || realm.trim().equals("")) {
            realm = "unknown";
        }
        return realm;
    }

    @Override
    public String getProxyHost() {
        return this.getString("proxyHost");
    }

    @Override
    public String getProxyPort() {
        return this.getString("proxyPort");
    }

    @Override
    public String getProxyUser() {
        return this.getString("proxyUser");
    }

    @Override
    public String getProxyPassword() {
        return this.getString("proxyPassword");
    }

    @Override
    public abstract String getString(String var1);

    @Override
    public abstract Boolean getBoolean(String var1);

    @Override
    public abstract Boolean getBoolean(String var1, Boolean var2);
}

