/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import org.gcube.accounting.accounting.summary.access.AccountingDao;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.accounting.accounting.summary.access.model.internal.Dimension;
import org.gcube.accounting.accounting.summary.access.model.update.AccountingRecord;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.dataharvest.DataHarvestPluginDeclaration;
import org.gcube.dataharvest.harvester.MethodInvocationHarvester;
import org.gcube.dataharvest.harvester.SocialInteractionsHarvester;
import org.gcube.dataharvest.harvester.VREAccessesHarvester;
import org.gcube.dataharvest.harvester.VREUsersHarvester;
import org.gcube.dataharvest.harvester.sobigdata.DataMethodDownloadHarvester;
import org.gcube.dataharvest.harvester.sobigdata.ResourceCatalogueHarvester;
import org.gcube.dataharvest.harvester.sobigdata.TagMeMethodInvocationHarvester;
import org.gcube.dataharvest.utils.AggregationType;
import org.gcube.dataharvest.utils.ContextAuthorization;
import org.gcube.dataharvest.utils.DateUtils;
import org.gcube.dataharvest.utils.Utils;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingDataHarvesterPlugin
extends Plugin<DataHarvestPluginDeclaration> {
    private static Logger logger = LoggerFactory.getLogger(AccountingDataHarvesterPlugin.class);
    private static final String PROPERTY_FILENAME = "config.properties";
    public static final String START_DATE_INPUT_PARAMETER = "startDate";
    public static final String MEASURE_TYPE_INPUT_PARAMETER = "measureType";
    public static final String RERUN_INPUT_PARAMETER = "reRun";
    public static final String GET_VRE_USERS_INPUT_PARAMETER = "getVREUsers";
    public static final String DRY_RUN_INPUT_PARAMETER = "dryRun";
    public static final String SO_BIG_DATA_VO = "/d4science.research-infrastructures.eu/SoBigData";
    public static final String SO_BIG_DATA_EU_VRE = "/d4science.research-infrastructures.eu/gCubeApps/SoBigData.eu";
    public static final String SO_BIG_DATA_IT_VRE = "/d4science.research-infrastructures.eu/gCubeApps/SoBigData.it";
    public static final String SO_BIG_DATA_CATALOGUE_CONTEXT = "/d4science.research-infrastructures.eu/SoBigData/ResourceCatalogue";
    public static final String TAGME_CONTEXT = "/d4science.research-infrastructures.eu/SoBigData/TagMe";
    public static final String TO_BE_SET = "TO BE SET";
    protected Date start;
    protected Date end;
    private static final InheritableThreadLocal<Properties> properties = new InheritableThreadLocal<Properties>(){

        @Override
        protected Properties initialValue() {
            return new Properties();
        }
    };
    protected static final InheritableThreadLocal<Map<String, Dimension>> dimensions = new InheritableThreadLocal<Map<String, Dimension>>(){

        @Override
        protected Map<String, Dimension> initialValue() {
            return new HashMap<String, Dimension>();
        }
    };
    protected static final InheritableThreadLocal<Map<String, ScopeDescriptor>> scopeDescriptors = new InheritableThreadLocal<Map<String, ScopeDescriptor>>(){

        @Override
        protected Map<String, ScopeDescriptor> initialValue() {
            return new HashMap<String, ScopeDescriptor>();
        }
    };
    public static final InheritableThreadLocal<ScopeDescriptor> scopeDescriptor = new InheritableThreadLocal<ScopeDescriptor>(){

        @Override
        protected ScopeDescriptor initialValue() {
            return new ScopeDescriptor("", "");
        }
    };

    public AccountingDataHarvesterPlugin(DataHarvestPluginDeclaration pluginDeclaration) {
        super((PluginDeclaration)pluginDeclaration);
    }

    public static InheritableThreadLocal<Properties> getProperties() {
        return properties;
    }

    public static Dimension getDimension(String key) {
        Dimension dimension = (Dimension)((Map)dimensions.get()).get(key);
        if (dimension == null) {
            dimension = new Dimension(key, key, null, key);
        }
        return dimension;
    }

    public static ScopeDescriptor getScopeDescriptor(String context) {
        return (ScopeDescriptor)((Map)scopeDescriptors.get()).get(context);
    }

    public static ScopeDescriptor getScopeDescriptor() {
        return (ScopeDescriptor)scopeDescriptor.get();
    }

    public Properties getConfigParameters() throws IOException {
        Properties properties = new Properties();
        try {
            InputStream input = AccountingDataHarvesterPlugin.class.getClassLoader().getResourceAsStream(PROPERTY_FILENAME);
            properties.load(input);
            return properties;
        }
        catch (Exception e) {
            logger.warn("Unable to load {} file containing configuration properties. AccountingDataHarvesterPlugin will use defaults", (Object)PROPERTY_FILENAME);
            return properties;
        }
    }

    public void launch(Map<String, Object> inputs) throws Exception {
        logger.debug("{} is starting", (Object)((Object)((Object)this)).getClass().getSimpleName());
        if (inputs == null || inputs.isEmpty()) {
            throw new IllegalArgumentException("The can only be launched providing valid input parameters");
        }
        if (!inputs.containsKey(MEASURE_TYPE_INPUT_PARAMETER)) {
            throw new IllegalArgumentException("Please set required parameter 'measureType'");
        }
        AggregationType aggregationType = AggregationType.valueOf((String)inputs.get(MEASURE_TYPE_INPUT_PARAMETER));
        boolean reRun = true;
        if (inputs.containsKey(RERUN_INPUT_PARAMETER)) {
            try {
                reRun = (Boolean)inputs.get(RERUN_INPUT_PARAMETER);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("'reRun' must be a boolean");
            }
        }
        boolean getVREUsers = true;
        if (inputs.containsKey(GET_VRE_USERS_INPUT_PARAMETER)) {
            try {
                reRun = (Boolean)inputs.get(GET_VRE_USERS_INPUT_PARAMETER);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("'getVREUsers' must be a boolean");
            }
        }
        boolean dryRun = true;
        if (inputs.containsKey(DRY_RUN_INPUT_PARAMETER)) {
            try {
                dryRun = (Boolean)inputs.get(DRY_RUN_INPUT_PARAMETER);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("'dryRun' must be a boolean");
            }
        }
        if (inputs.containsKey(START_DATE_INPUT_PARAMETER)) {
            String startDateString = (String)inputs.get(START_DATE_INPUT_PARAMETER);
            this.start = DateUtils.UTC_DATE_FORMAT.parse(startDateString + " " + "+0000");
        } else {
            this.start = DateUtils.getPreviousPeriod(aggregationType).getTime();
        }
        this.end = DateUtils.getEndDateFromStartDate(aggregationType, this.start, 1);
        logger.debug("Harvesting from {} to {} (ReRun:{} - GetVREUsers:{} - DryRun:{})", new Object[]{DateUtils.format(this.start), DateUtils.format(this.end), reRun, getVREUsers, dryRun});
        Properties properties = this.getConfigParameters();
        AccountingDataHarvesterPlugin.getProperties().set(properties);
        ContextAuthorization contextAuthorization = new ContextAuthorization();
        AccountingDao dao = AccountingDao.get();
        Set scopeDescriptorSet = dao.getContexts();
        HashMap<String, ScopeDescriptor> scopeDescriptorMap = new HashMap<String, ScopeDescriptor>();
        for (ScopeDescriptor scopeDescriptor : scopeDescriptorSet) {
            scopeDescriptorMap.put(scopeDescriptor.getId(), scopeDescriptor);
        }
        scopeDescriptors.set(scopeDescriptorMap);
        Set dimensionSet = dao.getDimensions();
        HashMap<String, Dimension> dimensionMap = new HashMap<String, Dimension>();
        for (Dimension dimension : dimensionSet) {
            dimensionMap.put(dimension.getId(), dimension);
        }
        dimensions.set(dimensionMap);
        SortedSet<String> contexts = contextAuthorization.getContexts();
        ArrayList<AccountingRecord> accountingRecords = new ArrayList<AccountingRecord>();
        String initialToken = SecurityTokenProvider.instance.get();
        VREAccessesHarvester vreAccessesHarvester = null;
        for (String context : contexts) {
            List<AccountingRecord> harvested;
            Utils.setContext(contextAuthorization.getTokenForContext(context));
            ScopeBean scopeBean = new ScopeBean(context);
            ScopeDescriptor actualScopeDescriptor = (ScopeDescriptor)scopeDescriptorMap.get(context);
            if (actualScopeDescriptor == null) {
                actualScopeDescriptor = new ScopeDescriptor(scopeBean.name(), context);
            }
            scopeDescriptor.set(actualScopeDescriptor);
            if (vreAccessesHarvester == null) {
                if (scopeBean.is(ScopeBean.Type.INFRASTRUCTURE)) {
                    vreAccessesHarvester = new VREAccessesHarvester(this.start, this.end);
                } else {
                    ScopeBean parent = scopeBean.enclosingScope();
                    while (!parent.is(ScopeBean.Type.INFRASTRUCTURE)) {
                        parent = scopeBean.enclosingScope();
                    }
                    Utils.setContext(contextAuthorization.getTokenForContext(parent.toString()));
                    vreAccessesHarvester = new VREAccessesHarvester(this.start, this.end);
                    Utils.setContext(contextAuthorization.getTokenForContext(context));
                }
            }
            if ((context.startsWith(SO_BIG_DATA_VO) || context.startsWith(SO_BIG_DATA_EU_VRE) || context.startsWith(SO_BIG_DATA_IT_VRE)) && this.start.before(DateUtils.getStartCalendar(2018, 3, 1).getTime())) {
                logger.info("Not Harvesting for {} from {} to {}", new Object[]{context, DateUtils.format(this.start), DateUtils.format(this.end)});
                continue;
            }
            try {
                logger.info("Going to harvest VRE Accesses for {}", (Object)context);
                List<AccountingRecord> harvested2 = vreAccessesHarvester.getAccountingRecords();
                accountingRecords.addAll(harvested2);
            }
            catch (Exception e) {
                logger.error("Error harvesting VRE Accesses for {}", (Object)context, (Object)e);
            }
            try {
                logger.info("Going to harvest Social Interactions for {}", (Object)context);
                SocialInteractionsHarvester socialHarvester = new SocialInteractionsHarvester(this.start, this.end);
                harvested = socialHarvester.getAccountingRecords();
                accountingRecords.addAll(harvested);
            }
            catch (Exception e) {
                logger.error("Error harvesting Social Interactions for {}", (Object)context, (Object)e);
            }
            try {
                if (getVREUsers && scopeBean.is(ScopeBean.Type.VRE) && this.start.equals(DateUtils.getPreviousPeriod(aggregationType).getTime())) {
                    logger.info("Going to harvest Context Users for {}", (Object)context);
                    VREUsersHarvester vreUsersHarvester = new VREUsersHarvester(this.start, this.end);
                    harvested = vreUsersHarvester.getAccountingRecords();
                    accountingRecords.addAll(harvested);
                }
            }
            catch (Exception e) {
                logger.error("Error harvesting Context Users for {}", (Object)context, (Object)e);
            }
            if (context.startsWith(SO_BIG_DATA_CATALOGUE_CONTEXT)) {
                try {
                    logger.info("Going to harvest Resource Catalogue Information for {}", (Object)context);
                    ResourceCatalogueHarvester resourceCatalogueHarvester = new ResourceCatalogueHarvester(this.start, this.end, contexts);
                    harvested = resourceCatalogueHarvester.getAccountingRecords();
                    accountingRecords.addAll(harvested);
                }
                catch (Exception e) {
                    logger.error("Error harvesting Resource Catalogue Information for {}", (Object)context, (Object)e);
                }
                try {
                    logger.info("Going to harvest Data Method Download for {}", (Object)context);
                    DataMethodDownloadHarvester dataMethodDownloadHarvester = new DataMethodDownloadHarvester(this.start, this.end, contexts);
                    harvested = dataMethodDownloadHarvester.getAccountingRecords();
                    accountingRecords.addAll(harvested);
                }
                catch (Exception e) {
                    logger.error("Error harvesting Data Method Download for {}", (Object)context, (Object)e);
                }
            }
            if (context.startsWith(TAGME_CONTEXT)) {
                try {
                    logger.info("Going to harvest Method Invocations for {}", (Object)context);
                    TagMeMethodInvocationHarvester tagMeMethodInvocationHarvester = new TagMeMethodInvocationHarvester(this.start, this.end);
                    harvested = tagMeMethodInvocationHarvester.getAccountingRecords();
                    accountingRecords.addAll(harvested);
                }
                catch (Exception e) {
                    logger.error("Error harvesting Method Invocations for {}", (Object)context, (Object)e);
                }
                continue;
            }
            try {
                logger.info("Going to harvest Method Invocations for {}", (Object)context);
                MethodInvocationHarvester methodInvocationHarvester = new MethodInvocationHarvester(this.start, this.end);
                harvested = methodInvocationHarvester.getAccountingRecords();
                accountingRecords.addAll(harvested);
            }
            catch (Exception e) {
                logger.error("Error harvesting Method Invocations for {}", (Object)context, (Object)e);
            }
        }
        Utils.setContext(initialToken);
        logger.debug("Harvest Measures from {} to {} are {}", new Object[]{DateUtils.format(this.start), DateUtils.format(this.end), accountingRecords});
        if (!dryRun) {
            dao.insertRecords(accountingRecords.toArray(new AccountingRecord[1]));
        } else {
            logger.debug("Harvested measures are {}", accountingRecords);
        }
    }

    protected void onStop() throws Exception {
        logger.debug("{} is stopping", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }
}

