/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.internal;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.state.LifecycleState;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class EndpointHealth {
    private final ServiceType type;
    private final LifecycleState state;
    private final InetSocketAddress local;
    private final InetSocketAddress remote;
    private final long lastActivityUs;
    private final String id;

    public EndpointHealth(ServiceType type, LifecycleState state, SocketAddress localAddr, SocketAddress remoteAddr, long lastActivityUs, String id) {
        this.type = type;
        this.state = state;
        this.id = id;
        if (localAddr == null) {
            this.local = null;
        } else {
            if (!(localAddr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Right now only InetSocketAddress is supported");
            }
            this.local = (InetSocketAddress)localAddr;
        }
        if (remoteAddr == null) {
            this.remote = null;
        } else {
            if (!(remoteAddr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Right now only InetSocketAddress is supported");
            }
            this.remote = (InetSocketAddress)remoteAddr;
        }
        this.lastActivityUs = lastActivityUs;
    }

    public ServiceType type() {
        return this.type;
    }

    public LifecycleState state() {
        return this.state;
    }

    public InetSocketAddress local() {
        return this.local;
    }

    public InetSocketAddress remote() {
        return this.remote;
    }

    public long lastActivity() {
        return this.lastActivityUs;
    }

    public String id() {
        return this.id;
    }

    public Map<String, Object> toMap() {
        String ra = this.remote() == null ? null : this.remote().getAddress().getHostAddress();
        String la = this.local() == null ? null : this.local().getAddress().getHostAddress();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("remote", ra == null ? "" : ra + ":" + this.remote().getPort());
        map.put("local", la == null ? "" : la + ":" + this.local().getPort());
        map.put("state", this.state().toString().toLowerCase());
        map.put("last_activity_us", this.lastActivity());
        map.put("id", this.id());
        return map;
    }

    public String toString() {
        return "EndpointHealth{type=" + (Object)((Object)this.type) + ", state=" + (Object)((Object)this.state) + ", local=" + this.local + ", remote=" + this.remote + ", lastActivity=" + this.lastActivityUs + '}';
    }
}

