/*
 * Decompiled with CFR 0.152.
 */
package lombok.core.debug;

import java.util.GregorianCalendar;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicStampedReference;
import lombok.core.debug.ProblemReporter;

public class HistogramTracker {
    private static final int[] RANGES = new int[]{1, 2, 5, 9, 17, 33, 65, 129, 257};
    private static final long REPORT_TIME = 60000L;
    private final String category;
    private final AtomicStampedReference<int[]> bars = new AtomicStampedReference<int[]>(new int[RANGES.length + 2], 0);
    private final AtomicBoolean addedSysHook = new AtomicBoolean(false);

    public HistogramTracker(String category) {
        this.category = category;
        if (category == null) {
            ProblemReporter.info("Initialized histogram", null);
        } else {
            ProblemReporter.info(String.format("Initialized histogram tracker for '%s'", category), null);
        }
    }

    public void report(long start) {
        int[] newBars;
        if (!this.addedSysHook.getAndSet(true)) {
            Runtime.getRuntime().addShutdownHook(new Thread("Histogram Printer"){

                public void run() {
                    int[] currentInterval = new int[]{0};
                    int[] b = (int[])HistogramTracker.this.bars.get(currentInterval);
                    HistogramTracker.this.printReport(currentInterval[0], b);
                }
            });
        }
        long end = System.currentTimeMillis();
        long delta = end - start;
        int interval = (int)(end / 60000L);
        int[] currentInterval = new int[]{0};
        int[] bars = this.bars.get(currentInterval);
        if (currentInterval[0] != interval) {
            this.printReport(currentInterval[0], bars);
            newBars = new int[RANGES.length + 2];
            if (!this.bars.compareAndSet(bars, newBars, currentInterval[0], interval)) {
                newBars = this.bars.get(currentInterval);
            }
        } else {
            newBars = bars;
        }
        int n = RANGES.length + 1;
        newBars[n] = (int)((long)newBars[n] + delta);
        for (int i = 0; i < RANGES.length; ++i) {
            if (delta >= (long)RANGES[i]) continue;
            int n2 = i;
            newBars[n2] = newBars[n2] + 1;
            return;
        }
        int n3 = RANGES.length;
        newBars[n3] = newBars[n3] + 1;
    }

    private void printReport(int interval, int[] bars) {
        StringBuilder sb = new StringBuilder();
        if (this.category != null) {
            sb.append(this.category).append(" ");
        }
        sb.append("[");
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis((long)interval * 60000L);
        int hour = gc.get(11);
        int minute = gc.get(12);
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour).append(":");
        if (minute < 10) {
            sb.append('0');
        }
        sb.append(minute).append("] {");
        int sum = bars[RANGES.length];
        for (int i = 0; i < RANGES.length; ++i) {
            sum += bars[i];
            sb.append(bars[i]).append(" ");
        }
        if (sum == 0) {
            return;
        }
        sb.append(bars[RANGES.length]).append("} total calls: ").append(sum).append(" total time: ").append(bars[RANGES.length + 1]);
        ProblemReporter.info(sb.toString(), null);
    }
}

