/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.element;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.element.Element;
import com.couchbase.client.java.query.dsl.path.SelectType;

@InterfaceStability.Experimental
@InterfaceAudience.Private
public class SelectElement
implements Element {
    private final SelectType selectType;
    private final Expression[] expressions;

    public SelectElement(SelectType selectType, Expression ... expressions) {
        this.selectType = selectType;
        this.expressions = expressions;
    }

    @Override
    public String export() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        if (this.selectType != SelectType.DEFAULT) {
            sb.append(this.selectType.value()).append(" ");
        }
        for (int i = 0; i < this.expressions.length; ++i) {
            sb.append(this.expressions[i].toString());
            if (i >= this.expressions.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

