/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest.harvester.sobigdata;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.accounting.accounting.summary.access.model.update.AccountingRecord;
import org.gcube.common.storagehub.client.dsl.ContainerType;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.client.dsl.ListResolverTyped;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.nodes.Accounting;
import org.gcube.common.storagehub.model.items.nodes.accounting.AccountEntry;
import org.gcube.dataharvest.AccountingDashboardHarvesterPlugin;
import org.gcube.dataharvest.datamodel.HarvestedDataKey;
import org.gcube.dataharvest.harvester.sobigdata.SoBigDataHarvester;
import org.gcube.dataharvest.utils.DateUtils;
import org.gcube.dataharvest.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMethodDownloadHarvester
extends SoBigDataHarvester {
    private static Logger logger = LoggerFactory.getLogger(DataMethodDownloadHarvester.class);
    private int count = 0;

    public DataMethodDownloadHarvester(Date start, Date end, SortedSet<String> contexts) throws Exception {
        super(start, end, contexts);
    }

    @Override
    public List<AccountingRecord> getAccountingRecords() throws Exception {
        String defaultContext = Utils.getCurrentContext();
        logger.debug("The context is {}", (Object)defaultContext);
        StorageHubClient storageHubClient = new StorageHubClient();
        FolderContainer vreFolderContainer = storageHubClient.openVREFolder();
        FolderItem vreFolderItem = (FolderItem)vreFolderContainer.get();
        logger.debug("Analyzing {} in the period [{} to {}] starting from root {}", new Object[]{defaultContext, DateUtils.format(this.start), DateUtils.format(this.end), vreFolderItem.getName()});
        ScopeDescriptor defaultScopeDescriptor = AccountingDashboardHarvesterPlugin.getScopeDescriptor();
        AccountingRecord defaultHarvesteData = new AccountingRecord(defaultScopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.DATA_METHOD_DOWNLOAD), Long.valueOf(this.count));
        logger.debug("{} : {}", (Object)defaultHarvesteData.getDimension().getId(), (Object)defaultHarvesteData.getMeasure());
        ArrayList<AccountingRecord> accountingRecords = new ArrayList<AccountingRecord>();
        ListResolverTyped listResolverTyped = vreFolderContainer.list();
        List containers = listResolverTyped.includeHidden().getContainers();
        for (ItemContainer itemContainer : containers) {
            this.count = 0;
            if (itemContainer.getType() != ContainerType.FOLDER) continue;
            Item item = itemContainer.get();
            logger.debug("Getting statistics for folder {}", (Object)item.getName());
            this.getStats((ItemContainer<? extends Item>)itemContainer, this.start, this.end);
            String normalizedName = item.getName().replaceAll("[^A-Za-z0-9]", "");
            String context = (String)this.mapWsFolderNameToVRE.get(normalizedName);
            if (context != null && !context.isEmpty()) {
                logger.debug("Found context '{}' matching with normalized VRE name {} ", (Object)context, (Object)normalizedName);
                ScopeDescriptor scopeDescriptor = AccountingDashboardHarvesterPlugin.getScopeDescriptor(context);
                AccountingRecord ar = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.DATA_METHOD_DOWNLOAD), Long.valueOf(this.count));
                logger.debug("{} : {}", (Object)ar.getDimension().getId(), (Object)ar.getMeasure());
                accountingRecords.add(ar);
                continue;
            }
            logger.debug("No scope found matching the folder name {}, accounting its stats in the default context {}", (Object)normalizedName, (Object)defaultContext);
            defaultHarvesteData.setMeasure(Long.valueOf(defaultHarvesteData.getMeasure() + (long)this.count));
            logger.trace("Increased default context stats {}", (Object)defaultHarvesteData);
        }
        accountingRecords.add(defaultHarvesteData);
        logger.debug("In the period [from {} to {} ] returning workspace accouting data {}", new Object[]{DateUtils.format(this.start), DateUtils.format(this.end), accountingRecords});
        return accountingRecords;
    }

    private void getStats(ItemContainer<? extends Item> itemContainer, Date start, Date end) throws Exception {
        if (itemContainer.getType() == ContainerType.FOLDER) {
            ListResolverTyped listResolverTyped = ((FolderContainer)itemContainer).list();
            List containers = listResolverTyped.includeHidden().getContainers();
            for (ItemContainer itemCont : containers) {
                this.getStats((ItemContainer<? extends Item>)itemCont, start, end);
            }
        } else {
            Accounting accounting = itemContainer.get().getAccounting();
            for (AccountEntry entry : accounting.getEntries()) {
                switch (entry.getType()) {
                    case CREATE: 
                    case UPDATE: 
                    case READ: {
                        Calendar calendar = entry.getDate();
                        if (!calendar.after(DateUtils.dateToCalendar(start)) || !calendar.before(DateUtils.dateToCalendar(end))) break;
                        ++this.count;
                        break;
                    }
                }
            }
        }
    }
}

