/*
 * Decompiled with CFR 0.152.
 */
package lombok.core.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.core.configuration.ConfigurationKey;
import lombok.core.configuration.ConfigurationParser;
import lombok.core.configuration.ConfigurationProblemReporter;
import lombok.core.configuration.ConfigurationSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConfigurationSource
implements ConfigurationSource {
    private final Map<ConfigurationKey<?>, ConfigurationSource.Result> values = new HashMap();

    public static ConfigurationSource forString(CharSequence content, ConfigurationProblemReporter reporter, String contentDescription) {
        final HashMap values = new HashMap();
        new ConfigurationParser(reporter).parse(content, contentDescription, new ConfigurationParser.Collector(){

            @Override
            public void clear(ConfigurationKey<?> key, String contentDescription, int lineNumber) {
                values.put(key, new ConfigurationSource.Result(null, true));
            }

            @Override
            public void set(ConfigurationKey<?> key, Object value, String contentDescription, int lineNumber) {
                values.put(key, new ConfigurationSource.Result(value, true));
            }

            @Override
            public void add(ConfigurationKey<?> key, Object value, String contentDescription, int lineNumber) {
                this.modifyList(key, value, true);
            }

            @Override
            public void remove(ConfigurationKey<?> key, Object value, String contentDescription, int lineNumber) {
                this.modifyList(key, value, false);
            }

            private void modifyList(ConfigurationKey<?> key, Object value, boolean add) {
                List<ConfigurationSource.ListModification> list;
                ConfigurationSource.Result result = (ConfigurationSource.Result)values.get(key);
                if (result == null || result.getValue() == null) {
                    list = new ArrayList();
                    values.put(key, new ConfigurationSource.Result(list, result != null));
                } else {
                    list = (List)result.getValue();
                }
                list.add(new ConfigurationSource.ListModification(value, add));
            }
        });
        return new StringConfigurationSource(values);
    }

    private StringConfigurationSource(Map<ConfigurationKey<?>, ConfigurationSource.Result> values) {
        for (Map.Entry<ConfigurationKey<?>, ConfigurationSource.Result> entry : values.entrySet()) {
            ConfigurationSource.Result result = entry.getValue();
            if (result.getValue() instanceof List) {
                this.values.put(entry.getKey(), new ConfigurationSource.Result(Collections.unmodifiableList((List)result.getValue()), result.isAuthoritative()));
                continue;
            }
            this.values.put(entry.getKey(), result);
        }
    }

    @Override
    public ConfigurationSource.Result resolve(ConfigurationKey<?> key) {
        return this.values.get(key);
    }
}

