/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.Statement;

public class Expression {
    private static final Expression NULL_INSTANCE = new Expression("NULL");
    private static final Expression TRUE_INSTANCE = new Expression("TRUE");
    private static final Expression FALSE_INSTANCE = new Expression("FALSE");
    private static final Expression MISSING_INSTANCE = new Expression("MISSING");
    private static final Expression EMPTY_INSTANCE = new Expression("");
    private final Object value;

    private Expression(Object value) {
        this.value = value;
    }

    public static Expression x(String value) {
        return new Expression(value);
    }

    public static Expression x(int value) {
        return new Expression(value);
    }

    public static Expression x(long value) {
        return new Expression(value);
    }

    public static Expression x(boolean value) {
        return value ? TRUE_INSTANCE : FALSE_INSTANCE;
    }

    public static Expression x(double value) {
        return new Expression(value);
    }

    public static Expression x(float value) {
        return new Expression(Float.valueOf(value));
    }

    public static Expression x(JsonArray value) {
        return new Expression(value);
    }

    public static Expression x(JsonObject value) {
        return new Expression(value);
    }

    public static Expression x(Statement statement) {
        return Expression.x(statement.toString());
    }

    public static Expression x(Number number) {
        return Expression.x(String.valueOf(number));
    }

    public static Expression sub(Statement statement) {
        return Expression.x("(" + statement.toString() + ")");
    }

    public static Expression par(Expression expression) {
        return Expression.infix(expression.toString(), "(", ")");
    }

    public static Expression path(Object ... pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            return EMPTY_INSTANCE;
        }
        StringBuilder path = new StringBuilder();
        for (Object p : pathComponents) {
            path.append('.');
            if (p instanceof Expression) {
                path.append(((Expression)p).toString());
                continue;
            }
            path.append(String.valueOf(p));
        }
        path.deleteCharAt(0);
        return Expression.x(path.toString());
    }

    public static Expression i(String ... identifiers) {
        return new Expression(Expression.wrapWith('`', identifiers));
    }

    public static Expression s(String ... strings) {
        return new Expression(Expression.wrapWith('\"', strings));
    }

    public static Expression TRUE() {
        return TRUE_INSTANCE;
    }

    public static Expression FALSE() {
        return FALSE_INSTANCE;
    }

    public static Expression NULL() {
        return NULL_INSTANCE;
    }

    public static Expression MISSING() {
        return MISSING_INSTANCE;
    }

    public Expression not() {
        return Expression.prefix("NOT", this.toString());
    }

    public Expression and(Expression right) {
        return Expression.infix("AND", this.toString(), right.toString());
    }

    public Expression and(String right) {
        return this.and(Expression.x(right));
    }

    public Expression and(int right) {
        return this.and(Expression.x(right));
    }

    public Expression and(long right) {
        return this.and(Expression.x(right));
    }

    public Expression and(float right) {
        return this.and(Expression.x(right));
    }

    public Expression and(double right) {
        return this.and(Expression.x(right));
    }

    public Expression and(boolean right) {
        return this.and(Expression.x(right));
    }

    public Expression and(JsonObject right) {
        return this.and(Expression.x(right));
    }

    public Expression and(JsonArray right) {
        return this.and(Expression.x(right));
    }

    public Expression or(Expression right) {
        return Expression.infix("OR", this.toString(), right.toString());
    }

    public Expression or(String right) {
        return this.or(Expression.x(right));
    }

    public Expression or(int right) {
        return this.or(Expression.x(right));
    }

    public Expression or(long right) {
        return this.or(Expression.x(right));
    }

    public Expression or(boolean right) {
        return this.or(Expression.x(right));
    }

    public Expression or(float right) {
        return this.or(Expression.x(right));
    }

    public Expression or(double right) {
        return this.or(Expression.x(right));
    }

    public Expression or(JsonArray right) {
        return this.or(Expression.x(right));
    }

    public Expression or(JsonObject right) {
        return this.or(Expression.x(right));
    }

    public Expression eq(Expression right) {
        return Expression.infix("=", this.toString(), right.toString());
    }

    public Expression eq(String right) {
        return this.eq(Expression.x(right));
    }

    public Expression eq(int right) {
        return this.eq(Expression.x(right));
    }

    public Expression eq(long right) {
        return this.eq(Expression.x(right));
    }

    public Expression eq(float right) {
        return this.eq(Expression.x(right));
    }

    public Expression eq(double right) {
        return this.eq(Expression.x(right));
    }

    public Expression eq(boolean right) {
        return this.eq(Expression.x(right));
    }

    public Expression eq(JsonArray right) {
        return this.eq(Expression.x(right));
    }

    public Expression eq(JsonObject right) {
        return this.eq(Expression.x(right));
    }

    public Expression ne(Expression right) {
        return Expression.infix("!=", this.toString(), right.toString());
    }

    public Expression ne(String right) {
        return this.ne(Expression.x(right));
    }

    public Expression ne(int right) {
        return this.ne(Expression.x(right));
    }

    public Expression ne(long right) {
        return this.ne(Expression.x(right));
    }

    public Expression ne(double right) {
        return this.ne(Expression.x(right));
    }

    public Expression ne(float right) {
        return this.ne(Expression.x(right));
    }

    public Expression ne(JsonObject right) {
        return this.ne(Expression.x(right));
    }

    public Expression ne(JsonArray right) {
        return this.ne(Expression.x(right));
    }

    public Expression gt(Expression right) {
        return Expression.infix(">", this.toString(), right.toString());
    }

    public Expression gt(String right) {
        return this.gt(Expression.x(right));
    }

    public Expression gt(int right) {
        return this.gt(Expression.x(right));
    }

    public Expression gt(long right) {
        return this.gt(Expression.x(right));
    }

    public Expression gt(float right) {
        return this.gt(Expression.x(right));
    }

    public Expression gt(double right) {
        return this.gt(Expression.x(right));
    }

    public Expression gt(boolean right) {
        return this.gt(Expression.x(right));
    }

    public Expression gt(JsonArray right) {
        return this.gt(Expression.x(right));
    }

    public Expression gt(JsonObject right) {
        return this.gt(Expression.x(right));
    }

    public Expression lt(Expression right) {
        return Expression.infix("<", this.toString(), right.toString());
    }

    public Expression lt(String right) {
        return this.lt(Expression.x(right));
    }

    public Expression lt(int right) {
        return this.lt(Expression.x(right));
    }

    public Expression lt(long right) {
        return this.lt(Expression.x(right));
    }

    public Expression lt(double right) {
        return this.lt(Expression.x(right));
    }

    public Expression lt(float right) {
        return this.lt(Expression.x(right));
    }

    public Expression lt(boolean right) {
        return this.lt(Expression.x(right));
    }

    public Expression lt(JsonObject right) {
        return this.lt(Expression.x(right));
    }

    public Expression lt(JsonArray right) {
        return this.lt(Expression.x(right));
    }

    public Expression gte(Expression right) {
        return Expression.infix(">=", this.toString(), right.toString());
    }

    public Expression gte(String right) {
        return this.gte(Expression.x(right));
    }

    public Expression gte(int right) {
        return this.gte(Expression.x(right));
    }

    public Expression gte(long right) {
        return this.gte(Expression.x(right));
    }

    public Expression gte(double right) {
        return this.gte(Expression.x(right));
    }

    public Expression gte(float right) {
        return this.gte(Expression.x(right));
    }

    public Expression gte(boolean right) {
        return this.gte(Expression.x(right));
    }

    public Expression gte(JsonObject right) {
        return this.gte(Expression.x(right));
    }

    public Expression gte(JsonArray right) {
        return this.gte(Expression.x(right));
    }

    public Expression concat(Expression right) {
        return Expression.infix("||", this.toString(), right.toString());
    }

    public Expression concat(String right) {
        return this.concat(Expression.x(right));
    }

    public Expression concat(int right) {
        return this.concat(Expression.x(right));
    }

    public Expression concat(long right) {
        return this.concat(Expression.x(right));
    }

    public Expression concat(boolean right) {
        return this.concat(Expression.x(right));
    }

    public Expression concat(float right) {
        return this.concat(Expression.x(right));
    }

    public Expression concat(double right) {
        return this.concat(Expression.x(right));
    }

    public Expression concat(JsonObject right) {
        return this.concat(Expression.x(right));
    }

    public Expression concat(JsonArray right) {
        return this.concat(Expression.x(right));
    }

    public Expression lte(Expression right) {
        return Expression.infix("<=", this.toString(), right.toString());
    }

    public Expression lte(String right) {
        return this.lte(Expression.x(right));
    }

    public Expression lte(int right) {
        return this.lte(Expression.x(right));
    }

    public Expression lte(long right) {
        return this.lte(Expression.x(right));
    }

    public Expression lte(float right) {
        return this.lte(Expression.x(right));
    }

    public Expression lte(double right) {
        return this.lte(Expression.x(right));
    }

    public Expression lte(boolean right) {
        return this.lte(Expression.x(right));
    }

    public Expression lte(JsonObject right) {
        return this.lte(Expression.x(right));
    }

    public Expression lte(JsonArray right) {
        return this.lte(Expression.x(right));
    }

    public Expression isValued() {
        return Expression.postfix("IS VALUED", this.toString());
    }

    public Expression isNotValued() {
        return Expression.postfix("IS NOT VALUED", this.toString());
    }

    public Expression isNull() {
        return Expression.postfix("IS NULL", this.toString());
    }

    public Expression isNotNull() {
        return Expression.postfix("IS NOT NULL", this.toString());
    }

    public Expression isMissing() {
        return Expression.postfix("IS MISSING", this.toString());
    }

    public Expression isNotMissing() {
        return Expression.postfix("IS NOT MISSING", this.toString());
    }

    public Expression between(Expression right) {
        return Expression.infix("BETWEEN", this.toString(), right.toString());
    }

    public Expression between(String right) {
        return this.between(Expression.x(right));
    }

    public Expression between(int right) {
        return this.between(Expression.x(right));
    }

    public Expression between(long right) {
        return this.between(Expression.x(right));
    }

    public Expression between(double right) {
        return this.between(Expression.x(right));
    }

    public Expression between(float right) {
        return this.between(Expression.x(right));
    }

    public Expression between(boolean right) {
        return this.between(Expression.x(right));
    }

    public Expression between(JsonObject right) {
        return this.between(Expression.x(right));
    }

    public Expression between(JsonArray right) {
        return this.between(Expression.x(right));
    }

    public Expression notBetween(Expression right) {
        return Expression.infix("NOT BETWEEN", this.toString(), right.toString());
    }

    public Expression notBetween(String right) {
        return this.notBetween(Expression.x(right));
    }

    public Expression notBetween(int right) {
        return this.notBetween(Expression.x(right));
    }

    public Expression notBetween(long right) {
        return this.notBetween(Expression.x(right));
    }

    public Expression notBetween(double right) {
        return this.notBetween(Expression.x(right));
    }

    public Expression notBetween(float right) {
        return this.notBetween(Expression.x(right));
    }

    public Expression notBetween(boolean right) {
        return this.notBetween(Expression.x(right));
    }

    public Expression notBetween(JsonObject right) {
        return this.notBetween(Expression.x(right));
    }

    public Expression notBetween(JsonArray right) {
        return this.notBetween(Expression.x(right));
    }

    public Expression like(Expression right) {
        return Expression.infix("LIKE", this.toString(), right.toString());
    }

    public Expression like(String right) {
        return this.like(Expression.x(right));
    }

    public Expression like(int right) {
        return this.like(Expression.x(right));
    }

    public Expression like(long right) {
        return this.like(Expression.x(right));
    }

    public Expression like(boolean right) {
        return this.like(Expression.x(right));
    }

    public Expression like(double right) {
        return this.like(Expression.x(right));
    }

    public Expression like(float right) {
        return this.like(Expression.x(right));
    }

    public Expression like(JsonObject right) {
        return this.like(Expression.x(right));
    }

    public Expression like(JsonArray right) {
        return this.like(Expression.x(right));
    }

    public Expression notLike(Expression right) {
        return Expression.infix("NOT LIKE", this.toString(), right.toString());
    }

    public Expression notLike(String right) {
        return this.notLike(Expression.x(right));
    }

    public Expression notLike(int right) {
        return this.notLike(Expression.x(right));
    }

    public Expression notLike(long right) {
        return this.notLike(Expression.x(right));
    }

    public Expression notLike(boolean right) {
        return this.notLike(Expression.x(right));
    }

    public Expression notLike(float right) {
        return this.notLike(Expression.x(right));
    }

    public Expression notLike(double right) {
        return this.notLike(Expression.x(right));
    }

    public Expression notLike(JsonObject right) {
        return this.notLike(Expression.x(right));
    }

    public Expression notLike(JsonArray right) {
        return this.notLike(Expression.x(right));
    }

    public Expression exists() {
        return Expression.prefix("EXISTS", this.toString());
    }

    public Expression in(Expression right) {
        return Expression.infix("IN", this.toString(), right.toString());
    }

    public Expression in(String right) {
        return this.in(Expression.x(right));
    }

    public Expression in(int right) {
        return this.in(Expression.x(right));
    }

    public Expression in(long right) {
        return this.in(Expression.x(right));
    }

    public Expression in(boolean right) {
        return this.in(Expression.x(right));
    }

    public Expression in(double right) {
        return this.in(Expression.x(right));
    }

    public Expression in(float right) {
        return this.in(Expression.x(right));
    }

    public Expression in(JsonObject right) {
        return this.in(Expression.x(right));
    }

    public Expression in(JsonArray right) {
        return this.in(Expression.x(right));
    }

    public Expression notIn(Expression right) {
        return Expression.infix("NOT IN", this.toString(), right.toString());
    }

    public Expression notIn(String right) {
        return this.notIn(Expression.x(right));
    }

    public Expression notIn(int right) {
        return this.notIn(Expression.x(right));
    }

    public Expression notIn(long right) {
        return this.notIn(Expression.x(right));
    }

    public Expression notIn(boolean right) {
        return this.notIn(Expression.x(right));
    }

    public Expression notIn(float right) {
        return this.notIn(Expression.x(right));
    }

    public Expression notIn(double right) {
        return this.notIn(Expression.x(right));
    }

    public Expression notIn(JsonObject right) {
        return this.notIn(Expression.x(right));
    }

    public Expression notIn(JsonArray right) {
        return this.notIn(Expression.x(right));
    }

    public Expression as(String alias) {
        return this.as(Expression.x(alias));
    }

    public Expression as(Expression alias) {
        return Expression.infix("AS", this.toString(), alias.toString());
    }

    public Expression add(Expression expression) {
        return Expression.infix("+", this.toString(), expression.toString());
    }

    public Expression add(Number b) {
        return this.add(Expression.x(String.valueOf(b)));
    }

    public Expression add(String expression) {
        return this.add(Expression.x(expression));
    }

    public Expression subtract(Expression expression) {
        return Expression.infix("-", this.toString(), expression.toString());
    }

    public Expression subtract(Number b) {
        return this.subtract(Expression.x(String.valueOf(b)));
    }

    public Expression subtract(String expression) {
        return this.subtract(Expression.x(expression));
    }

    public Expression multiply(Expression expression) {
        return Expression.infix("*", this.toString(), expression.toString());
    }

    public Expression multiply(Number b) {
        return this.multiply(Expression.x(String.valueOf(b)));
    }

    public Expression multiply(String expression) {
        return this.multiply(Expression.x(expression));
    }

    public Expression divide(Expression expression) {
        return Expression.infix("/", this.toString(), expression.toString());
    }

    public Expression divide(Number b) {
        return this.divide(Expression.x(String.valueOf(b)));
    }

    public Expression divide(String expression) {
        return this.divide(Expression.x(expression));
    }

    public Expression get(String expression) {
        return new Expression(Expression.path(this.toString(), Expression.x(expression)));
    }

    public Expression get(Expression expression) {
        return this.get(expression.toString());
    }

    private static Expression prefix(String prefix, String right) {
        return new Expression(prefix + " " + right);
    }

    private static Expression infix(String infix, String left, String right) {
        return new Expression(left + " " + infix + " " + right);
    }

    private static Expression postfix(String postfix, String left) {
        return new Expression(left + " " + postfix);
    }

    private static String wrapWith(char wrapper, String ... input) {
        StringBuilder escaped = new StringBuilder();
        for (String i : input) {
            escaped.append(", ");
            escaped.append(wrapper).append(i).append(wrapper);
        }
        if (escaped.length() > 2) {
            escaped.delete(0, 2);
        }
        return escaped.toString();
    }

    public String toString() {
        return this.value.toString();
    }
}

