/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.kv;

import com.couchbase.client.core.endpoint.kv.AuthenticationException;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.security.sasl.Sasl;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.channel.ChannelFuture;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.channel.ChannelOutboundHandler;
import com.couchbase.client.deps.io.netty.channel.ChannelPromise;
import com.couchbase.client.deps.io.netty.channel.SimpleChannelInboundHandler;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.deps.io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;

public class KeyValueAuthHandler
extends SimpleChannelInboundHandler<FullBinaryMemcacheResponse>
implements CallbackHandler,
ChannelOutboundHandler {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(KeyValueAuthHandler.class);
    public static final byte SASL_LIST_MECHS_OPCODE = 32;
    private static final byte SASL_AUTH_OPCODE = 33;
    private static final byte SASL_STEP_OPCODE = 34;
    private static final byte SASL_AUTH_SUCCESS = 0;
    private static final byte SASL_AUTH_FAILURE = 32;
    private final String username;
    private final String password;
    private final boolean forceSaslPlain;
    private ChannelHandlerContext ctx;
    private SaslClient saslClient;
    private String selectedMechanism;
    private ChannelPromise originalPromise;

    public KeyValueAuthHandler(String username, String password, boolean forceSaslPlain) {
        this.username = username;
        this.password = password == null ? "" : password;
        this.forceSaslPlain = forceSaslPlain;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        ctx.writeAndFlush(new DefaultBinaryMemcacheRequest().setOpcode((byte)32));
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                continue;
            }
            throw new AuthenticationException("SASLClient requested unsupported callback: " + callback);
        }
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullBinaryMemcacheResponse msg) throws Exception {
        if (msg.getOpcode() == 32) {
            this.handleListMechsResponse(ctx, msg);
        } else if (msg.getOpcode() == 33) {
            this.handleAuthResponse(ctx, msg);
        } else if (msg.getOpcode() == 34) {
            this.checkIsAuthed(msg);
        }
    }

    private void handleListMechsResponse(ChannelHandlerContext ctx, FullBinaryMemcacheResponse msg) throws Exception {
        String remote = ctx.channel().remoteAddress().toString();
        String[] supportedMechanisms = msg.content().toString(CharsetUtil.UTF_8).split(" ");
        if (supportedMechanisms.length == 0) {
            throw new AuthenticationException("Received empty SASL mechanisms list from server: " + remote);
        }
        if (this.forceSaslPlain) {
            LOGGER.trace("Got SASL Mechs {} but forcing PLAIN due to config setting.", (Object)Arrays.asList(supportedMechanisms));
            supportedMechanisms = new String[]{"PLAIN"};
        }
        this.saslClient = Sasl.createSaslClient(supportedMechanisms, null, "couchbase", remote, null, this);
        this.selectedMechanism = this.saslClient.getMechanismName();
        int mechanismLength = this.selectedMechanism.length();
        byte[] bytePayload = this.saslClient.hasInitialResponse() ? this.saslClient.evaluateChallenge(new byte[0]) : null;
        ByteBuf payload = bytePayload != null ? ctx.alloc().buffer().writeBytes(bytePayload) : Unpooled.EMPTY_BUFFER;
        DefaultFullBinaryMemcacheRequest initialRequest = new DefaultFullBinaryMemcacheRequest(this.selectedMechanism.getBytes(CharsetUtil.UTF_8), Unpooled.EMPTY_BUFFER, payload);
        initialRequest.setOpcode((byte)33).setKeyLength((short)mechanismLength).setTotalBodyLength(mechanismLength + payload.readableBytes());
        ChannelFuture future = ctx.writeAndFlush(initialRequest);
        future.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<Void>>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    LOGGER.warn("Error during SASL Auth negotiation phase.", (Object)future);
                }
            }
        });
    }

    private void handleAuthResponse(ChannelHandlerContext ctx, FullBinaryMemcacheResponse msg) throws Exception {
        ByteBuf content;
        if (this.saslClient.isComplete()) {
            this.checkIsAuthed(msg);
            return;
        }
        byte[] response = new byte[msg.content().readableBytes()];
        msg.content().readBytes(response);
        byte[] evaluatedBytes = this.saslClient.evaluateChallenge(response);
        if (evaluatedBytes != null) {
            if (this.selectedMechanism.equals("CRAM-MD5") || this.selectedMechanism.equals("PLAIN")) {
                String[] evaluated = new String(evaluatedBytes).split(" ");
                content = Unpooled.copiedBuffer(this.username + "\u0000" + evaluated[1], CharsetUtil.UTF_8);
            } else {
                content = Unpooled.wrappedBuffer(evaluatedBytes);
            }
        } else {
            throw new AuthenticationException("SASL Challenge evaluation returned null.");
        }
        DefaultFullBinaryMemcacheRequest stepRequest = new DefaultFullBinaryMemcacheRequest(this.selectedMechanism.getBytes(CharsetUtil.UTF_8), Unpooled.EMPTY_BUFFER, content);
        stepRequest.setOpcode((byte)34).setKeyLength((short)this.selectedMechanism.length()).setTotalBodyLength(content.readableBytes() + this.selectedMechanism.length());
        ChannelFuture future = ctx.writeAndFlush(stepRequest);
        future.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<Void>>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    LOGGER.warn("Error during SASL Auth negotiation phase.", (Object)future);
                }
            }
        });
    }

    private void checkIsAuthed(FullBinaryMemcacheResponse msg) {
        switch (msg.getStatus()) {
            case 0: {
                this.originalPromise.setSuccess();
                this.ctx.pipeline().remove(this);
                this.ctx.fireChannelActive();
                break;
            }
            case 32: {
                this.originalPromise.setFailure(new AuthenticationException("Authentication Failure"));
                break;
            }
            default: {
                this.originalPromise.setFailure(new AuthenticationException("Unhandled SASL auth status: " + msg.getStatus()));
            }
        }
    }

    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.originalPromise = promise;
        ChannelPromise downPromise = ctx.newPromise();
        downPromise.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<Void>>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess() && !KeyValueAuthHandler.this.originalPromise.isDone()) {
                    KeyValueAuthHandler.this.originalPromise.setFailure(future.cause());
                }
            }
        });
        ctx.connect(remoteAddress, localAddress, downPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close(promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    @Override
    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ctx.write(msg, promise);
    }

    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }
}

