/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest.harvester;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.accounting.accounting.summary.access.model.update.AccountingRecord;
import org.gcube.dataharvest.AccountingDashboardHarvesterPlugin;
import org.gcube.dataharvest.datamodel.HarvestedDataKey;
import org.gcube.dataharvest.harvester.SocialNetworkingHarvester;
import org.gcube.dataharvest.utils.Utils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialInteractionsHarvester
extends SocialNetworkingHarvester {
    private static Logger logger = LoggerFactory.getLogger(SocialInteractionsHarvester.class);
    private int likes;
    private int replies;
    private int posts;
    public static final String PATH = "/2/posts/get-posts-vre?gcube-token=";

    public SocialInteractionsHarvester(Date start, Date end) throws Exception {
        super(start, end);
    }

    @Override
    public List<AccountingRecord> getAccountingRecords() throws Exception {
        String context = Utils.getCurrentContext();
        try {
            ArrayList<AccountingRecord> accountingRecords = new ArrayList<AccountingRecord>();
            this.getJson();
            ScopeDescriptor scopeDescriptor = AccountingDashboardHarvesterPlugin.getScopeDescriptor();
            AccountingRecord likesAR = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.SOCIAL_LIKES), Long.valueOf(this.likes));
            logger.debug("{} : {}", (Object)likesAR.getDimension().getId(), (Object)likesAR.getMeasure());
            accountingRecords.add(likesAR);
            AccountingRecord postsAR = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.SOCIAL_POSTS), Long.valueOf(this.posts));
            logger.debug("{} : {}", (Object)postsAR.getDimension().getId(), (Object)postsAR.getMeasure());
            accountingRecords.add(postsAR);
            AccountingRecord repliesAR = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.SOCIAL_REPLIES), Long.valueOf(this.replies));
            logger.debug("{} : {}", (Object)repliesAR.getDimension().getId(), (Object)repliesAR.getMeasure());
            accountingRecords.add(repliesAR);
            return accountingRecords;
        }
        catch (Exception e) {
            logger.error("Error Harvesting Social Interactions for context {}", (Object)context, (Object)e);
            throw e;
        }
    }

    private void getJson() throws Exception {
        JSONObject jsonObject = this.getJSONObject(PATH);
        Boolean success = (Boolean)jsonObject.get("success");
        if (!success.booleanValue()) {
            throw new IOException("Erro while getting posts");
        }
        JSONArray res = jsonObject.getJSONArray("result");
        int len = res.length();
        this.posts = 0;
        this.replies = 0;
        this.likes = 0;
        for (int i = 0; i < len; ++i) {
            JSONObject item = res.getJSONObject(i);
            long time = item.getLong("time");
            if (this.start.getTime() > time || time > this.end.getTime()) continue;
            ++this.posts;
            this.replies += item.getInt("comments_no");
            this.likes += item.getInt("likes_no");
        }
    }
}

