/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest.harvester;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.accounting.accounting.summary.access.model.update.AccountingRecord;
import org.gcube.dataharvest.AccountingDashboardHarvesterPlugin;
import org.gcube.dataharvest.datamodel.HarvestedDataKey;
import org.gcube.dataharvest.harvester.BasicHarvester;
import org.gcube.dataharvest.utils.Utils;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.social_networking.social_networking_client_library.PostClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialInteractionsHarvester
extends BasicHarvester {
    private static Logger logger = LoggerFactory.getLogger(SocialInteractionsHarvester.class);
    private int likes;
    private int replies;
    private int posts;

    public SocialInteractionsHarvester(Date start, Date end) throws Exception {
        super(start, end);
    }

    @Override
    public List<AccountingRecord> getAccountingRecords() throws Exception {
        String context = Utils.getCurrentContext();
        try {
            ArrayList<AccountingRecord> accountingRecords = new ArrayList<AccountingRecord>();
            this.getJson();
            ScopeDescriptor scopeDescriptor = AccountingDashboardHarvesterPlugin.getScopeDescriptor(context);
            AccountingRecord likesAR = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.SOCIAL_LIKES), Long.valueOf(this.likes));
            logger.debug("{} : {}", (Object)likesAR.getDimension().getId(), (Object)likesAR.getMeasure());
            accountingRecords.add(likesAR);
            AccountingRecord postsAR = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.SOCIAL_POSTS), Long.valueOf(this.posts));
            logger.debug("{} : {}", (Object)postsAR.getDimension().getId(), (Object)postsAR.getMeasure());
            accountingRecords.add(postsAR);
            AccountingRecord repliesAR = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.SOCIAL_REPLIES), Long.valueOf(this.replies));
            logger.debug("{} : {}", (Object)repliesAR.getDimension().getId(), (Object)repliesAR.getMeasure());
            accountingRecords.add(repliesAR);
            return accountingRecords;
        }
        catch (Exception e) {
            logger.error("Error Harvesting Social Interactions for context {}", (Object)context, (Object)e);
            throw e;
        }
    }

    private void getJson() throws Exception {
        PostClient postClient = new PostClient();
        List vrePosts = postClient.getPostsVRE();
        this.posts = 0;
        this.replies = 0;
        this.likes = 0;
        for (Feed feed : vrePosts) {
            long time = feed.getTime().getTime();
            if (this.start.getTime() > time || time > this.end.getTime()) continue;
            ++this.posts;
            this.replies += Integer.valueOf(feed.getCommentsNo()).intValue();
            this.likes += Integer.valueOf(feed.getLikesNo()).intValue();
        }
    }
}

