/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo.gridfs;

import com.mongodb.DB;
import com.mongodb.gridfs.GridFS;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.oak.plugins.document.mongo.gridfs.CommandExecutor;
import org.apache.jackrabbit.oak.plugins.document.mongo.gridfs.DefaultCommandExecutor;
import org.apache.jackrabbit.oak.plugins.document.mongo.gridfs.GetBlobLengthCommandGridFS;
import org.apache.jackrabbit.oak.plugins.document.mongo.gridfs.ReadBlobCommandGridFS;
import org.apache.jackrabbit.oak.plugins.document.mongo.gridfs.WriteBlobCommandGridFS;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStoreInputStream;

public class MongoGridFSBlobStore
implements BlobStore {
    private final CommandExecutor commandExecutor = new DefaultCommandExecutor();
    private final GridFS gridFS;

    public MongoGridFSBlobStore(DB db) {
        this.gridFS = new GridFS(db);
    }

    @Override
    public long getBlobLength(String blobId) throws IOException {
        GetBlobLengthCommandGridFS command = new GetBlobLengthCommandGridFS(this.gridFS, blobId);
        return this.commandExecutor.execute(command);
    }

    @Override
    public InputStream getInputStream(String blobId) throws IOException {
        return new BlobStoreInputStream(this, blobId, 0L);
    }

    @Override
    public String getBlobId(String reference) {
        return null;
    }

    @Override
    public String getReference(String blobId) {
        return null;
    }

    @Override
    public int readBlob(String blobId, long blobOffset, byte[] buffer, int bufferOffset, int length) throws IOException {
        ReadBlobCommandGridFS command = new ReadBlobCommandGridFS(this.gridFS, blobId, blobOffset, buffer, bufferOffset, length);
        return this.commandExecutor.execute(command);
    }

    @Override
    public String writeBlob(InputStream is) throws IOException {
        WriteBlobCommandGridFS command = new WriteBlobCommandGridFS(this.gridFS, is);
        return this.commandExecutor.execute(command);
    }
}

