/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.blob.ReferenceCollector;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.segment.ListRecord;
import org.apache.jackrabbit.oak.plugins.segment.MapRecord;
import org.apache.jackrabbit.oak.plugins.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentBlob;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStream;
import org.apache.jackrabbit.oak.plugins.segment.SegmentTracker;
import org.apache.jackrabbit.oak.plugins.segment.Template;

public class Segment {
    static final int RECORD_ID_BYTES = 3;
    static final int SEGMENT_REFERENCE_LIMIT = 255;
    static final int RECORD_ALIGN_BITS = 2;
    public static final int MAX_SEGMENT_SIZE = 262144;
    static final int SMALL_LIMIT = 128;
    static final int MEDIUM_LIMIT = 16512;
    public static int REF_COUNT_OFFSET = 5;
    static int ROOT_COUNT_OFFSET = 6;
    static int BLOBREF_COUNT_OFFSET = 8;
    private final SegmentTracker tracker;
    private final SegmentId id;
    private final ByteBuffer data;
    private final SegmentId[] refids;
    private final ConcurrentMap<Integer, String> strings = Maps.newConcurrentMap();
    private final ConcurrentMap<Integer, Template> templates = Maps.newConcurrentMap();
    private volatile long accessed = 0L;

    public Segment(SegmentTracker tracker, SegmentId id, ByteBuffer data) {
        this.tracker = Preconditions.checkNotNull(tracker);
        this.id = Preconditions.checkNotNull(id);
        this.data = Preconditions.checkNotNull(data);
        if (id.isDataSegmentId()) {
            Preconditions.checkState(data.get(0) == 48 && data.get(1) == 97 && data.get(2) == 75 && data.get(3) == 10);
            this.refids = new SegmentId[this.getRefCount()];
            this.refids[0] = id;
        } else {
            this.refids = null;
        }
    }

    Segment(SegmentTracker tracker, byte[] buffer) {
        this.tracker = Preconditions.checkNotNull(tracker);
        this.id = tracker.newDataSegmentId();
        this.data = ByteBuffer.wrap(Preconditions.checkNotNull(buffer));
        this.refids = new SegmentId[256];
        this.refids[0] = this.id;
    }

    void access() {
        ++this.accessed;
    }

    boolean accessed() {
        this.accessed >>>= 1;
        return this.accessed != 0L;
    }

    private int pos(int offset, int length) {
        Preconditions.checkPositionIndexes(offset, offset + length, 262144);
        int pos = this.data.limit() - 262144 + offset;
        Preconditions.checkState(pos >= this.data.position());
        return pos;
    }

    public SegmentId getSegmentId() {
        return this.id;
    }

    int getRefCount() {
        return (this.data.get(REF_COUNT_OFFSET) & 0xFF) + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SegmentId getRefId(int index) {
        SegmentId refid = this.refids[index];
        if (refid == null) {
            Segment segment = this;
            synchronized (segment) {
                refid = this.refids[index];
                if (refid == null) {
                    int refpos = this.data.position() + index * 16;
                    long msb = this.data.getLong(refpos);
                    long lsb = this.data.getLong(refpos + 8);
                    this.refids[index] = refid = this.tracker.getSegmentId(msb, lsb);
                }
            }
        }
        return refid;
    }

    public List<SegmentId> getReferencedIds() {
        int refcount = this.getRefCount();
        ArrayList<SegmentId> ids = Lists.newArrayListWithCapacity(refcount);
        for (int refid = 0; refid < refcount; ++refid) {
            ids.add(this.getRefId(refid));
        }
        return ids;
    }

    public int size() {
        return this.data.remaining();
    }

    public long getCacheSize() {
        int size = 1024;
        if (!this.data.isDirect()) {
            size += this.size();
        }
        if (this.id.isDataSegmentId()) {
            size += this.size();
        }
        return size;
    }

    public void writeTo(OutputStream stream) throws IOException {
        ByteBuffer buffer = this.data.duplicate();
        WritableByteChannel channel = Channels.newChannel(stream);
        while (buffer.hasRemaining()) {
            channel.write(buffer);
        }
    }

    void collectBlobReferences(ReferenceCollector collector) {
        int refcount = this.getRefCount();
        int rootcount = this.data.getShort(this.data.position() + ROOT_COUNT_OFFSET) & 0xFFFF;
        int blobrefcount = this.data.getShort(this.data.position() + BLOBREF_COUNT_OFFSET) & 0xFFFF;
        int blobrefpos = this.data.position() + refcount * 16 + rootcount * 3;
        for (int i = 0; i < blobrefcount; ++i) {
            int offset = (this.data.getShort(blobrefpos + i * 2) & 0xFFFF) << 2;
            SegmentBlob blob = new SegmentBlob(new RecordId(this.id, offset));
            collector.addReference(blob.getBlobId());
        }
    }

    byte readByte(int offset) {
        return this.data.get(this.pos(offset, 1));
    }

    short readShort(int offset) {
        return this.data.getShort(this.pos(offset, 2));
    }

    int readInt(int offset) {
        return this.data.getInt(this.pos(offset, 4));
    }

    long readLong(int offset) {
        return this.data.getLong(this.pos(offset, 8));
    }

    void readBytes(int position, byte[] buffer, int offset, int length) {
        Preconditions.checkNotNull(buffer);
        Preconditions.checkPositionIndexes(offset, offset + length, buffer.length);
        ByteBuffer d = this.data.duplicate();
        d.position(this.pos(position, length));
        d.get(buffer, offset, length);
    }

    RecordId readRecordId(int offset) {
        int pos = this.pos(offset, 3);
        return this.internalReadRecordId(pos);
    }

    private RecordId internalReadRecordId(int pos) {
        SegmentId refid = this.getRefId(this.data.get(pos) & 0xFF);
        int offset = (this.data.get(pos + 1) & 0xFF) << 8 | this.data.get(pos + 2) & 0xFF;
        return new RecordId(refid, offset << 2);
    }

    String readString(RecordId id) {
        return id.getSegmentId().getSegment().readString(id.getOffset());
    }

    private String readString(int offset) {
        String string = (String)this.strings.get(offset);
        if (string == null) {
            string = this.loadString(offset);
            this.strings.putIfAbsent(offset, string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadString(int offset) {
        int pos = this.pos(offset, 1);
        long length = this.internalReadLength(pos);
        if (length < 128L) {
            byte[] bytes = new byte[(int)length];
            ByteBuffer buffer = this.data.duplicate();
            buffer.position(pos + 1);
            buffer.get(bytes);
            return new String(bytes, Charsets.UTF_8);
        }
        if (length < 16512L) {
            byte[] bytes = new byte[(int)length];
            ByteBuffer buffer = this.data.duplicate();
            buffer.position(pos + 2);
            buffer.get(bytes);
            return new String(bytes, Charsets.UTF_8);
        }
        if (length < Integer.MAX_VALUE) {
            int size = (int)((length + 4096L - 1L) / 4096L);
            ListRecord list = new ListRecord(this.internalReadRecordId(pos + 8), size);
            SegmentStream stream = new SegmentStream(new RecordId(this.id, offset), list, length);
            try {
                String string = stream.getString();
                return string;
            }
            finally {
                stream.close();
            }
        }
        throw new IllegalStateException("String is too long: " + length);
    }

    MapRecord readMap(RecordId id) {
        return new MapRecord(id);
    }

    Template readTemplate(RecordId id) {
        return id.getSegment().readTemplate(id.getOffset());
    }

    private Template readTemplate(int offset) {
        Template template = (Template)this.templates.get(offset);
        if (template == null) {
            template = this.loadTemplate(offset);
            this.templates.putIfAbsent(offset, template);
        }
        return template;
    }

    private Template loadTemplate(int offset) {
        int head = this.readInt(offset);
        boolean hasPrimaryType = (head & Integer.MIN_VALUE) != 0;
        boolean hasMixinTypes = (head & 0x40000000) != 0;
        boolean zeroChildNodes = (head & 0x20000000) != 0;
        boolean manyChildNodes = (head & 0x10000000) != 0;
        int mixinCount = head >> 18 & 0x3FF;
        int propertyCount = head & 0x3FFFF;
        offset += 4;
        PropertyState primaryType = null;
        if (hasPrimaryType) {
            RecordId primaryId = this.readRecordId(offset);
            primaryType = PropertyStates.createProperty("jcr:primaryType", (Object)this.readString(primaryId), Type.NAME);
            offset += 3;
        }
        PropertyState mixinTypes = null;
        if (hasMixinTypes) {
            String[] mixins = new String[mixinCount];
            for (int i = 0; i < mixins.length; ++i) {
                RecordId mixinId = this.readRecordId(offset);
                mixins[i] = this.readString(mixinId);
                offset += 3;
            }
            mixinTypes = PropertyStates.createProperty("jcr:mixinTypes", Arrays.asList(mixins), Type.NAMES);
        }
        String childName = Template.ZERO_CHILD_NODES;
        if (manyChildNodes) {
            childName = "";
        } else if (!zeroChildNodes) {
            RecordId childNameId = this.readRecordId(offset);
            childName = this.readString(childNameId);
            offset += 3;
        }
        PropertyTemplate[] properties = new PropertyTemplate[propertyCount];
        for (int i = 0; i < properties.length; ++i) {
            RecordId propertyNameId = this.readRecordId(offset);
            offset += 3;
            byte type = this.readByte(offset++);
            properties[i] = new PropertyTemplate(i, this.readString(propertyNameId), Type.fromTag(Math.abs(type), type < 0));
        }
        return new Template(primaryType, mixinTypes, properties, childName);
    }

    long readLength(RecordId id) {
        return id.getSegment().readLength(id.getOffset());
    }

    long readLength(int offset) {
        return this.internalReadLength(this.pos(offset, 1));
    }

    private long internalReadLength(int pos) {
        int length;
        if (((length = this.data.get(pos++) & 0xFF) & 0x80) == 0) {
            return length;
        }
        if ((length & 0x40) == 0) {
            return ((length & 0x3F) << 8 | this.data.get(pos++) & 0xFF) + 128;
        }
        return (((long)length & 0x3FL) << 56 | (long)(this.data.get(pos++) & 0xFF) << 48 | (long)(this.data.get(pos++) & 0xFF) << 40 | (long)(this.data.get(pos++) & 0xFF) << 32 | (long)(this.data.get(pos++) & 0xFF) << 24 | (long)(this.data.get(pos++) & 0xFF) << 16 | (long)(this.data.get(pos++) & 0xFF) << 8 | (long)(this.data.get(pos++) & 0xFF)) + 16512L;
    }

    public String toString() {
        StringWriter string = new StringWriter();
        PrintWriter writer = new PrintWriter(string);
        int length = this.data.remaining();
        writer.format("Segment %s (%d bytes)%n", this.id, length);
        writer.println("--------------------------------------------------------------------------");
        int refcount = this.getRefCount();
        for (int refid = 0; refid < refcount; ++refid) {
            writer.format("reference %02x: %s%n", refid, this.getRefId(refid));
        }
        writer.println("--------------------------------------------------------------------------");
        for (int pos = this.data.limit() - (length + 15 & 0xFFFFFFF0); pos < this.data.limit(); pos += 16) {
            byte b;
            int i;
            writer.format("%04x: ", 262144 - this.data.limit() + pos >> 2);
            for (i = 0; i < 16; ++i) {
                if (i > 0 && i % 4 == 0) {
                    writer.append(' ');
                }
                if (pos + i >= this.data.position()) {
                    b = this.data.get(pos + i);
                    writer.format("%02x ", b & 0xFF);
                    continue;
                }
                writer.append("   ");
            }
            writer.append(' ');
            for (i = 0; i < 16; ++i) {
                if (pos + i >= this.data.position()) {
                    b = this.data.get(pos + i);
                    if (b >= 32 && b < 127) {
                        writer.append((char)b);
                        continue;
                    }
                    writer.append('.');
                    continue;
                }
                writer.append(' ');
            }
            writer.println();
        }
        writer.println("--------------------------------------------------------------------------");
        writer.close();
        return string.toString();
    }
}

