/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.principal;

import java.security.Principal;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;

public class PrincipalManagerImpl
implements PrincipalManager {
    private final PrincipalProvider principalProvider;

    public PrincipalManagerImpl(@Nonnull PrincipalProvider principalProvider) {
        this.principalProvider = principalProvider;
    }

    @Override
    public boolean hasPrincipal(@Nonnull String principalName) {
        return this.principalProvider.getPrincipal(principalName) != null;
    }

    @Override
    @CheckForNull
    public Principal getPrincipal(@Nonnull String principalName) {
        return this.principalProvider.getPrincipal(principalName);
    }

    @Override
    @Nonnull
    public PrincipalIterator findPrincipals(@Nullable String simpleFilter) {
        return this.findPrincipals(simpleFilter, 3);
    }

    @Override
    @Nonnull
    public PrincipalIterator findPrincipals(@Nullable String simpleFilter, int searchType) {
        return new PrincipalIteratorAdapter(this.principalProvider.findPrincipals(simpleFilter, searchType));
    }

    @Override
    @Nonnull
    public PrincipalIterator getPrincipals(int searchType) {
        return new PrincipalIteratorAdapter(this.principalProvider.findPrincipals(searchType));
    }

    @Override
    @Nonnull
    public PrincipalIterator getGroupMembership(@Nonnull Principal principal) {
        return new PrincipalIteratorAdapter(this.principalProvider.getGroupMembership(principal));
    }

    @Override
    @Nonnull
    public Principal getEveryone() {
        Principal everyone = this.getPrincipal("everyone");
        if (everyone == null) {
            everyone = EveryonePrincipal.getInstance();
        }
        return everyone;
    }
}

