/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.endpoint.kv.ErrorMap;
import com.couchbase.client.core.endpoint.kv.KeyValueStatus;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.ResponseStatus;

public class ResponseStatusConverter {
    private static volatile ErrorMap BINARY_ERROR_MAP = null;
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ResponseStatusConverter.class);
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_INTERNAL_ERROR = 500;

    public static ResponseStatus fromBinary(short code) {
        KeyValueStatus status = KeyValueStatus.valueOf(code);
        switch (status) {
            case SUCCESS: {
                return ResponseStatus.SUCCESS;
            }
            case ERR_EXISTS: {
                return ResponseStatus.EXISTS;
            }
            case ERR_NOT_FOUND: {
                return ResponseStatus.NOT_EXISTS;
            }
            case ERR_NOT_MY_VBUCKET: {
                return ResponseStatus.RETRY;
            }
            case ERR_NOT_STORED: {
                return ResponseStatus.NOT_STORED;
            }
            case ERR_TOO_BIG: {
                return ResponseStatus.TOO_BIG;
            }
            case ERR_TEMP_FAIL: {
                return ResponseStatus.TEMPORARY_FAILURE;
            }
            case ERR_BUSY: {
                return ResponseStatus.SERVER_BUSY;
            }
            case ERR_NO_MEM: {
                return ResponseStatus.OUT_OF_MEMORY;
            }
            case ERR_UNKNOWN_COMMAND: {
                return ResponseStatus.COMMAND_UNAVAILABLE;
            }
            case ERR_NOT_SUPPORTED: {
                return ResponseStatus.COMMAND_UNAVAILABLE;
            }
            case ERR_ACCESS: {
                return ResponseStatus.ACCESS_ERROR;
            }
            case ERR_INTERNAL: {
                return ResponseStatus.INTERNAL_ERROR;
            }
            case ERR_INVALID: {
                return ResponseStatus.INVALID_ARGUMENTS;
            }
            case ERR_DELTA_BADVAL: {
                return ResponseStatus.INVALID_ARGUMENTS;
            }
            case ERR_RANGE: {
                return ResponseStatus.RANGE_ERROR;
            }
            case ERR_ROLLBACK: {
                return ResponseStatus.ROLLBACK;
            }
            case ERR_SUBDOC_PATH_NOT_FOUND: {
                return ResponseStatus.SUBDOC_PATH_NOT_FOUND;
            }
            case ERR_SUBDOC_PATH_MISMATCH: {
                return ResponseStatus.SUBDOC_PATH_MISMATCH;
            }
            case ERR_SUBDOC_PATH_INVALID: {
                return ResponseStatus.SUBDOC_PATH_INVALID;
            }
            case ERR_SUBDOC_PATH_TOO_BIG: {
                return ResponseStatus.SUBDOC_PATH_TOO_BIG;
            }
            case ERR_SUBDOC_DOC_TOO_DEEP: {
                return ResponseStatus.SUBDOC_DOC_TOO_DEEP;
            }
            case ERR_SUBDOC_VALUE_CANTINSERT: {
                return ResponseStatus.SUBDOC_VALUE_CANTINSERT;
            }
            case ERR_SUBDOC_DOC_NOT_JSON: {
                return ResponseStatus.SUBDOC_DOC_NOT_JSON;
            }
            case ERR_SUBDOC_NUM_RANGE: {
                return ResponseStatus.SUBDOC_NUM_RANGE;
            }
            case ERR_SUBDOC_DELTA_RANGE: {
                return ResponseStatus.SUBDOC_DELTA_RANGE;
            }
            case ERR_SUBDOC_PATH_EXISTS: {
                return ResponseStatus.SUBDOC_PATH_EXISTS;
            }
            case ERR_SUBDOC_VALUE_TOO_DEEP: {
                return ResponseStatus.SUBDOC_VALUE_TOO_DEEP;
            }
            case ERR_SUBDOC_INVALID_COMBO: {
                return ResponseStatus.SUBDOC_INVALID_COMBO;
            }
            case ERR_SUBDOC_MULTI_PATH_FAILURE: {
                return ResponseStatus.SUBDOC_MULTI_PATH_FAILURE;
            }
            case ERR_SUBDOC_XATTR_INVALID_FLAG_COMBO: {
                return ResponseStatus.INTERNAL_ERROR;
            }
            case ERR_SUBDOC_XATTR_UNKNOWN_MACRO: {
                return ResponseStatus.SUBDOC_XATTR_UNKNOWN_MACRO;
            }
            case ERR_SUBDOC_XATTR_INVALID_KEY_COMBO: {
                return ResponseStatus.SUBDOC_XATTR_INVALID_KEY_COMBO;
            }
        }
        if (BINARY_ERROR_MAP == null) {
            LOGGER.warn("Unexpected ResponseStatus with Protocol KeyValue: {} (0x{}, {})", new Object[]{status, Integer.toHexString(status.code()), status.description()});
            return ResponseStatus.FAILURE;
        }
        ErrorMap.ErrorCode result = BINARY_ERROR_MAP.errors().get(status.code());
        if (result == null) {
            LOGGER.warn("Unexpected ResponseStatus with Protocol KeyValue and not found in Error Map: {} (0x{}, {})", new Object[]{status, Integer.toHexString(status.code()), status.description()});
        } else {
            LOGGER.warn("Unexpected ResponseStatus with Extended Error {}", (Object)result.toString());
        }
        return ResponseStatus.FAILURE;
    }

    public static ResponseStatus fromHttp(int code) {
        ResponseStatus status;
        switch (code) {
            case 200: 
            case 201: 
            case 202: {
                status = ResponseStatus.SUCCESS;
                break;
            }
            case 404: {
                status = ResponseStatus.NOT_EXISTS;
                break;
            }
            case 400: {
                status = ResponseStatus.INVALID_ARGUMENTS;
                break;
            }
            case 500: {
                status = ResponseStatus.INTERNAL_ERROR;
                break;
            }
            default: {
                LOGGER.warn("Unknown ResponseStatus with Protocol HTTP: {}", (Object)code);
                status = ResponseStatus.FAILURE;
            }
        }
        return status;
    }

    public static void updateBinaryErrorMap(ErrorMap map) {
        if (map == null) {
            return;
        }
        if (BINARY_ERROR_MAP == null || map.compareTo(BINARY_ERROR_MAP) > 0) {
            BINARY_ERROR_MAP = map;
        }
    }

    public static ErrorMap getBinaryErrorMap() {
        return BINARY_ERROR_MAP;
    }
}

