/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.insert.storage.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.accounting.insert.storage.utils.ContextUtility;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialService {
    private static final String RESOURCE = "jersey-servlet";
    private static final String SERVICE_NAME = "SocialNetworking";
    private static final String SERVICE_CLASSE = "Portal";
    private static Logger logger = LoggerFactory.getLogger(SocialService.class);
    private String serviceBasePath;
    private static Map<String, SocialService> socialServicePerContext = new HashMap<String, SocialService>();

    public static SocialService getSocialService() throws Exception {
        String contex = ContextUtility.getCurrentContext();
        SocialService socialService = socialServicePerContext.get(contex);
        if (socialService == null) {
            socialService = new SocialService();
            socialServicePerContext.put(contex, socialService);
        }
        return socialService;
    }

    private SocialService() throws Exception {
        this.getServiceBasePathViaGCoreEndpoint();
    }

    protected void getServiceBasePathViaGCoreEndpoint() throws Exception {
        try {
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            query.addCondition(String.format("$resource/Profile/ServiceClass/text() eq '%s'", SERVICE_CLASSE));
            query.addCondition("$resource/Profile/DeploymentData/Status/text() eq 'ready'");
            query.addCondition(String.format("$resource/Profile/ServiceName/text() eq '%s'", SERVICE_NAME));
            query.setResult("$resource/Profile/AccessPoint/RunningInstanceInterfaces//Endpoint[@EntryName/string() eq \"jersey-servlet\"]/text()");
            DiscoveryClient client = ICFactory.client();
            List endpoints = client.submit((Query)query);
            if (endpoints == null || endpoints.isEmpty()) {
                throw new Exception("Cannot retrieve the GCoreEndpoint SERVICE_NAME: SocialNetworking, SERVICE_CLASSE: Portal, in scope: " + ContextUtility.getCurrentContext());
            }
            this.serviceBasePath = (String)endpoints.get(0);
            if (this.serviceBasePath == null) {
                throw new Exception("Endpoint:jersey-servlet, is null for SERVICE_NAME: SocialNetworking, SERVICE_CLASSE: Portal, in scope: " + ContextUtility.getCurrentContext());
            }
            this.serviceBasePath = this.serviceBasePath.endsWith("/") ? this.serviceBasePath : this.serviceBasePath + "/";
        }
        catch (Exception e) {
            String error = "An error occurred during GCoreEndpoint discovery, SERVICE_NAME: SocialNetworking, SERVICE_CLASSE: Portal, in scope: " + ContextUtility.getCurrentContext() + ".";
            logger.error(error, (Throwable)e);
            throw new Exception(error);
        }
    }

    public String getServiceBasePath() {
        return this.serviceBasePath;
    }
}

