/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import java.util.Set;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeEditor;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeRegistration;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

@Component
@Service(value={EditorProvider.class})
public class TypeEditorProvider
implements EditorProvider {
    private final boolean strict;

    public TypeEditorProvider(boolean strict) {
        this.strict = strict;
    }

    public TypeEditorProvider() {
        this(true);
    }

    @Override
    public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) throws CommitFailedException {
        NodeState beforeTypes = before.getChildNode("jcr:system").getChildNode("jcr:nodeTypes");
        NodeState afterTypes = after.getChildNode("jcr:system").getChildNode("jcr:nodeTypes");
        String primary = after.getName("jcr:primaryType");
        Iterable<String> mixins = after.getNames("jcr:mixinTypes");
        TypeRegistration registration = new TypeRegistration();
        afterTypes.compareAgainstBaseState(beforeTypes, registration);
        if (registration.isModified()) {
            VisibleEditor editor;
            CommitFailedException exception;
            afterTypes = registration.apply(builder);
            Set<String> modifiedTypes = registration.getModifiedTypes(beforeTypes);
            if (!modifiedTypes.isEmpty() && (exception = EditorDiff.process(editor = new VisibleEditor(new TypeEditor(this.strict, modifiedTypes, afterTypes, primary, mixins, builder)), EmptyNodeState.MISSING_NODE, after)) != null) {
                throw exception;
            }
        }
        return new VisibleEditor(new TypeEditor(this.strict, null, afterTypes, primary, mixins, builder));
    }
}

