/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication;

import java.security.AccessController;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.security.authentication.CallbackHandlerImpl;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.JaasLoginContext;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginContext;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginContextProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.PreAuthContext;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoginContextProviderImpl
implements LoginContextProvider {
    private static final Logger log = LoggerFactory.getLogger(LoginContextProviderImpl.class);
    private final String appName;
    private final Configuration configuration;
    private final ContentRepository contentRepository;
    private final SecurityProvider securityProvider;
    private final Whiteboard whiteboard;

    LoginContextProviderImpl(String appName, Configuration configuration, ContentRepository contentRepository, SecurityProvider securityProvider, Whiteboard whiteboard) {
        this.appName = appName;
        this.configuration = configuration;
        this.contentRepository = contentRepository;
        this.securityProvider = securityProvider;
        this.whiteboard = whiteboard;
    }

    @Override
    @Nonnull
    public LoginContext getLoginContext(Credentials credentials, String workspaceName) throws LoginException {
        Subject subject = LoginContextProviderImpl.getSubject();
        if (subject != null && credentials == null) {
            log.debug("Found pre-authenticated subject: No further login actions required.");
            return new PreAuthContext(subject);
        }
        if (subject == null) {
            subject = new Subject();
        }
        CallbackHandler handler = this.getCallbackHandler(credentials, workspaceName);
        return new JaasLoginContext(this.appName, subject, handler, this.configuration);
    }

    @CheckForNull
    private static Subject getSubject() {
        Subject subject = null;
        try {
            subject = Subject.getSubject(AccessController.getContext());
        }
        catch (SecurityException e) {
            log.debug("Can't check for pre-authenticated subject. Reason:", (Object)e.getMessage());
        }
        return subject;
    }

    @Nonnull
    private CallbackHandler getCallbackHandler(Credentials credentials, String workspaceName) {
        return new CallbackHandlerImpl(credentials, workspaceName, this.contentRepository, this.securityProvider, this.whiteboard);
    }
}

