/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import com.thoughtworks.xstream.XStream;
import java.util.Calendar;
import java.util.Map;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.accounting.AccountingProperty;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryRemoval;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public class JCRAccountingFolderEntryRemoval
extends JCRAccountingEntry
implements AccountingEntryRemoval {
    protected final WorkspaceItemType itemType;
    protected final FolderItemType folderItemType;
    protected final String itemName;
    protected final String mimeType;

    public JCRAccountingFolderEntryRemoval(AccountingDelegate node) throws RepositoryException {
        super(node);
        this.itemName = (String)new XStream().fromXML(node.getAccountingProperties().get((Object)AccountingProperty.ITEM_NAME));
        this.itemType = (WorkspaceItemType)new XStream().fromXML(node.getAccountingProperties().get((Object)AccountingProperty.ITEM_TYPE));
        this.folderItemType = (FolderItemType)new XStream().fromXML(node.getAccountingProperties().get((Object)AccountingProperty.FOLDER_ITEM_TYPE));
        this.mimeType = (String)new XStream().fromXML(node.getAccountingProperties().get((Object)AccountingProperty.MIME_TYPE));
    }

    public JCRAccountingFolderEntryRemoval(String id, String user, Calendar date, WorkspaceItemType itemType, FolderItemType folderItemType, String itemName, String mimeType) {
        super(id, user, date);
        this.itemName = itemName;
        this.folderItemType = folderItemType;
        this.itemType = itemType;
        this.mimeType = mimeType;
        Map<AccountingProperty, String> properties = this.entryDelegate.getAccountingProperties();
        properties.put(AccountingProperty.ITEM_NAME, new XStream().toXML(itemName));
        properties.put(AccountingProperty.FOLDER_ITEM_TYPE, new XStream().toXML(folderItemType));
        properties.put(AccountingProperty.ITEM_TYPE, new XStream().toXML(itemType));
        properties.put(AccountingProperty.MIME_TYPE, new XStream().toXML(mimeType));
        this.entryDelegate.setEntryType(AccountingEntryType.REMOVAL);
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.REMOVAL;
    }

    @Override
    public WorkspaceItemType getItemType() {
        return this.itemType;
    }

    @Override
    public FolderItemType getFolderItemType() {
        return this.folderItemType;
    }

    @Override
    public String getItemName() {
        return this.itemName;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public String toString() {
        String parentValue = super.toString();
        return String.format("[%s [%s, itemName:%s, itemType:%s, folderItemType:%s, mimeType:%s]]", new Object[]{parentValue, AccountingEntryType.REMOVAL, this.itemName, this.itemType, this.folderItemType, this.mimeType});
    }
}

