/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseMessage;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.internal.SignalConfigReload;
import com.couchbase.client.core.message.kv.BinaryResponse;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.deps.com.lmax.disruptor.EventHandler;
import com.couchbase.client.deps.com.lmax.disruptor.EventTranslatorTwoArg;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.functions.Action0;
import rx.subjects.Subject;

public class ResponseHandler
implements EventHandler<ResponseEvent> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ResponseHandler.class);
    private final ClusterFacade cluster;
    private final ConfigurationProvider configurationProvider;
    private final CoreEnvironment environment;
    private final boolean traceLoggingEnabled;
    private final int nmvbRetryDelay;
    public static final EventTranslatorTwoArg<ResponseEvent, CouchbaseMessage, Subject<CouchbaseResponse, CouchbaseResponse>> RESPONSE_TRANSLATOR = new EventTranslatorTwoArg<ResponseEvent, CouchbaseMessage, Subject<CouchbaseResponse, CouchbaseResponse>>(){

        @Override
        public void translateTo(ResponseEvent event, long sequence, CouchbaseMessage message, Subject<CouchbaseResponse, CouchbaseResponse> observable) {
            event.setMessage(message);
            event.setObservable(observable);
        }
    };

    public ResponseHandler(CoreEnvironment environment, ClusterFacade cluster, ConfigurationProvider provider) {
        this.cluster = cluster;
        this.configurationProvider = provider;
        this.environment = environment;
        this.nmvbRetryDelay = Integer.parseInt(System.getProperty("com.couchbase.nmvbRetryDelay", "100"));
        this.traceLoggingEnabled = LOGGER.isTraceEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(ResponseEvent event, long sequence, boolean endOfBatch) throws Exception {
        block8: {
            try {
                CouchbaseMessage message = event.getMessage();
                if (message instanceof SignalConfigReload) {
                    this.configurationProvider.signalOutdated();
                    break block8;
                }
                if (message instanceof CouchbaseResponse) {
                    final CouchbaseResponse response = (CouchbaseResponse)message;
                    ResponseStatus status = response.status();
                    if (status == ResponseStatus.RETRY) {
                        this.retry(event, true);
                    } else {
                        final Scheduler.Worker worker = this.environment.scheduler().createWorker();
                        final Subject<CouchbaseResponse, CouchbaseResponse> obs = event.getObservable();
                        worker.schedule(new Action0(){

                            @Override
                            public void call() {
                                try {
                                    obs.onNext(response);
                                    obs.onCompleted();
                                }
                                catch (Exception ex) {
                                    obs.onError(ex);
                                }
                                finally {
                                    worker.unsubscribe();
                                }
                            }
                        });
                    }
                    break block8;
                }
                if (message instanceof CouchbaseRequest) {
                    this.retry(event, false);
                    break block8;
                }
                throw new IllegalStateException("Got message type I do not understand: " + message);
            }
            finally {
                event.setMessage(null);
                event.setObservable(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retry(ResponseEvent event, boolean isNotMyVbucket) {
        CouchbaseMessage message = event.getMessage();
        if (message instanceof CouchbaseRequest) {
            this.scheduleForRetry((CouchbaseRequest)message, isNotMyVbucket);
        } else {
            BinaryResponse response;
            CouchbaseRequest request = ((CouchbaseResponse)message).request();
            if (request != null) {
                this.scheduleForRetry(request, isNotMyVbucket);
            } else {
                event.getObservable().onError(new CouchbaseException("Operation failed because it does not support cloning."));
            }
            if (message instanceof BinaryResponse && (response = (BinaryResponse)message).content() != null && response.content().readableBytes() > 0) {
                try {
                    String config = response.content().toString(CharsetUtil.UTF_8).trim();
                    if (config.startsWith("{")) {
                        this.configurationProvider.proposeBucketConfig(response.bucket(), config);
                    }
                }
                finally {
                    response.content().release();
                }
            }
        }
    }

    private void scheduleForRetry(final CouchbaseRequest request, boolean isNotMyVbucket) {
        TimeUnit delayUnit;
        long delayTime;
        CoreEnvironment env = this.environment;
        Delay delay = env.retryDelay();
        if (isNotMyVbucket) {
            boolean hasFastForward = ResponseHandler.bucketHasFastForwardMap(request.bucket(), this.configurationProvider.config());
            delayTime = request.incrementRetryCount() == 0 && hasFastForward ? 0L : (long)this.nmvbRetryDelay;
            delayUnit = TimeUnit.MILLISECONDS;
        } else {
            delayTime = delay.calculate(request.incrementRetryCount());
            delayUnit = delay.unit();
        }
        if (this.traceLoggingEnabled) {
            LOGGER.trace("Retrying {} with a delay of {} {}", new Object[]{request, delayTime, delayUnit});
        }
        final Scheduler.Worker worker = env.scheduler().createWorker();
        worker.schedule(new Action0(){

            @Override
            public void call() {
                try {
                    ResponseHandler.this.cluster.send(request);
                }
                finally {
                    worker.unsubscribe();
                }
            }
        }, delayTime, delayUnit);
    }

    private static boolean bucketHasFastForwardMap(String bucketName, ClusterConfig clusterConfig) {
        if (bucketName == null) {
            return false;
        }
        BucketConfig bucketConfig = clusterConfig.bucketConfig(bucketName);
        return bucketConfig != null && bucketConfig.hasFastForwardMap();
    }
}

