/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.core.ImportList;
import lombok.core.LombokInternalAliasing;
import lombok.eclipse.Eclipse;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseImportList
implements ImportList {
    private ImportReference[] imports;
    private ImportReference pkg;

    public EclipseImportList(CompilationUnitDeclaration cud) {
        this.pkg = cud.currentPackage;
        this.imports = cud.imports;
    }

    @Override
    public String getFullyQualifiedNameForSimpleName(String unqualified) {
        if (this.imports != null) {
            block0: for (ImportReference imp : this.imports) {
                char[][] tokens;
                char[] token;
                int len;
                if ((imp.bits & 0x20000) != 0 || (len = (token = (tokens = imp.tokens).length == 0 ? new char[]{} : tokens[tokens.length - 1]).length) != unqualified.length()) continue;
                for (int i = 0; i < len; ++i) {
                    if (token[i] != unqualified.charAt(i)) continue block0;
                }
                return LombokInternalAliasing.processAliases(Eclipse.toQualifiedName(tokens));
            }
        }
        return null;
    }

    @Override
    public boolean hasStarImport(String packageName) {
        if (EclipseImportList.isEqual(packageName, this.pkg)) {
            return true;
        }
        if ("java.lang".equals(packageName)) {
            return true;
        }
        if (this.pkg != null && this.pkg.tokens != null && this.pkg.tokens.length == 0) {
            for (Map.Entry<String, Collection<String>> e : LombokInternalAliasing.IMPLIED_EXTRA_STAR_IMPORTS.entrySet()) {
                if (!EclipseImportList.isEqual(e.getKey(), this.pkg) || !e.getValue().contains(packageName)) continue;
                return true;
            }
        }
        if (this.imports != null) {
            for (ImportReference imp : this.imports) {
                if ((imp.bits & 0x20000) == 0 || imp.isStatic()) continue;
                if (EclipseImportList.isEqual(packageName, imp)) {
                    return true;
                }
                for (Map.Entry<String, Collection<String>> e : LombokInternalAliasing.IMPLIED_EXTRA_STAR_IMPORTS.entrySet()) {
                    if (!EclipseImportList.isEqual(e.getKey(), imp) || !e.getValue().contains(packageName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isEqual(String packageName, ImportReference pkgOrStarImport) {
        if (pkgOrStarImport == null || pkgOrStarImport.tokens == null || pkgOrStarImport.tokens.length == 0) {
            return packageName.isEmpty();
        }
        int pos = 0;
        int len = packageName.length();
        for (int i = 0; i < pkgOrStarImport.tokens.length; ++i) {
            if (i != 0) {
                if (pos >= len) {
                    return false;
                }
                if (packageName.charAt(pos++) != '.') {
                    return false;
                }
            }
            for (int j = 0; j < pkgOrStarImport.tokens[i].length; ++j) {
                if (pos >= len) {
                    return false;
                }
                if (packageName.charAt(pos++) == pkgOrStarImport.tokens[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Collection<String> applyNameToStarImports(String startsWith, String name) {
        List<String> out = Collections.emptyList();
        if (this.pkg != null && this.pkg.tokens != null && this.pkg.tokens.length != 0) {
            char[] first = this.pkg.tokens[0];
            int len = first.length;
            boolean match = true;
            if (startsWith.length() == len) {
                for (int i = 0; match && i < len; ++i) {
                    if (startsWith.charAt(i) == first[i]) continue;
                    match = false;
                }
                if (match) {
                    out.add(Eclipse.toQualifiedName(this.pkg.tokens) + "." + name);
                }
            }
        }
        if (this.imports != null) {
            block1: for (ImportReference imp : this.imports) {
                char[] firstToken;
                if ((imp.bits & 0x20000) == 0 || imp.isStatic() || imp.tokens == null || imp.tokens.length == 0 || (firstToken = imp.tokens[0]).length != startsWith.length()) continue;
                for (int i = 0; i < firstToken.length; ++i) {
                    if (startsWith.charAt(i) != firstToken[i]) continue block1;
                }
                String fqn = Eclipse.toQualifiedName(imp.tokens) + "." + name;
                if (out.isEmpty()) {
                    out = Collections.singletonList(fqn);
                    continue;
                }
                if (out.size() == 1) {
                    out = new ArrayList<String>(out);
                    out.add(fqn);
                    continue;
                }
                out.add(fqn);
            }
        }
        return out;
    }

    @Override
    public String applyUnqualifiedNameToPackage(String unqualified) {
        if (this.pkg == null || this.pkg.tokens == null || this.pkg.tokens.length == 0) {
            return unqualified;
        }
        return Eclipse.toQualifiedName(this.pkg.tokens) + "." + unqualified;
    }
}

