/*
 * Decompiled with CFR 0.152.
 */
package lombok.patcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hook {
    @NonNull
    private final String className;
    @NonNull
    private final String methodName;
    @NonNull
    private final String returnType;
    @NonNull
    private final List<String> parameterTypes;
    private static final Map<String, String> PRIMITIVES;

    public boolean isConstructor() {
        return "<init>".equals(this.methodName);
    }

    public Hook(String className, String methodName, String returnType2, String ... parameterTypes) {
        if (className == null) {
            throw new NullPointerException("classSpec");
        }
        if (methodName == null) {
            throw new NullPointerException("methodName");
        }
        if (returnType2 == null) {
            throw new NullPointerException("returnType");
        }
        if (parameterTypes == null) {
            throw new NullPointerException("parameterTypes");
        }
        this.className = className;
        this.methodName = methodName;
        this.returnType = returnType2;
        ArrayList<String> params = new ArrayList<String>();
        for (String param : parameterTypes) {
            params.add(param);
        }
        this.parameterTypes = Collections.unmodifiableList(params);
    }

    public String getClassSpec() {
        return Hook.convertType(this.className);
    }

    public String getMethodDescriptor() {
        StringBuilder out = new StringBuilder();
        out.append("(");
        for (String p : this.parameterTypes) {
            out.append(Hook.toSpec(p));
        }
        out.append(")");
        out.append(Hook.toSpec(this.returnType));
        return out.toString();
    }

    public static String toSpec(String type) {
        StringBuilder out = new StringBuilder();
        while (type.endsWith("[]")) {
            type = type.substring(0, type.length() - 2);
            out.append("[");
        }
        String p = PRIMITIVES.get(type);
        if (p != null) {
            out.append(p);
            return out.toString();
        }
        out.append("L");
        out.append(Hook.convertType(type));
        out.append(';');
        return out.toString();
    }

    public static String convertType(String type) {
        StringBuilder out = new StringBuilder();
        for (String part : type.split("\\.")) {
            if (out.length() > 0) {
                out.append('/');
            }
            out.append(part);
        }
        return out.toString();
    }

    public String toString() {
        return "Hook(className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ", returnType=" + this.getReturnType() + ", parameterTypes=" + this.getParameterTypes() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Hook)) {
            return false;
        }
        Hook other = (Hook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
            return false;
        }
        String this$returnType = this.getReturnType();
        String other$returnType = other.getReturnType();
        if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
            return false;
        }
        List<String> this$parameterTypes = this.getParameterTypes();
        List<String> other$parameterTypes = other.getParameterTypes();
        return !(this$parameterTypes == null ? other$parameterTypes != null : !((Object)this$parameterTypes).equals(other$parameterTypes));
    }

    public boolean canEqual(Object other) {
        return other instanceof Hook;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 0 : $className.hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 0 : $methodName.hashCode());
        String $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 0 : $returnType.hashCode());
        List<String> $parameterTypes = this.getParameterTypes();
        result = result * 59 + ($parameterTypes == null ? 0 : ((Object)$parameterTypes).hashCode());
        return result;
    }

    @NonNull
    public String getClassName() {
        return this.className;
    }

    @NonNull
    public String getMethodName() {
        return this.methodName;
    }

    @NonNull
    public String getReturnType() {
        return this.returnType;
    }

    @NonNull
    public List<String> getParameterTypes() {
        return this.parameterTypes;
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("int", "I");
        m.put("long", "J");
        m.put("short", "S");
        m.put("byte", "B");
        m.put("char", "C");
        m.put("double", "D");
        m.put("float", "F");
        m.put("void", "V");
        m.put("boolean", "Z");
        PRIMITIVES = Collections.unmodifiableMap(m);
    }
}

