/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

public class StringUtils {
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    public static String convertBytesToHex(byte[] value) {
        int len = value.length;
        char[] buff = new char[len + len];
        char[] hex = HEX;
        for (int i = 0; i < len; ++i) {
            int c = value[i] & 0xFF;
            buff[i + i] = hex[c >> 4];
            buff[i + i + 1] = hex[c & 0xF];
        }
        return new String(buff);
    }

    public static byte[] convertHexToBytes(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException(s);
        }
        byte[] buff = new byte[len /= 2];
        for (int i = 0; i < len; ++i) {
            buff[i] = (byte)(StringUtils.getHexDigit(s, i + i) << 4 | StringUtils.getHexDigit(s, i + i + 1));
        }
        return buff;
    }

    private static int getHexDigit(String s, int i) {
        char c = s.charAt(i);
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException(s);
    }
}

