/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.api.JackrabbitNode;
import org.apache.jackrabbit.commons.ItemNameMatcher;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.PropertyIteratorAdapter;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.PropertyDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.VersionManagerDelegate;
import org.apache.jackrabbit.oak.jcr.session.ItemImpl;
import org.apache.jackrabbit.oak.jcr.session.PropertyImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.SessionImpl;
import org.apache.jackrabbit.oak.jcr.session.operation.ItemOperation;
import org.apache.jackrabbit.oak.jcr.session.operation.NodeOperation;
import org.apache.jackrabbit.oak.jcr.version.VersionHistoryImpl;
import org.apache.jackrabbit.oak.jcr.version.VersionImpl;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.oak.plugins.nodetype.write.ReadWriteNodeTypeManager;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeImpl<T extends NodeDelegate>
extends ItemImpl<T>
implements Node,
JackrabbitNode {
    private static final long NODE_ITERATOR_MAX_SIZE = Long.MAX_VALUE;
    private static final Logger LOG = LoggerFactory.getLogger(NodeImpl.class);

    public static NodeImpl<? extends NodeDelegate> createNodeOrNull(NodeDelegate delegate, SessionContext context) throws RepositoryException {
        if (delegate != null) {
            return NodeImpl.createNode(delegate, context);
        }
        return null;
    }

    public static NodeImpl<? extends NodeDelegate> createNode(NodeDelegate delegate, SessionContext context) throws RepositoryException {
        String type;
        PropertyDelegate pd = delegate.getPropertyOrNull("jcr:primaryType");
        String string = type = pd != null ? pd.getString() : null;
        if ("nt:version".equals(type)) {
            VersionManagerDelegate vmd = VersionManagerDelegate.create(context.getSessionDelegate());
            return new VersionImpl(vmd.createVersion(delegate), context);
        }
        if ("nt:versionHistory".equals(type)) {
            VersionManagerDelegate vmd = VersionManagerDelegate.create(context.getSessionDelegate());
            return new VersionHistoryImpl(vmd.createVersionHistory(delegate), context);
        }
        return new NodeImpl<NodeDelegate>(delegate, context);
    }

    public NodeImpl(T dlg, SessionContext sessionContext) {
        super(dlg, sessionContext);
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    @Nonnull
    public Node getParent() throws RepositoryException {
        return this.perform(new NodeOperation<Node>((NodeDelegate)this.dlg, "getParent"){

            @Override
            public Node perform() throws RepositoryException {
                if (this.node.isRoot()) {
                    throw new ItemNotFoundException("Root has no parent");
                }
                NodeDelegate parent = this.node.getParent();
                if (parent == null) {
                    throw new AccessDeniedException();
                }
                return NodeImpl.createNode(parent, NodeImpl.this.sessionContext);
            }
        });
    }

    @Override
    public boolean isNew() {
        return this.safePerform(new NodeOperation<Boolean>((NodeDelegate)this.dlg, "isNew"){

            @Override
            public Boolean perform() {
                return this.node.exists() && this.node.getStatus() == Tree.Status.NEW;
            }
        });
    }

    @Override
    public boolean isModified() {
        return this.safePerform(new NodeOperation<Boolean>((NodeDelegate)this.dlg, "isModified"){

            @Override
            public Boolean perform() {
                return this.node.exists() && this.node.getStatus() == Tree.Status.MODIFIED;
            }
        });
    }

    @Override
    public void remove() throws RepositoryException {
        this.perform(new ItemImpl.ItemWriteOperation<Void>("remove"){

            @Override
            public Void perform() throws RepositoryException {
                if (((NodeDelegate)NodeImpl.this.dlg).isRoot()) {
                    throw new RepositoryException("Cannot remove the root node");
                }
                ((NodeDelegate)NodeImpl.this.dlg).remove();
                return null;
            }

            @Override
            public String toString() {
                return String.format("Removing node [%s]", ((NodeDelegate)NodeImpl.this.dlg).getPath());
            }
        });
    }

    @Override
    public void accept(ItemVisitor visitor) throws RepositoryException {
        visitor.visit(this);
    }

    @Override
    @Nonnull
    public Node addNode(String relPath) throws RepositoryException {
        return this.addNode(relPath, null);
    }

    @Override
    @Nonnull
    public Node addNode(final String relPath, String primaryNodeTypeName) throws RepositoryException {
        final String oakPath = this.getOakPathOrThrowNotFound(relPath);
        final String oakTypeName = primaryNodeTypeName != null ? this.getOakName(primaryNodeTypeName) : null;
        SessionImpl.checkIndexOnName(this.sessionContext, relPath);
        return this.perform(new ItemImpl.ItemWriteOperation<Node>("addNode"){

            @Override
            public Node perform() throws RepositoryException {
                NodeDelegate added;
                String oakName = PathUtils.getName(oakPath);
                String parentPath = PathUtils.getParentPath(oakPath);
                NodeDelegate parent = ((NodeDelegate)NodeImpl.this.dlg).getChild(parentPath);
                if (parent == null) {
                    String propName;
                    String grandParentPath = PathUtils.getParentPath(parentPath);
                    NodeDelegate grandParent = ((NodeDelegate)NodeImpl.this.dlg).getChild(grandParentPath);
                    if (grandParent != null && grandParent.getPropertyOrNull(propName = PathUtils.getName(parentPath)) != null) {
                        throw new ConstraintViolationException("Can't add new node to property.");
                    }
                    throw new PathNotFoundException(relPath);
                }
                if (parent.getChild(oakName) != null) {
                    throw new ItemExistsException(relPath);
                }
                if (oakTypeName != null) {
                    PropertyState prop = PropertyStates.createProperty("jcr:primaryType", (Object)oakTypeName, Type.NAME);
                    NodeImpl.this.sessionContext.getAccessManager().checkPermissions(((NodeDelegate)NodeImpl.this.dlg).getTree(), prop, 512L);
                }
                if ((added = parent.addChild(oakName, oakTypeName)) == null) {
                    throw new ItemExistsException();
                }
                return NodeImpl.createNode(added, NodeImpl.this.sessionContext);
            }

            @Override
            public String toString() {
                return String.format("Adding node [%s/%s]", ((NodeDelegate)NodeImpl.this.dlg).getPath(), relPath);
            }
        });
    }

    @Override
    public void orderBefore(final String srcChildRelPath, final String destChildRelPath) throws RepositoryException {
        this.perform(new ItemImpl.ItemWriteOperation<Void>("orderBefore"){

            @Override
            public Void perform() throws RepositoryException {
                NodeImpl.this.getEffectiveNodeType().checkOrderableChildNodes();
                String oakSrcChildRelPath = NodeImpl.this.getOakPathOrThrowNotFound(srcChildRelPath);
                String oakDestChildRelPath = null;
                if (destChildRelPath != null) {
                    oakDestChildRelPath = NodeImpl.this.getOakPathOrThrowNotFound(destChildRelPath);
                }
                ((NodeDelegate)NodeImpl.this.dlg).orderBefore(oakSrcChildRelPath, oakDestChildRelPath);
                return null;
            }
        });
    }

    @Override
    @Nonnull
    public Property setProperty(String name, Value value) throws RepositoryException {
        if (value != null) {
            return this.internalSetProperty(name, value, false);
        }
        return this.internalRemoveProperty(name);
    }

    @Override
    @Nonnull
    public Property setProperty(String name, Value value, int type) throws RepositoryException {
        if (value != null) {
            boolean exactTypeMatch = true;
            if (type == 0) {
                exactTypeMatch = false;
            } else {
                value = ValueHelper.convert(value, type, this.getValueFactory());
            }
            return this.internalSetProperty(name, value, exactTypeMatch);
        }
        return this.internalRemoveProperty(name);
    }

    @Override
    @Nonnull
    public Property setProperty(String name, Value[] values) throws RepositoryException {
        if (values != null) {
            return this.internalSetProperty(name, values, ValueHelper.getType(values), false);
        }
        return this.internalRemoveProperty(name);
    }

    @Override
    @Nonnull
    public Property setProperty(String jcrName, Value[] values, int type) throws RepositoryException {
        if (values != null) {
            boolean exactTypeMatch = true;
            if (type == 0) {
                type = 1;
                exactTypeMatch = false;
            }
            values = ValueHelper.convert(values, type, this.getValueFactory());
            return this.internalSetProperty(jcrName, values, type, exactTypeMatch);
        }
        return this.internalRemoveProperty(jcrName);
    }

    @Override
    @Nonnull
    public Property setProperty(String name, String[] values) throws RepositoryException {
        if (values != null) {
            int type = 1;
            Value[] vs = ValueHelper.convert(values, type, this.getValueFactory());
            return this.internalSetProperty(name, vs, type, false);
        }
        return this.internalRemoveProperty(name);
    }

    @Override
    @Nonnull
    public Property setProperty(String name, String[] values, int type) throws RepositoryException {
        if (values != null) {
            boolean exactTypeMatch = true;
            if (type == 0) {
                type = 1;
                exactTypeMatch = false;
            }
            Value[] vs = ValueHelper.convert(values, type, this.getValueFactory());
            return this.internalSetProperty(name, vs, type, exactTypeMatch);
        }
        return this.internalRemoveProperty(name);
    }

    @Override
    @Nonnull
    public Property setProperty(String name, String value) throws RepositoryException {
        if (value != null) {
            Value v = this.getValueFactory().createValue(value);
            return this.internalSetProperty(name, v, false);
        }
        return this.internalRemoveProperty(name);
    }

    @Override
    @Nonnull
    public Property setProperty(String name, String value, int type) throws RepositoryException {
        if (value != null) {
            boolean exactTypeMatch = true;
            if (type == 0) {
                type = 1;
                exactTypeMatch = false;
            }
            Value v = this.getValueFactory().createValue(value, type);
            return this.internalSetProperty(name, v, exactTypeMatch);
        }
        return this.internalRemoveProperty(name);
    }

    @Override
    @Nonnull
    public Property setProperty(String name, InputStream value) throws RepositoryException {
        if (value != null) {
            Value v = this.getValueFactory().createValue(value);
            return this.internalSetProperty(name, v, false);
        }
        return this.internalRemoveProperty(name);
    }

    @Override
    @Nonnull
    public Property setProperty(String name, Binary value) throws RepositoryException {
        if (value != null) {
            Value v = this.getValueFactory().createValue(value);
            return this.internalSetProperty(name, v, false);
        }
        return this.internalRemoveProperty(name);
    }

    @Override
    @Nonnull
    public Property setProperty(String name, boolean value) throws RepositoryException {
        Value v = this.getValueFactory().createValue(value);
        return this.internalSetProperty(name, v, false);
    }

    @Override
    @Nonnull
    public Property setProperty(String name, double value) throws RepositoryException {
        Value v = this.getValueFactory().createValue(value);
        return this.internalSetProperty(name, v, false);
    }

    @Override
    @Nonnull
    public Property setProperty(String name, BigDecimal value) throws RepositoryException {
        if (value != null) {
            Value v = this.getValueFactory().createValue(value);
            return this.internalSetProperty(name, v, false);
        }
        return this.internalRemoveProperty(name);
    }

    @Override
    @Nonnull
    public Property setProperty(String name, long value) throws RepositoryException {
        Value v = this.getValueFactory().createValue(value);
        return this.internalSetProperty(name, v, false);
    }

    @Override
    @Nonnull
    public Property setProperty(String name, Calendar value) throws RepositoryException {
        if (value != null) {
            Value v = this.getValueFactory().createValue(value);
            return this.internalSetProperty(name, v, false);
        }
        return this.internalRemoveProperty(name);
    }

    @Override
    @Nonnull
    public Property setProperty(String name, Node value) throws RepositoryException {
        if (value != null) {
            Value v = this.getValueFactory().createValue(value);
            return this.internalSetProperty(name, v, false);
        }
        return this.internalRemoveProperty(name);
    }

    @Override
    @Nonnull
    public Node getNode(String relPath) throws RepositoryException {
        final String oakPath = this.getOakPathOrThrowNotFound(relPath);
        return this.perform(new NodeOperation<Node>((NodeDelegate)this.dlg, "getNode"){

            @Override
            public Node perform() throws RepositoryException {
                NodeDelegate nd = this.node.getChild(oakPath);
                if (nd == null) {
                    throw new PathNotFoundException(oakPath);
                }
                return NodeImpl.createNode(nd, NodeImpl.this.sessionContext);
            }
        });
    }

    @Override
    @Nonnull
    public NodeIterator getNodes() throws RepositoryException {
        return this.perform(new NodeOperation<NodeIterator>((NodeDelegate)this.dlg, "getNodes"){

            @Override
            public NodeIterator perform() throws RepositoryException {
                Iterator<NodeDelegate> children = this.node.getChildren();
                return new NodeIteratorAdapter(NodeImpl.this.nodeIterator(children)){
                    private long size;
                    {
                        this.size = -2L;
                    }

                    @Override
                    public long getSize() {
                        if (this.size == -2L) {
                            try {
                                this.size = node.getChildCount(Long.MAX_VALUE);
                                if (this.size == Long.MAX_VALUE) {
                                    this.size = -1L;
                                }
                            }
                            catch (InvalidItemStateException e) {
                                throw new IllegalStateException("This iterator is no longer valid", e);
                            }
                        }
                        return this.size;
                    }
                };
            }
        });
    }

    @Override
    @Nonnull
    public NodeIterator getNodes(final String namePattern) throws RepositoryException {
        return this.perform(new NodeOperation<NodeIterator>((NodeDelegate)this.dlg, "getNodes"){

            @Override
            public NodeIterator perform() throws RepositoryException {
                UnmodifiableIterator<NodeDelegate> children = Iterators.filter(this.node.getChildren(), new Predicate<NodeDelegate>(){

                    @Override
                    public boolean apply(NodeDelegate state) {
                        return ItemNameMatcher.matches(NodeImpl.this.toJcrPath(state.getName()), namePattern);
                    }
                });
                return new NodeIteratorAdapter(NodeImpl.this.nodeIterator(children));
            }
        });
    }

    @Override
    @Nonnull
    public NodeIterator getNodes(final String[] nameGlobs) throws RepositoryException {
        return this.perform(new NodeOperation<NodeIterator>((NodeDelegate)this.dlg, "getNodes"){

            @Override
            public NodeIterator perform() throws RepositoryException {
                UnmodifiableIterator<NodeDelegate> children = Iterators.filter(this.node.getChildren(), new Predicate<NodeDelegate>(){

                    @Override
                    public boolean apply(NodeDelegate state) {
                        return ItemNameMatcher.matches(NodeImpl.this.toJcrPath(state.getName()), nameGlobs);
                    }
                });
                return new NodeIteratorAdapter(NodeImpl.this.nodeIterator(children));
            }
        });
    }

    @Override
    @Nonnull
    public Property getProperty(String relPath) throws RepositoryException {
        final String oakPath = this.getOakPathOrThrowNotFound(relPath);
        return this.perform(new NodeOperation<PropertyImpl>((NodeDelegate)this.dlg, "getProperty"){

            @Override
            public PropertyImpl perform() throws RepositoryException {
                PropertyDelegate pd = this.node.getPropertyOrNull(oakPath);
                if (pd == null) {
                    throw new PathNotFoundException(oakPath + " not found on " + this.node.getPath());
                }
                return new PropertyImpl(pd, NodeImpl.this.sessionContext);
            }
        });
    }

    @Override
    @Nonnull
    public PropertyIterator getProperties() throws RepositoryException {
        return this.perform(new NodeOperation<PropertyIterator>((NodeDelegate)this.dlg, "getProperties"){

            @Override
            public PropertyIterator perform() throws RepositoryException {
                Iterator<PropertyDelegate> properties = this.node.getProperties();
                long size = this.node.getPropertyCount();
                return new PropertyIteratorAdapter(NodeImpl.this.propertyIterator(properties), size);
            }
        });
    }

    @Override
    @Nonnull
    public PropertyIterator getProperties(final String namePattern) throws RepositoryException {
        return this.perform(new NodeOperation<PropertyIterator>((NodeDelegate)this.dlg, "getProperties"){

            @Override
            public PropertyIterator perform() throws RepositoryException {
                UnmodifiableIterator<PropertyDelegate> properties = Iterators.filter(this.node.getProperties(), new Predicate<PropertyDelegate>(){

                    @Override
                    public boolean apply(PropertyDelegate entry) {
                        return ItemNameMatcher.matches(NodeImpl.this.toJcrPath(entry.getName()), namePattern);
                    }
                });
                return new PropertyIteratorAdapter(NodeImpl.this.propertyIterator(properties));
            }
        });
    }

    @Override
    @Nonnull
    public PropertyIterator getProperties(final String[] nameGlobs) throws RepositoryException {
        return this.perform(new NodeOperation<PropertyIterator>((NodeDelegate)this.dlg, "getProperties"){

            @Override
            public PropertyIterator perform() throws RepositoryException {
                UnmodifiableIterator<PropertyDelegate> propertyNames = Iterators.filter(this.node.getProperties(), new Predicate<PropertyDelegate>(){

                    @Override
                    public boolean apply(PropertyDelegate entry) {
                        return ItemNameMatcher.matches(NodeImpl.this.toJcrPath(entry.getName()), nameGlobs);
                    }
                });
                return new PropertyIteratorAdapter(NodeImpl.this.propertyIterator(propertyNames));
            }
        });
    }

    @Override
    @Nonnull
    public Item getPrimaryItem() throws RepositoryException {
        return this.perform(new NodeOperation<Item>((NodeDelegate)this.dlg, "getPrimaryItem"){

            @Override
            public Item perform() throws RepositoryException {
                String name = NodeImpl.this.getPrimaryNodeType().getPrimaryItemName();
                if (name == null) {
                    throw new ItemNotFoundException("No primary item present on node " + this);
                }
                if (NodeImpl.this.hasProperty(name)) {
                    return NodeImpl.this.getProperty(name);
                }
                if (NodeImpl.this.hasNode(name)) {
                    return NodeImpl.this.getNode(name);
                }
                throw new ItemNotFoundException("Primary item " + name + " does not exist on node " + this);
            }
        });
    }

    @Override
    @Nonnull
    public String getUUID() throws RepositoryException {
        return this.perform(new NodeOperation<String>((NodeDelegate)this.dlg, "getUUID"){

            @Override
            public String perform() throws RepositoryException {
                if (NodeImpl.this.isNodeType("{http://www.jcp.org/jcr/mix/1.0}referenceable")) {
                    return NodeImpl.this.getIdentifier();
                }
                throw new UnsupportedRepositoryOperationException("Node is not referenceable.");
            }
        });
    }

    @Override
    @Nonnull
    public String getIdentifier() throws RepositoryException {
        return this.perform(new NodeOperation<String>((NodeDelegate)this.dlg, "getIdentifier"){

            @Override
            public String perform() throws RepositoryException {
                return this.node.getIdentifier();
            }
        });
    }

    @Override
    public int getIndex() throws RepositoryException {
        return 1;
    }

    private PropertyIterator internalGetReferences(final String name, final boolean weak) throws RepositoryException {
        return this.perform(new NodeOperation<PropertyIterator>((NodeDelegate)this.dlg, "internalGetReferences"){

            @Override
            public PropertyIterator perform() throws InvalidItemStateException {
                IdentifierManager idManager = NodeImpl.this.sessionDelegate.getIdManager();
                Iterable<String> propertyOakPaths = idManager.getReferences(weak, this.node.getTree(), name, new String[0]);
                Iterable<Property> properties = Iterables.transform(propertyOakPaths, new Function<String, Property>(){

                    @Override
                    public Property apply(String oakPath) {
                        PropertyDelegate pd = NodeImpl.this.sessionDelegate.getProperty(oakPath);
                        return pd == null ? null : new PropertyImpl(pd, NodeImpl.this.sessionContext);
                    }
                });
                return new PropertyIteratorAdapter(NodeImpl.this.sessionDelegate.sync(properties.iterator()));
            }
        });
    }

    @Override
    @Nonnull
    public PropertyIterator getReferences() throws RepositoryException {
        return this.internalGetReferences(null, false);
    }

    @Override
    @Nonnull
    public PropertyIterator getReferences(String name) throws RepositoryException {
        return this.internalGetReferences(name, false);
    }

    @Override
    @Nonnull
    public PropertyIterator getWeakReferences() throws RepositoryException {
        return this.internalGetReferences(null, true);
    }

    @Override
    @Nonnull
    public PropertyIterator getWeakReferences(String name) throws RepositoryException {
        return this.internalGetReferences(name, true);
    }

    @Override
    public boolean hasNode(String relPath) throws RepositoryException {
        try {
            final String oakPath = this.getOakPathOrThrow(relPath);
            return this.perform(new NodeOperation<Boolean>((NodeDelegate)this.dlg, "hasNode"){

                @Override
                public Boolean perform() throws RepositoryException {
                    return this.node.getChild(oakPath) != null;
                }
            });
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean hasProperty(String relPath) throws RepositoryException {
        try {
            final String oakPath = this.getOakPathOrThrow(relPath);
            return this.perform(new NodeOperation<Boolean>((NodeDelegate)this.dlg, "hasProperty"){

                @Override
                public Boolean perform() throws RepositoryException {
                    return this.node.getPropertyOrNull(oakPath) != null;
                }
            });
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean hasNodes() throws RepositoryException {
        return this.getNodes().hasNext();
    }

    @Override
    public boolean hasProperties() throws RepositoryException {
        return this.perform(new NodeOperation<Boolean>((NodeDelegate)this.dlg, "hasProperties"){

            @Override
            public Boolean perform() throws RepositoryException {
                return this.node.getPropertyCount() != 0L;
            }
        });
    }

    @Override
    @Nonnull
    public NodeType getPrimaryNodeType() throws RepositoryException {
        return this.perform(new NodeOperation<NodeType>((NodeDelegate)this.dlg, "getPrimaryNodeType"){

            @Override
            public NodeType perform() throws RepositoryException {
                if (!NodeImpl.this.hasProperty("{http://www.jcp.org/jcr/1.0}primaryType")) {
                    throw new RepositoryException("Node " + NodeImpl.this.getPath() + " doesn't have primary type set.");
                }
                String primaryNtName = NodeImpl.this.getProperty("{http://www.jcp.org/jcr/1.0}primaryType").getString();
                return NodeImpl.this.getNodeTypeManager().getNodeType(primaryNtName);
            }
        });
    }

    @Override
    @Nonnull
    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        return this.perform(new NodeOperation<NodeType[]>((NodeDelegate)this.dlg, "getMixinNodeTypes"){

            @Override
            public NodeType[] perform() throws RepositoryException {
                if (NodeImpl.this.hasProperty("{http://www.jcp.org/jcr/1.0}mixinTypes")) {
                    ReadWriteNodeTypeManager ntMgr = NodeImpl.this.getNodeTypeManager();
                    Value[] mixinNames = NodeImpl.this.getProperty("{http://www.jcp.org/jcr/1.0}mixinTypes").getValues();
                    NodeType[] mixinTypes = new NodeType[mixinNames.length];
                    for (int i = 0; i < mixinNames.length; ++i) {
                        mixinTypes[i] = ntMgr.getNodeType(mixinNames[i].getString());
                    }
                    return mixinTypes;
                }
                return new NodeType[0];
            }
        });
    }

    @Override
    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        final String oakName = this.getOakName(nodeTypeName);
        return this.perform(new NodeOperation<Boolean>((NodeDelegate)this.dlg, "isNodeType"){

            @Override
            public Boolean perform() throws RepositoryException {
                return NodeImpl.this.getNodeTypeManager().isNodeType(this.node.getTree(), oakName);
            }
        });
    }

    @Override
    public void setPrimaryType(final String nodeTypeName) throws RepositoryException {
        this.perform(new ItemImpl.ItemWriteOperation<Void>("setPrimaryType"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                if (!NodeImpl.this.isCheckedOut()) {
                    throw new VersionException("Cannot set primary type. Node is checked in.");
                }
            }

            @Override
            public Void perform() throws RepositoryException {
                NodeImpl.this.internalSetPrimaryType(nodeTypeName);
                return null;
            }
        });
    }

    @Override
    public void addMixin(String mixinName) throws RepositoryException {
        final String oakTypeName = this.getOakName(Preconditions.checkNotNull(mixinName));
        this.perform(new ItemImpl.ItemWriteOperation<Void>("addMixin"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                if (!NodeImpl.this.isCheckedOut()) {
                    throw new VersionException("Cannot add mixin type. Node is checked in.");
                }
            }

            @Override
            public Void perform() throws RepositoryException {
                ((NodeDelegate)NodeImpl.this.dlg).addMixin(oakTypeName);
                return null;
            }
        });
    }

    @Override
    public void removeMixin(final String mixinName) throws RepositoryException {
        final String oakTypeName = this.getOakName(Preconditions.checkNotNull(mixinName));
        this.perform(new ItemImpl.ItemWriteOperation<Void>("removeMixin"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                if (!NodeImpl.this.isCheckedOut()) {
                    throw new VersionException("Cannot remove mixin type. Node is checked in.");
                }
                LinkedHashSet<String> mixins = Sets.newLinkedHashSet(TreeUtil.getNames(((NodeDelegate)NodeImpl.this.dlg).getTree(), "jcr:mixinTypes"));
                if (!mixins.isEmpty() && mixins.remove(NodeImpl.this.getOakName(mixinName))) {
                    PropertyState prop = PropertyStates.createProperty("jcr:mixinTypes", mixins, Type.NAMES);
                    NodeImpl.this.sessionContext.getAccessManager().checkPermissions(((NodeDelegate)NodeImpl.this.dlg).getTree(), prop, 512L);
                }
            }

            @Override
            public Void perform() throws RepositoryException {
                ((NodeDelegate)NodeImpl.this.dlg).removeMixin(oakTypeName);
                return null;
            }
        });
    }

    @Override
    public boolean canAddMixin(String mixinName) throws RepositoryException {
        final String oakTypeName = this.getOakName(mixinName);
        return this.perform(new NodeOperation<Boolean>((NodeDelegate)this.dlg, "canAddMixin"){

            @Override
            public Boolean perform() throws RepositoryException {
                PropertyState prop = PropertyStates.createProperty("jcr:mixinTypes", Collections.singleton(oakTypeName), Type.NAMES);
                return NodeImpl.this.sessionContext.getAccessManager().hasPermissions(this.node.getTree(), prop, 512L) && !this.node.isProtected() && NodeImpl.this.getVersionManager().isCheckedOut(NodeImpl.this.toJcrPath(((NodeDelegate)NodeImpl.this.dlg).getPath())) && this.node.canAddMixin(oakTypeName);
            }
        });
    }

    @Override
    @Nonnull
    public NodeDefinition getDefinition() throws RepositoryException {
        return this.perform(new NodeOperation<NodeDefinition>((NodeDelegate)this.dlg, "getDefinition"){

            @Override
            public NodeDefinition perform() throws RepositoryException {
                NodeDelegate parent = this.node.getParent();
                if (parent == null) {
                    return NodeImpl.this.getNodeTypeManager().getRootDefinition();
                }
                return NodeImpl.this.getNodeTypeManager().getDefinition(parent.getTree(), this.node.getTree());
            }
        });
    }

    @Override
    @Nonnull
    public String getCorrespondingNodePath(final String workspaceName) throws RepositoryException {
        return this.toJcrPath(this.perform(new ItemOperation<String>(this.dlg, "getCorrespondingNodePath"){

            @Override
            public String perform() throws RepositoryException {
                NodeImpl.this.checkValidWorkspace(workspaceName);
                if (workspaceName.equals(NodeImpl.this.sessionDelegate.getWorkspaceName())) {
                    return this.item.getPath();
                }
                throw new UnsupportedRepositoryOperationException("OAK-118: Node.getCorrespondingNodePath");
            }
        }));
    }

    @Override
    public void update(final String srcWorkspace) throws RepositoryException {
        this.perform(new ItemImpl.ItemWriteOperation<Void>("update"){

            @Override
            public Void perform() throws RepositoryException {
                NodeImpl.this.checkValidWorkspace(srcWorkspace);
                if (NodeImpl.this.sessionDelegate.hasPendingChanges()) {
                    String msg = "Unable to perform operation. Session has pending changes.";
                    LOG.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
                if (!srcWorkspace.equals(NodeImpl.this.sessionDelegate.getWorkspaceName())) {
                    throw new UnsupportedRepositoryOperationException("OAK-118: Node.update");
                }
                return null;
            }
        });
    }

    @Override
    @Nonnull
    public Version checkin() throws RepositoryException {
        return this.getVersionManager().checkin(this.getPath());
    }

    @Override
    public void checkout() throws RepositoryException {
        this.getVersionManager().checkout(this.getPath());
    }

    @Override
    public void doneMerge(Version version) throws RepositoryException {
        this.getVersionManager().doneMerge(this.getPath(), version);
    }

    @Override
    public void cancelMerge(Version version) throws RepositoryException {
        this.getVersionManager().cancelMerge(this.getPath(), version);
    }

    @Override
    @Nonnull
    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws RepositoryException {
        return this.getVersionManager().merge(this.getPath(), srcWorkspace, bestEffort);
    }

    @Override
    public boolean isCheckedOut() throws RepositoryException {
        try {
            return this.getVersionManager().isCheckedOut(this.getPath());
        }
        catch (UnsupportedRepositoryOperationException ex) {
            return true;
        }
    }

    @Override
    public void restore(String versionName, boolean removeExisting) throws RepositoryException {
        if (!this.isNodeType("{http://www.jcp.org/jcr/mix/1.0}versionable")) {
            throw new UnsupportedRepositoryOperationException("Node is not mix:versionable");
        }
        this.getVersionManager().restore(this.getPath(), versionName, removeExisting);
    }

    @Override
    public void restore(Version version, boolean removeExisting) throws RepositoryException {
        if (!this.isNodeType("{http://www.jcp.org/jcr/mix/1.0}versionable")) {
            throw new UnsupportedRepositoryOperationException("Node is not mix:versionable");
        }
        String id = version.getContainingHistory().getVersionableIdentifier();
        if (!this.getIdentifier().equals(id)) {
            throw new VersionException("Version does not belong to the VersionHistory of this node.");
        }
        this.getVersionManager().restore(version, removeExisting);
    }

    @Override
    public void restore(Version version, String relPath, boolean removeExisting) throws RepositoryException {
        if (this.hasNode(relPath)) {
            this.getNode(relPath).restore(version, removeExisting);
        } else {
            String absPath = PathUtils.concat(this.getPath(), relPath);
            this.getVersionManager().restore(absPath, version, removeExisting);
        }
    }

    @Override
    public void restoreByLabel(String versionLabel, boolean removeExisting) throws RepositoryException {
        this.getVersionManager().restoreByLabel(this.getPath(), versionLabel, removeExisting);
    }

    @Override
    @Nonnull
    public VersionHistory getVersionHistory() throws RepositoryException {
        return this.getVersionManager().getVersionHistory(this.getPath());
    }

    @Override
    @Nonnull
    public Version getBaseVersion() throws RepositoryException {
        return this.getVersionManager().getBaseVersion(this.getPath());
    }

    private LockManager getLockManager() throws RepositoryException {
        return this.getSession().getWorkspace().getLockManager();
    }

    @Override
    public boolean isLocked() throws RepositoryException {
        return this.getLockManager().isLocked(this.getPath());
    }

    @Override
    public boolean holdsLock() throws RepositoryException {
        return this.getLockManager().holdsLock(this.getPath());
    }

    @Override
    @Nonnull
    public Lock getLock() throws RepositoryException {
        return this.getLockManager().getLock(this.getPath());
    }

    @Override
    @Nonnull
    public Lock lock(boolean isDeep, boolean isSessionScoped) throws RepositoryException {
        return this.getLockManager().lock(this.getPath(), isDeep, isSessionScoped, Long.MAX_VALUE, null);
    }

    @Override
    public void unlock() throws RepositoryException {
        this.getLockManager().unlock(this.getPath());
    }

    @Override
    @Nonnull
    public NodeIterator getSharedSet() {
        return new NodeIteratorAdapter(Collections.singleton(this));
    }

    @Override
    public void removeSharedSet() throws RepositoryException {
        this.perform(new ItemImpl.ItemWriteOperation<Void>("removeSharedSet"){

            @Override
            public Void perform() throws RepositoryException {
                NodeIterator sharedSet = NodeImpl.this.getSharedSet();
                while (sharedSet.hasNext()) {
                    sharedSet.nextNode().removeShare();
                }
                return null;
            }
        });
    }

    @Override
    public void removeShare() throws RepositoryException {
        this.remove();
    }

    @Override
    public void followLifecycleTransition(String transition) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("Lifecycle Management is not supported");
    }

    @Override
    @Nonnull
    public String[] getAllowedLifecycleTransistions() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("Lifecycle Management is not supported");
    }

    private EffectiveNodeType getEffectiveNodeType() throws RepositoryException {
        return this.getNodeTypeManager().getEffectiveNodeType(((NodeDelegate)this.dlg).getTree());
    }

    private Iterator<Node> nodeIterator(Iterator<NodeDelegate> childNodes) {
        return this.sessionDelegate.sync(Iterators.transform(childNodes, new Function<NodeDelegate, Node>(){

            @Override
            public Node apply(NodeDelegate nodeDelegate) {
                return new NodeImpl<NodeDelegate>(nodeDelegate, NodeImpl.this.sessionContext);
            }
        }));
    }

    private Iterator<Property> propertyIterator(Iterator<PropertyDelegate> properties) {
        return this.sessionDelegate.sync(Iterators.transform(properties, new Function<PropertyDelegate, Property>(){

            @Override
            public Property apply(PropertyDelegate propertyDelegate) {
                return new PropertyImpl(propertyDelegate, NodeImpl.this.sessionContext);
            }
        }));
    }

    private void checkValidWorkspace(String workspaceName) throws RepositoryException {
        String[] workspaceNames = this.getSession().getWorkspace().getAccessibleWorkspaceNames();
        if (!Arrays.asList(workspaceNames).contains(workspaceName)) {
            throw new NoSuchWorkspaceException("Workspace " + workspaceName + " does not exist");
        }
    }

    private void internalSetPrimaryType(String nodeTypeName) throws RepositoryException {
        NodeType nt = this.getNodeTypeManager().getNodeType(nodeTypeName);
        if (nt.isAbstract() || nt.isMixin()) {
            throw new ConstraintViolationException();
        }
        PropertyState state = PropertyStates.createProperty("jcr:primaryType", (Object)this.getOakName(nodeTypeName), Type.NAME);
        ((NodeDelegate)this.dlg).setProperty(state, true, true);
        ((NodeDelegate)this.dlg).setOrderableChildren(nt.hasOrderableChildNodes());
    }

    private Property internalSetProperty(final String jcrName, Value value, final boolean exactTypeMatch) throws RepositoryException {
        String oakName = this.getOakPathOrThrow(Preconditions.checkNotNull(jcrName));
        final PropertyState state = this.createSingleState(oakName, value, Type.fromTag(value.getType(), false));
        return this.perform(new ItemImpl.ItemWriteOperation<Property>("internalSetProperty"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                if (!NodeImpl.this.isCheckedOut()) {
                    throw new VersionException("Cannot set property. Node is checked in.");
                }
            }

            @Override
            public Property perform() throws RepositoryException {
                return new PropertyImpl(((NodeDelegate)NodeImpl.this.dlg).setProperty(state, exactTypeMatch, false), NodeImpl.this.sessionContext);
            }

            @Override
            public String toString() {
                return String.format("Setting property [%s/%s]", ((NodeDelegate)NodeImpl.this.dlg).getPath(), jcrName);
            }
        });
    }

    private Property internalSetProperty(final String jcrName, Value[] values, int type, final boolean exactTypeMatch) throws RepositoryException {
        String oakName = this.getOakPathOrThrow(Preconditions.checkNotNull(jcrName));
        final PropertyState state = this.createMultiState(oakName, NodeImpl.compact(values), Type.fromTag(type, true));
        if (values.length > 1000) {
            LOG.warn("Large multi valued property detected ({} values).", (Object)values.length);
        }
        return this.perform(new ItemImpl.ItemWriteOperation<Property>("internalSetProperty"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                if (!NodeImpl.this.isCheckedOut()) {
                    throw new VersionException("Cannot set property. Node is checked in.");
                }
            }

            @Override
            public Property perform() throws RepositoryException {
                return new PropertyImpl(((NodeDelegate)NodeImpl.this.dlg).setProperty(state, exactTypeMatch, false), NodeImpl.this.sessionContext);
            }

            @Override
            public String toString() {
                return String.format("Setting property [%s/%s]", ((NodeDelegate)NodeImpl.this.dlg).getPath(), jcrName);
            }
        });
    }

    private static List<Value> compact(Value[] values) {
        ArrayList<Value> list = Lists.newArrayListWithCapacity(values.length);
        for (Value value : values) {
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    private Property internalRemoveProperty(final String jcrName) throws RepositoryException {
        final String oakName = this.getOakName(Preconditions.checkNotNull(jcrName));
        return this.perform(new ItemImpl.ItemWriteOperation<Property>("internalRemoveProperty"){

            @Override
            public Property perform() throws RepositoryException {
                PropertyDelegate property = ((NodeDelegate)NodeImpl.this.dlg).getPropertyOrNull(oakName);
                if (property != null) {
                    property.remove();
                } else {
                    property = ((NodeDelegate)NodeImpl.this.dlg).getProperty(oakName);
                }
                return new PropertyImpl(property, NodeImpl.this.sessionContext);
            }

            @Override
            public String toString() {
                return String.format("Removing property [%s]", jcrName);
            }
        });
    }

    @Override
    public void rename(final String newName) throws RepositoryException {
        if (((NodeDelegate)this.dlg).isRoot()) {
            throw new RepositoryException("Cannot rename the root node");
        }
        final String name = this.getName();
        if (newName.equals(name)) {
            return;
        }
        this.perform(new ItemImpl.ItemWriteOperation<Void>("rename"){

            @Override
            public Void perform() throws RepositoryException {
                Node parent = NodeImpl.this.getParent();
                String beforeName = null;
                if (NodeImpl.isOrderable(parent)) {
                    NodeIterator nit = parent.getNodes();
                    while (nit.hasNext()) {
                        Node child = nit.nextNode();
                        if (!name.equals(child.getName())) continue;
                        if (!nit.hasNext()) break;
                        beforeName = nit.nextNode().getName();
                        break;
                    }
                }
                String srcPath = NodeImpl.this.getPath();
                String destPath = '/' + newName;
                String parentPath = parent.getPath();
                if (!"/".equals(parentPath)) {
                    destPath = parentPath + destPath;
                }
                NodeImpl.this.sessionContext.getSession().move(srcPath, destPath);
                if (beforeName != null) {
                    parent.orderBefore(newName, beforeName);
                }
                return null;
            }
        });
    }

    private static boolean isOrderable(Node node) throws RepositoryException {
        NodeType[] types;
        if (node.getPrimaryNodeType().hasOrderableChildNodes()) {
            return true;
        }
        for (NodeType type : types = node.getMixinNodeTypes()) {
            if (!type.hasOrderableChildNodes()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setMixins(String[] mixinNames) throws RepositoryException {
        final LinkedHashSet<String> oakTypeNames = Sets.newLinkedHashSet();
        for (String mixinName : mixinNames) {
            oakTypeNames.add(this.getOakName(Preconditions.checkNotNull(mixinName)));
        }
        this.perform(new ItemImpl.ItemWriteOperation<Void>("setMixins"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                if (!NodeImpl.this.isCheckedOut()) {
                    throw new VersionException("Cannot set mixin types. Node is checked in.");
                }
                PropertyDelegate mixinProp = ((NodeDelegate)NodeImpl.this.dlg).getPropertyOrNull("jcr:mixinTypes");
                if (mixinProp != null) {
                    NodeImpl.this.sessionContext.getAccessManager().checkPermissions(((NodeDelegate)NodeImpl.this.dlg).getTree(), mixinProp.getPropertyState(), 512L);
                }
            }

            @Override
            public Void perform() throws RepositoryException {
                ((NodeDelegate)NodeImpl.this.dlg).setMixins(oakTypeNames);
                return null;
            }
        });
    }
}

