/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Checkpoints {
    private static final String ID = "checkpoint";
    private static final String PROP_CHECKPOINT = "data";
    static final int CLEANUP_INTERVAL = 100;
    private final DocumentNodeStore nodeStore;
    private final DocumentStore store;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger createCounter = new AtomicInteger();
    private final Object cleanupLock = new Object();

    Checkpoints(DocumentNodeStore store) {
        this.nodeStore = store;
        this.store = store.getDocumentStore();
        this.createIfNotExist();
    }

    public Revision create(long lifetimeInMillis) {
        Revision r = this.nodeStore.getHeadRevision();
        this.createCounter.getAndIncrement();
        this.performCleanupIfRequired();
        UpdateOp op = new UpdateOp(ID, false);
        long endTime = this.nodeStore.getClock().getTime() + lifetimeInMillis;
        op.setMapEntry(PROP_CHECKPOINT, r, Long.toString(endTime));
        this.store.createOrUpdate(Collection.SETTINGS, op);
        return r;
    }

    @CheckForNull
    public Revision getOldestRevisionToKeep() {
        SortedMap<Revision, String> checkpoints = this.getCheckpoints();
        if (checkpoints == null) {
            this.log.debug("No checkpoint registered so far");
            return null;
        }
        long currentTime = this.nodeStore.getClock().getTime();
        UpdateOp op = new UpdateOp(ID, false);
        Revision lastAliveRevision = null;
        long oldestExpiryTime = 0L;
        for (Map.Entry<Revision, String> e : checkpoints.entrySet()) {
            long expiryTime = Long.parseLong(e.getValue());
            if (currentTime > expiryTime) {
                op.removeMapEntry(PROP_CHECKPOINT, e.getKey());
                continue;
            }
            if (expiryTime <= oldestExpiryTime) continue;
            oldestExpiryTime = expiryTime;
            lastAliveRevision = e.getKey();
        }
        if (op.hasChanges()) {
            this.store.findAndUpdate(Collection.SETTINGS, op);
            this.log.debug("Purged {} expired checkpoints", (Object)op.getChanges().size());
        }
        return lastAliveRevision;
    }

    @CheckForNull
    private SortedMap<Revision, String> getCheckpoints() {
        Document cdoc = this.store.find(Collection.SETTINGS, ID, 0);
        return (SortedMap)cdoc.get(PROP_CHECKPOINT);
    }

    int size() {
        SortedMap<Revision, String> checkpoints = this.getCheckpoints();
        return checkpoints == null ? 0 : checkpoints.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCleanupIfRequired() {
        if (this.createCounter.get() > 100) {
            Object object = this.cleanupLock;
            synchronized (object) {
                this.getOldestRevisionToKeep();
                this.createCounter.set(0);
            }
        }
    }

    private void createIfNotExist() {
        if (this.store.find(Collection.SETTINGS, ID) == null) {
            UpdateOp updateOp = new UpdateOp(ID, true);
            updateOp.set("_id", ID);
            this.store.createOrUpdate(Collection.SETTINGS, updateOp);
        }
    }
}

