/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import com.google.common.base.Objects;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import java.net.UnknownHostException;

public class MongoConnection {
    private final DB db;
    private final MongoClient mongo;

    public MongoConnection(String uri) throws UnknownHostException {
        MongoClientOptions.Builder builder = MongoConnection.getDefaultBuilder();
        MongoClientURI mongoURI = new MongoClientURI(uri, builder);
        this.mongo = new MongoClient(mongoURI);
        this.db = this.mongo.getDB(mongoURI.getDatabase());
    }

    public MongoConnection(String host, int port, String database) throws Exception {
        this("mongodb://" + host + ":" + port + "/" + database);
    }

    public DB getDB() {
        return this.db;
    }

    public void close() {
        this.mongo.close();
    }

    public static MongoClientOptions.Builder getDefaultBuilder() {
        return new MongoClientOptions.Builder().description("MongoConnection for Oak DocumentMK").threadsAllowedToBlockForConnectionMultiplier(100);
    }

    public static String toString(MongoClientOptions opts) {
        return Objects.toStringHelper(opts).add("connectionsPerHost", opts.getConnectionsPerHost()).add("connectTimeout", opts.getConnectTimeout()).add("socketTimeout", opts.getSocketTimeout()).add("socketKeepAlive", opts.isSocketKeepAlive()).add("autoConnectRetry", opts.isAutoConnectRetry()).add("maxAutoConnectRetryTime", opts.getMaxAutoConnectRetryTime()).add("maxWaitTime", opts.getMaxWaitTime()).add("threadsAllowedToBlockForConnectionMultiplier", opts.getThreadsAllowedToBlockForConnectionMultiplier()).add("readPreference", opts.getReadPreference().getName()).add("writeConcern", opts.getWriteConcern()).toString();
    }
}

