/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.tree.ImmutableTree;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.apache.jackrabbit.util.Text;

class AccessControlValidator
extends DefaultValidator
implements AccessControlConstants {
    private final ImmutableTree parentAfter;
    private final PrivilegeBitsProvider privilegeBitsProvider;
    private final PrivilegeManager privilegeManager;
    private final RestrictionProvider restrictionProvider;
    private final TypePredicate isRepoAccessControllable;
    private final TypePredicate isAccessControllable;

    AccessControlValidator(ImmutableTree parentAfter, PrivilegeManager privilegeManager, PrivilegeBitsProvider privilegeBitsProvider, RestrictionProvider restrictionProvider) {
        this.parentAfter = parentAfter;
        this.privilegeBitsProvider = privilegeBitsProvider;
        this.privilegeManager = privilegeManager;
        this.restrictionProvider = restrictionProvider;
        this.isRepoAccessControllable = new TypePredicate(parentAfter.getNodeState(), "rep:RepoAccessControllable");
        this.isAccessControllable = new TypePredicate(parentAfter.getNodeState(), "rep:AccessControllable");
    }

    private AccessControlValidator(AccessControlValidator parent, ImmutableTree parentAfter) {
        this.parentAfter = parentAfter;
        this.privilegeBitsProvider = parent.privilegeBitsProvider;
        this.privilegeManager = parent.privilegeManager;
        this.restrictionProvider = parent.restrictionProvider;
        this.isRepoAccessControllable = parent.isRepoAccessControllable;
        this.isAccessControllable = parent.isAccessControllable;
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        if (AccessControlValidator.isAccessControlEntry(this.parentAfter)) {
            this.checkValidAccessControlEntry(this.parentAfter);
        }
        if ("jcr:mixinTypes".equals(after.getName())) {
            AccessControlValidator.checkMixinTypes(this.parentAfter);
        }
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (AccessControlValidator.isAccessControlEntry(this.parentAfter)) {
            this.checkValidAccessControlEntry(this.parentAfter);
        }
        if ("jcr:mixinTypes".equals(after.getName())) {
            AccessControlValidator.checkMixinTypes(this.parentAfter);
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
    }

    @Override
    public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
        ImmutableTree treeAfter = Preconditions.checkNotNull(this.parentAfter.getChild(name));
        this.checkValidTree(this.parentAfter, treeAfter, after);
        return new AccessControlValidator(this, treeAfter);
    }

    @Override
    public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        ImmutableTree treeAfter = Preconditions.checkNotNull(this.parentAfter.getChild(name));
        this.checkValidTree(this.parentAfter, treeAfter, after);
        return new AccessControlValidator(this, treeAfter);
    }

    @Override
    public Validator childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        return null;
    }

    private void checkValidTree(ImmutableTree parentAfter, Tree treeAfter, NodeState nodeAfter) throws CommitFailedException {
        if (AccessControlValidator.isPolicy(treeAfter)) {
            this.checkValidPolicy(parentAfter, treeAfter, nodeAfter);
        } else if (AccessControlValidator.isAccessControlEntry(treeAfter)) {
            this.checkValidAccessControlEntry(treeAfter);
        } else if ("rep:Restrictions".equals(TreeUtil.getPrimaryTypeName(treeAfter))) {
            AccessControlValidator.checkIsAccessControlEntry(parentAfter);
            this.checkValidRestrictions(parentAfter);
        }
    }

    private static boolean isPolicy(Tree tree) {
        return "rep:ACL".equals(TreeUtil.getPrimaryTypeName(tree));
    }

    private static boolean isAccessControlEntry(Tree tree) {
        String ntName = TreeUtil.getPrimaryTypeName(tree);
        return "rep:DenyACE".equals(ntName) || "rep:GrantACE".equals(ntName);
    }

    private static void checkIsAccessControlEntry(Tree tree) throws CommitFailedException {
        if (!AccessControlValidator.isAccessControlEntry(tree)) {
            throw AccessControlValidator.accessViolation(2, "Access control entry node expected.");
        }
    }

    private void checkValidPolicy(ImmutableTree parent, Tree policyTree, NodeState policyNode) throws CommitFailedException {
        Set<String> validPolicyNames;
        if ("rep:repoPolicy".equals(policyTree.getName())) {
            this.checkValidAccessControlledNode(parent, this.isRepoAccessControllable);
            AccessControlValidator.checkValidRepoAccessControlled(parent);
        } else {
            this.checkValidAccessControlledNode(parent, this.isAccessControllable);
        }
        Set<String> set = validPolicyNames = parent.isRoot() ? POLICY_NODE_NAMES : Collections.singleton("rep:policy");
        if (!validPolicyNames.contains(policyTree.getName())) {
            throw AccessControlValidator.accessViolation(3, "Invalid policy name " + policyTree.getName());
        }
        if (!policyNode.hasProperty(":childOrder")) {
            throw AccessControlValidator.accessViolation(4, "Invalid policy node: Order of children is not stable.");
        }
        HashSet<Entry> aceSet = Sets.newHashSet();
        for (Tree child : policyTree.getChildren()) {
            if (!AccessControlValidator.isAccessControlEntry(child) || aceSet.add(new Entry(parent.getPath(), child))) continue;
            throw AccessControlValidator.accessViolation(13, "Duplicate ACE found in policy");
        }
    }

    private void checkValidAccessControlledNode(ImmutableTree accessControlledTree, TypePredicate requiredMixin) throws CommitFailedException {
        if (AC_NODETYPE_NAMES.contains(TreeUtil.getPrimaryTypeName(accessControlledTree))) {
            throw AccessControlValidator.accessViolation(5, "Access control policy within access control content (" + accessControlledTree.getPath() + ')');
        }
        if (!requiredMixin.apply(accessControlledTree.getNodeState())) {
            String msg = "Isolated policy node. Parent is not of type " + requiredMixin;
            throw AccessControlValidator.accessViolation(6, msg);
        }
    }

    private void checkValidAccessControlEntry(Tree aceNode) throws CommitFailedException {
        Tree parent = aceNode.getParent();
        if (!parent.exists() || !"rep:ACL".equals(TreeUtil.getPrimaryTypeName(parent))) {
            throw AccessControlValidator.accessViolation(7, "Isolated access control entry at " + aceNode.getPath());
        }
        this.checkValidPrincipal(TreeUtil.getString(aceNode, "rep:principalName"));
        this.checkValidPrivileges(TreeUtil.getStrings(aceNode, "rep:privileges"));
        this.checkValidRestrictions(aceNode);
    }

    private void checkValidPrincipal(String principalName) throws CommitFailedException {
        if (principalName == null || principalName.isEmpty()) {
            throw AccessControlValidator.accessViolation(8, "Missing principal name.");
        }
    }

    private void checkValidPrivileges(Iterable<String> privilegeNames) throws CommitFailedException {
        if (privilegeNames == null || Iterables.isEmpty(privilegeNames)) {
            throw AccessControlValidator.accessViolation(9, "Missing privileges.");
        }
        for (String privilegeName : privilegeNames) {
            try {
                Privilege privilege = this.privilegeManager.getPrivilege(privilegeName);
                if (!privilege.isAbstract()) continue;
                throw AccessControlValidator.accessViolation(11, "Abstract privilege " + privilegeName);
            }
            catch (AccessControlException e) {
                throw AccessControlValidator.accessViolation(10, "Invalid privilege " + privilegeName);
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Failed to read privileges", e);
            }
        }
    }

    private void checkValidRestrictions(Tree aceTree) throws CommitFailedException {
        Tree aclTree = Preconditions.checkNotNull(aceTree.getParent());
        String aclPath = aclTree.getPath();
        String path = "rep:repoPolicy".equals(Text.getName(aclPath)) ? null : Text.getRelativeParent(aclPath, 1);
        try {
            this.restrictionProvider.validateRestrictions(path, aceTree);
        }
        catch (AccessControlException e) {
            throw new CommitFailedException("AccessControl", 1, "Access control violation", e);
        }
        catch (RepositoryException e) {
            throw new CommitFailedException("Oak", 13, "Internal error", e);
        }
    }

    private static void checkMixinTypes(Tree parentTree) throws CommitFailedException {
        Iterable<String> mixinNames = TreeUtil.getNames(parentTree, "jcr:mixinTypes");
        if (Iterables.contains(mixinNames, "rep:RepoAccessControllable")) {
            AccessControlValidator.checkValidRepoAccessControlled(parentTree);
        }
    }

    private static void checkValidRepoAccessControlled(Tree accessControlledTree) throws CommitFailedException {
        if (!accessControlledTree.isRoot()) {
            throw AccessControlValidator.accessViolation(12, "Only root can store repository level policies.");
        }
    }

    private static CommitFailedException accessViolation(int code, String message) {
        return new CommitFailedException("AccessControl", code, message);
    }

    private class Entry {
        private final String principalName;
        private final PrivilegeBits privilegeBits;
        private final Set<Restriction> restrictions;

        private Entry(String path, Tree aceTree) {
            this.principalName = aceTree.getProperty("rep:principalName").getValue(Type.STRING);
            this.privilegeBits = AccessControlValidator.this.privilegeBitsProvider.getBits(aceTree.getProperty("rep:privileges").getValue(Type.NAMES));
            this.restrictions = AccessControlValidator.this.restrictionProvider.readRestrictions(path, aceTree);
        }

        public int hashCode() {
            return Objects.hashCode(this.principalName, this.privilegeBits, this.restrictions);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Entry) {
                Entry other = (Entry)o;
                return Objects.equal(this.principalName, other.principalName) && this.privilegeBits.equals(other.privilegeBits) && this.restrictions.equals(other.restrictions);
            }
            return false;
        }
    }
}

