/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.user.action;

import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.action.AbstractAuthorizableAction;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlAction
extends AbstractAuthorizableAction {
    private static final Logger log = LoggerFactory.getLogger(AccessControlAction.class);
    public static final String USER_PRIVILEGE_NAMES = "userPrivilegeNames";
    public static final String GROUP_PRIVILEGE_NAMES = "groupPrivilegeNames";
    private SecurityProvider securityProvider;
    private String[] groupPrivilegeNames = new String[0];
    private String[] userPrivilegeNames = new String[0];

    @Override
    public void init(SecurityProvider securityProvider, ConfigurationParameters config) {
        this.securityProvider = securityProvider;
        this.userPrivilegeNames = AccessControlAction.privilegeNames(config, USER_PRIVILEGE_NAMES);
        this.groupPrivilegeNames = AccessControlAction.privilegeNames(config, GROUP_PRIVILEGE_NAMES);
    }

    @Override
    public void onCreate(Group group, Root root, NamePathMapper namePathMapper) throws RepositoryException {
        this.setAC(group, root, namePathMapper);
    }

    @Override
    public void onCreate(User user, String password, Root root, NamePathMapper namePathMapper) throws RepositoryException {
        this.setAC(user, root, namePathMapper);
    }

    private static String[] privilegeNames(ConfigurationParameters config, String paramName) {
        String[] privilegeNames = config.getConfigValue(paramName, null, String[].class);
        if (privilegeNames != null && privilegeNames.length > 0) {
            return privilegeNames;
        }
        return new String[0];
    }

    private void setAC(@Nonnull Authorizable authorizable, @Nonnull Root root, @Nonnull NamePathMapper namePathMapper) throws RepositoryException {
        if (this.securityProvider == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.isSystemUser(authorizable)) {
            log.debug("System user: " + authorizable.getID() + "; omit ac setup.");
            return;
        }
        if (this.groupPrivilegeNames.length == 0 && this.userPrivilegeNames.length == 0) {
            log.debug("No privileges configured for groups and users; omit ac setup.");
            return;
        }
        String path = authorizable.getPath();
        AuthorizationConfiguration acConfig = this.securityProvider.getConfiguration(AuthorizationConfiguration.class);
        AccessControlManager acMgr = acConfig.getAccessControlManager(root, namePathMapper);
        JackrabbitAccessControlList acl = null;
        AccessControlPolicyIterator it = acMgr.getApplicablePolicies(path);
        while (it.hasNext()) {
            AccessControlPolicy plc = it.nextAccessControlPolicy();
            if (!(plc instanceof JackrabbitAccessControlList)) continue;
            acl = (JackrabbitAccessControlList)plc;
            break;
        }
        if (acl == null) {
            log.warn("Cannot process AccessControlAction: no applicable ACL at " + path);
        } else {
            Principal principal = authorizable.getPrincipal();
            boolean modified = false;
            if (authorizable.isGroup()) {
                if (this.groupPrivilegeNames.length > 0) {
                    modified = acl.addAccessControlEntry(principal, AccessControlAction.getPrivileges(this.groupPrivilegeNames, acMgr));
                }
            } else if (this.userPrivilegeNames.length > 0) {
                modified = acl.addAccessControlEntry(principal, AccessControlAction.getPrivileges(this.userPrivilegeNames, acMgr));
            }
            if (modified) {
                acMgr.setPolicy(path, acl);
            }
        }
    }

    private boolean isSystemUser(@Nonnull Authorizable authorizable) throws RepositoryException {
        if (authorizable.isGroup()) {
            return false;
        }
        ConfigurationParameters userConfig = this.securityProvider.getConfiguration(UserConfiguration.class).getParameters();
        String userId = authorizable.getID();
        return UserUtil.getAdminId(userConfig).equals(userId) || UserUtil.getAnonymousId(userConfig).equals(userId);
    }

    private static Privilege[] getPrivileges(@Nullable String[] privNames, @Nonnull AccessControlManager acMgr) throws RepositoryException {
        if (privNames == null || privNames.length == 0) {
            return new Privilege[0];
        }
        Privilege[] privileges = new Privilege[privNames.length];
        for (int i = 0; i < privNames.length; ++i) {
            privileges[i] = acMgr.privilegeFromName(privNames[i]);
        }
        return privileges;
    }
}

