/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util.config.easyconf;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.common.homelibrary.util.config.easyconf.ComponentConfiguration;
import org.gcube.common.homelibrary.util.config.easyconf.ConfigurationException;

public class EasyConf {
    private static final Log log = LogFactory.getLog(EasyConf.class);
    private static Map cache = new HashMap();

    private EasyConf() {
    }

    public static ComponentConfiguration getConfiguration(String componentName) {
        try {
            ComponentConfiguration componentConf = (ComponentConfiguration)cache.get(componentName);
            if (componentConf == null) {
                componentConf = new ComponentConfiguration(componentName);
                cache.put(componentName, componentConf);
            }
            return componentConf;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(componentName, "Error reading the configuration", e);
        }
    }

    public static ComponentConfiguration getConfiguration(String companyId, String componentName) {
        try {
            String cacheKey = companyId + componentName;
            ComponentConfiguration componentConf = (ComponentConfiguration)cache.get(cacheKey);
            if (componentConf == null) {
                componentConf = new ComponentConfiguration(companyId, componentName);
                cache.put(cacheKey, componentConf);
            }
            return componentConf;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(componentName, "Error reading the configuration for " + companyId, e);
        }
    }

    public static void refreshComponent(String componentName) {
        ComponentConfiguration componentConf = (ComponentConfiguration)cache.get(componentName);
        if (componentConf != null) {
            cache.remove(componentName);
            log.info("Refreshed the configuration of component " + componentName);
        }
    }

    public static void refreshAll() {
        cache = new HashMap();
        log.info("Refreshed the configuration of all components");
    }
}

