/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node.locate;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.dcp.DCPRequest;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.locate.Locator;
import com.couchbase.client.core.retry.RetryHelper;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import java.util.List;

public class DCPLocator
implements Locator {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(DCPLocator.class);

    @Override
    public void locateAndDispatch(CouchbaseRequest request, List<Node> nodes, ClusterConfig cluster, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
        BucketConfig bucket = cluster.bucketConfig(request.bucket());
        if (!(bucket instanceof CouchbaseBucketConfig) || !(request instanceof DCPRequest)) {
            throw new IllegalStateException("Unsupported Bucket Type: for request " + request);
        }
        CouchbaseBucketConfig config = (CouchbaseBucketConfig)bucket;
        DCPRequest dcpRequest = (DCPRequest)request;
        boolean useFastForward = request.retryCount() > 0 && config.hasFastForwardMap();
        short nodeId = config.nodeIndexForMaster(dcpRequest.partition(), useFastForward);
        if (nodeId == -2) {
            return;
        }
        if (nodeId == -1) {
            RetryHelper.retryOrCancel(env, request, responseBuffer);
            return;
        }
        NodeInfo nodeInfo = config.nodeAtIndex(nodeId);
        if (config.nodes().size() != nodes.size()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Node list and configuration's partition hosts sizes : {} <> {}, rescheduling", (Object)nodes.size(), (Object)config.nodes().size());
            }
            RetryHelper.retryOrCancel(env, request, responseBuffer);
            return;
        }
        for (Node node : nodes) {
            if (!node.hostname().equals(nodeInfo.hostname())) continue;
            node.send(request);
            return;
        }
        throw new IllegalStateException("Node not found for request: " + request);
    }
}

