/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.kernel;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.kernel.FastMove;
import org.apache.jackrabbit.oak.kernel.KernelNodeBuilder;
import org.apache.jackrabbit.oak.kernel.KernelNodeState;
import org.apache.jackrabbit.oak.kernel.KernelNodeStore;
import org.apache.jackrabbit.oak.kernel.KernelNodeStoreBranch;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.ConflictAnnotatingRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class KernelRootBuilder
extends MemoryNodeBuilder
implements FastMove {
    private static final int UPDATE_LIMIT = Integer.getInteger("update.limit", 1000);
    private final KernelNodeStore store;
    @Nonnull
    private NodeState base;
    private KernelNodeStoreBranch branch;
    private int updates = 0;

    KernelRootBuilder(KernelNodeState base, KernelNodeStore store) {
        super(Preconditions.checkNotNull(base));
        this.base = base;
        this.store = store;
        this.branch = store.createBranch(base);
    }

    @Override
    @Nonnull
    public NodeState getBaseState() {
        return this.base;
    }

    @Override
    public void reset(@Nonnull NodeState newBase) {
        this.base = Preconditions.checkNotNull(newBase);
        super.reset(newBase);
    }

    @Override
    protected MemoryNodeBuilder createChildBuilder(String name) {
        return new KernelNodeBuilder(this, name, this);
    }

    @Override
    protected void updated() {
        if (this.updates++ > UPDATE_LIMIT) {
            this.purge();
        }
    }

    @Override
    public boolean moveFrom(KernelNodeBuilder source, String newName) {
        String sourcePath = source.getPath();
        return this.move(sourcePath, '/' + newName);
    }

    NodeState rebase() {
        NodeState head = this.getNodeState();
        NodeState inMemBase = super.getBaseState();
        this.branch.rebase();
        super.reset(this.branch.getHead());
        head.compareAgainstBaseState(inMemBase, new ConflictAnnotatingRebaseDiff(this));
        this.base = this.branch.getBase();
        return this.getNodeState();
    }

    NodeState reset() {
        this.branch = this.store.createBranch(this.store.getRoot());
        NodeState head = this.branch.getHead();
        this.reset(head);
        return head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeState merge(CommitHook hook, CommitInfo info) throws CommitFailedException {
        this.purge();
        boolean success = false;
        try {
            this.branch.merge(hook, info);
            success = true;
        }
        finally {
            if (!success) {
                super.reset(this.branch.getHead());
                this.base = this.branch.getBase();
            }
        }
        return this.reset();
    }

    boolean move(String source, String target) {
        this.purge();
        boolean success = this.branch.move(source, target);
        super.reset(this.branch.getHead());
        return success;
    }

    boolean copy(String source, String target) {
        this.purge();
        boolean success = this.branch.copy(source, target);
        super.reset(this.branch.getHead());
        return success;
    }

    private void purge() {
        this.branch.setRoot(this.getNodeState());
        super.reset(this.branch.getHead());
        this.updates = 0;
    }
}

