/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.observation.filter.ACFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.AddSubtreeFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.ConstantFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.DeleteSubtreeFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventTypeFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.FilterProvider;
import org.apache.jackrabbit.oak.plugins.observation.filter.Filters;
import org.apache.jackrabbit.oak.plugins.observation.filter.GlobbingPathFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.MoveFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.PropertyPredicate;
import org.apache.jackrabbit.oak.plugins.observation.filter.UniversalFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.UuidPredicate;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public final class FilterBuilder {
    private static final int ALL_EVENTS = 127;
    private boolean includeSessionLocal;
    private boolean includeClusterExternal;
    private boolean includeClusterLocal = true;
    private String basePath = "/";
    private Condition condition = this.includeAll();

    @Nonnull
    public FilterBuilder includeSessionLocal(boolean include) {
        this.includeSessionLocal = include;
        return this;
    }

    @Nonnull
    public FilterBuilder includeClusterExternal(boolean include) {
        this.includeClusterExternal = include;
        return this;
    }

    @Nonnull
    public FilterBuilder includeClusterLocal(boolean include) {
        this.includeClusterLocal = include;
        return this;
    }

    @Nonnull
    public FilterBuilder basePath(@Nonnull String absPath) {
        this.basePath = Preconditions.checkNotNull(absPath);
        return this;
    }

    @Nonnull
    public FilterBuilder condition(@Nonnull Condition condition) {
        this.condition = Preconditions.checkNotNull(condition);
        return this;
    }

    @Nonnull
    public Condition includeAll() {
        return ConstantCondition.INCLUDE_ALL;
    }

    @Nonnull
    public Condition excludeAll() {
        return ConstantCondition.EXCLUDE_ALL;
    }

    @Nonnull
    public Condition accessControl(@Nonnull PermissionProvider permissionProvider) {
        return new ACCondition(Preconditions.checkNotNull(permissionProvider));
    }

    @Nonnull
    public Condition path(@Nonnull String pathPattern) {
        return new PathCondition(Preconditions.checkNotNull(pathPattern));
    }

    @Nonnull
    public Condition eventType(int eventTypes) {
        if ((0x7F & eventTypes) == 0) {
            return this.excludeAll();
        }
        if ((0x7F & eventTypes) != 127) {
            return new EventTypeCondition(eventTypes);
        }
        return this.includeAll();
    }

    @Nonnull
    public Condition nodeType(@Nonnull UniversalFilter.Selector selector, @CheckForNull String[] ntNames) {
        if (ntNames == null) {
            return this.includeAll();
        }
        if (ntNames.length == 0) {
            return this.excludeAll();
        }
        return new NodeTypeCondition(Preconditions.checkNotNull(selector), ntNames);
    }

    @Nonnull
    public Condition uuid(@Nonnull UniversalFilter.Selector selector, @CheckForNull String[] uuids) {
        if (uuids == null) {
            return this.includeAll();
        }
        if (uuids.length == 0) {
            return this.excludeAll();
        }
        return new UniversalCondition(Preconditions.checkNotNull(selector), new UuidPredicate(uuids));
    }

    @Nonnull
    public Condition property(@Nonnull UniversalFilter.Selector selector, @Nonnull String name, @Nonnull Predicate<PropertyState> predicate) {
        return new UniversalCondition(Preconditions.checkNotNull(selector), new PropertyPredicate(Preconditions.checkNotNull(name), Preconditions.checkNotNull(predicate)));
    }

    @Nonnull
    public Condition universal(@Nonnull UniversalFilter.Selector selector, @Nonnull Predicate<NodeState> predicate) {
        return new UniversalCondition(Preconditions.checkNotNull(selector), Preconditions.checkNotNull(predicate));
    }

    @Nonnull
    public Condition addSubtree() {
        return new AddSubtreeTreeCondition();
    }

    @Nonnull
    public Condition deleteSubtree() {
        return new DeleteSubtreeTreeCondition();
    }

    @Nonnull
    public Condition moveSubtree() {
        return new MoveCondition();
    }

    @Nonnull
    public Condition any(Condition ... conditions) {
        return new AnyCondition(Preconditions.checkNotNull(conditions));
    }

    @Nonnull
    public Condition all(Condition ... conditions) {
        return new AllCondition(Preconditions.checkNotNull(conditions));
    }

    @Nonnull
    public FilterProvider build() {
        return new FilterProvider(){
            final boolean includeSessionLocal;
            final boolean includeClusterExternal;
            final boolean includeClusterLocal;
            final String basePath;
            final Condition condition;
            {
                this.includeSessionLocal = FilterBuilder.this.includeSessionLocal;
                this.includeClusterExternal = FilterBuilder.this.includeClusterExternal;
                this.includeClusterLocal = FilterBuilder.this.includeClusterLocal;
                this.basePath = FilterBuilder.this.basePath;
                this.condition = FilterBuilder.this.condition;
            }

            @Override
            public boolean includeCommit(@Nonnull String sessionId, @CheckForNull CommitInfo info) {
                return !(!this.includeSessionLocal && this.isLocal(Preconditions.checkNotNull(sessionId), info) || !this.includeClusterExternal && this.isExternal(info) || !this.includeClusterLocal && !this.isExternal(info));
            }

            @Override
            @Nonnull
            public EventFilter getFilter(@Nonnull NodeState before, @Nonnull NodeState after) {
                return this.condition.createFilter(Preconditions.checkNotNull(before), Preconditions.checkNotNull(after), this.basePath);
            }

            @Override
            @Nonnull
            public String getPath() {
                return this.basePath;
            }

            private boolean isLocal(String sessionId, CommitInfo info) {
                return info != null && Objects.equal(info.getSessionId(), sessionId);
            }

            private boolean isExternal(CommitInfo info) {
                return info == null;
            }
        };
    }

    private static NodeState getChildNode(NodeState node, String path) {
        for (String name : PathUtils.elements(path)) {
            node = node.getChildNode(name);
        }
        return node;
    }

    private static class AllCondition
    implements Condition {
        private final Condition[] conditions;

        public AllCondition(Condition ... conditions) {
            this.conditions = conditions;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after, String basePath) {
            ArrayList<EventFilter> filters = Lists.newArrayList();
            for (Condition condition : this.conditions) {
                if (condition == ConstantCondition.EXCLUDE_ALL) {
                    return ConstantFilter.EXCLUDE_ALL;
                }
                if (condition == ConstantCondition.INCLUDE_ALL) continue;
                filters.add(condition.createFilter(before, after, basePath));
            }
            return filters.isEmpty() ? ConstantFilter.INCLUDE_ALL : Filters.all(filters);
        }
    }

    private static class AnyCondition
    implements Condition {
        private final Condition[] conditions;

        public AnyCondition(Condition ... conditions) {
            this.conditions = conditions;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after, String basePath) {
            ArrayList<EventFilter> filters = Lists.newArrayList();
            for (Condition condition : this.conditions) {
                if (condition == ConstantCondition.INCLUDE_ALL) {
                    return ConstantFilter.INCLUDE_ALL;
                }
                if (condition == ConstantCondition.EXCLUDE_ALL) continue;
                filters.add(condition.createFilter(before, after, basePath));
            }
            return filters.isEmpty() ? ConstantFilter.EXCLUDE_ALL : Filters.any(filters);
        }
    }

    protected static class MoveCondition
    implements Condition {
        protected MoveCondition() {
        }

        @Override
        @Nonnull
        public EventFilter createFilter(@Nonnull NodeState before, @Nonnull NodeState after, String basePath) {
            return new MoveFilter();
        }
    }

    protected static class DeleteSubtreeTreeCondition
    implements Condition {
        protected DeleteSubtreeTreeCondition() {
        }

        @Override
        @Nonnull
        public EventFilter createFilter(@Nonnull NodeState before, @Nonnull NodeState after, String basePath) {
            return DeleteSubtreeFilter.getInstance();
        }
    }

    protected static class AddSubtreeTreeCondition
    implements Condition {
        protected AddSubtreeTreeCondition() {
        }

        @Override
        @Nonnull
        public EventFilter createFilter(@Nonnull NodeState before, @Nonnull NodeState after, String basePath) {
            return AddSubtreeFilter.getInstance();
        }
    }

    private static class UniversalCondition
    implements Condition {
        private final UniversalFilter.Selector selector;
        private final Predicate<NodeState> predicate;

        public UniversalCondition(UniversalFilter.Selector selector, Predicate<NodeState> predicate) {
            this.selector = selector;
            this.predicate = predicate;
        }

        @Override
        @Nonnull
        public EventFilter createFilter(NodeState before, NodeState after, String basePath) {
            return new UniversalFilter(FilterBuilder.getChildNode(before, basePath), FilterBuilder.getChildNode(after, basePath), this.selector, this.predicate);
        }
    }

    private static class NodeTypeCondition
    implements Condition {
        private final UniversalFilter.Selector selector;
        private final String[] ntNames;

        public NodeTypeCondition(UniversalFilter.Selector selector, String[] ntNames) {
            this.selector = selector;
            this.ntNames = ntNames;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after, String basePath) {
            TypePredicate predicate = new TypePredicate(after.exists() ? after : before, this.ntNames);
            return new UniversalFilter(FilterBuilder.getChildNode(before, basePath), FilterBuilder.getChildNode(after, basePath), this.selector, predicate);
        }
    }

    private static class EventTypeCondition
    implements Condition {
        private final int eventTypes;

        public EventTypeCondition(int eventTypes) {
            this.eventTypes = eventTypes;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after, String basePath) {
            return new EventTypeFilter(this.eventTypes);
        }
    }

    private static class PathCondition
    implements Condition {
        private final String pathGlob;

        public PathCondition(String pathGlob) {
            this.pathGlob = pathGlob;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after, String basePath) {
            return new GlobbingPathFilter(this.pathGlob);
        }
    }

    private static class ACCondition
    implements Condition {
        private final PermissionProvider permissionProvider;

        public ACCondition(PermissionProvider permissionProvider) {
            this.permissionProvider = permissionProvider;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after, String basePath) {
            return new ACFilter(before, after, this.permissionProvider, basePath);
        }
    }

    private static class ConstantCondition
    implements Condition {
        public static final ConstantCondition INCLUDE_ALL = new ConstantCondition(true);
        public static final ConstantCondition EXCLUDE_ALL = new ConstantCondition(false);
        private final boolean value;

        public ConstantCondition(boolean value) {
            this.value = value;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after, String basePath) {
            return this.value ? Filters.includeAll() : Filters.excludeAll();
        }
    }

    public static interface Condition {
        @Nonnull
        public EventFilter createFilter(@Nonnull NodeState var1, @Nonnull NodeState var2, String var3);
    }
}

