/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.restriction;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;

public final class CompositePattern
implements RestrictionPattern {
    private final List<RestrictionPattern> patterns;

    public CompositePattern(@Nonnull List<RestrictionPattern> patterns) {
        this.patterns = patterns;
    }

    @Override
    public boolean matches(@Nonnull Tree tree, @Nullable PropertyState property) {
        for (RestrictionPattern pattern : this.patterns) {
            if (pattern.matches(tree, property)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(@Nonnull String path) {
        for (RestrictionPattern pattern : this.patterns) {
            if (pattern.matches(path)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches() {
        for (RestrictionPattern pattern : this.patterns) {
            if (pattern.matches()) continue;
            return false;
        }
        return true;
    }
}

