/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.query;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.AbstractGenericHandler;
import com.couchbase.client.core.endpoint.ResponseStatusConverter;
import com.couchbase.client.core.endpoint.util.ByteBufJsonHelper;
import com.couchbase.client.core.endpoint.util.ClosingPositionBufProcessor;
import com.couchbase.client.core.endpoint.util.StringClosingPositionBufProcessor;
import com.couchbase.client.core.endpoint.util.WhitespaceSkipper;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.AbstractCouchbaseRequest;
import com.couchbase.client.core.message.AbstractCouchbaseResponse;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.KeepAlive;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.query.GenericQueryRequest;
import com.couchbase.client.core.message.query.GenericQueryResponse;
import com.couchbase.client.core.message.query.QueryRequest;
import com.couchbase.client.core.message.query.RawQueryRequest;
import com.couchbase.client.core.message.query.RawQueryResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.UnicastAutoReleaseSubject;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.ByteBufProcessor;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpContent;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpObject;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpResponse;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.deps.io.netty.handler.codec.http.LastHttpContent;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.subjects.AsyncSubject;

public class QueryHandler
extends AbstractGenericHandler<HttpObject, HttpRequest, QueryRequest> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(QueryHandler.class);
    protected static final byte QUERY_STATE_INITIAL = 0;
    protected static final byte QUERY_STATE_SIGNATURE = 1;
    protected static final byte QUERY_STATE_ROWS = 2;
    protected static final byte QUERY_STATE_ROWS_RAW = 20;
    protected static final byte QUERY_STATE_ROWS_DECIDE = 29;
    protected static final byte QUERY_STATE_ERROR = 3;
    protected static final byte QUERY_STATE_WARNING = 4;
    protected static final byte QUERY_STATE_STATUS = 5;
    protected static final byte QUERY_STATE_INFO = 6;
    protected static final byte QUERY_STATE_NO_INFO = 7;
    protected static final byte QUERY_STATE_DONE = 8;
    private static final int MINIMUM_WINDOW_FOR_REQUESTID = 55;
    public static final int MINIMUM_WINDOW_FOR_CLIENTID_TOKEN = 27;
    private HttpResponse responseHeader;
    private ByteBuf responseContent;
    private UnicastAutoReleaseSubject<ByteBuf> queryRowObservable;
    private UnicastAutoReleaseSubject<ByteBuf> querySignatureObservable;
    private UnicastAutoReleaseSubject<ByteBuf> queryErrorObservable;
    private AsyncSubject<String> queryStatusObservable;
    private UnicastAutoReleaseSubject<ByteBuf> queryInfoObservable;
    private byte queryParsingState = 0;
    private boolean sectionDone = false;

    public QueryHandler(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer, boolean isTransient, boolean pipeline) {
        super(endpoint, responseBuffer, isTransient, pipeline);
    }

    QueryHandler(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer, Queue<QueryRequest> queue, boolean isTransient, boolean pipeline) {
        super(endpoint, responseBuffer, queue, isTransient, pipeline);
    }

    @Override
    protected HttpRequest encodeRequest(ChannelHandlerContext ctx, QueryRequest msg) throws Exception {
        DefaultFullHttpRequest request;
        if (msg instanceof GenericQueryRequest) {
            GenericQueryRequest queryRequest = (GenericQueryRequest)msg;
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/query");
            request.headers().set("User-Agent", (Object)this.env().userAgent());
            if (queryRequest.isJsonFormat()) {
                request.headers().set("Content-Type", (Object)"application/json");
            }
        } else {
            if (msg instanceof KeepAliveRequest) {
                DefaultFullHttpRequest request2 = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/admin/ping");
                request2.headers().set("User-Agent", (Object)this.env().userAgent());
                request2.headers().set("Host", (Object)this.remoteHttpHost(ctx));
                return request2;
            }
            throw new IllegalArgumentException("Unknown incoming QueryRequest type " + msg.getClass());
        }
        ByteBuf query = ctx.alloc().buffer(((GenericQueryRequest)msg).query().length());
        query.writeBytes(((GenericQueryRequest)msg).query().getBytes(CHARSET));
        request.headers().add("Content-Length", (Object)query.readableBytes());
        request.headers().set("Host", (Object)this.remoteHttpHost(ctx));
        request.content().writeBytes(query);
        query.release();
        QueryHandler.addHttpBasicAuth(ctx, request, msg.bucket(), msg.password());
        return request;
    }

    @Override
    protected CouchbaseResponse decodeResponse(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        CouchbaseResponse response = null;
        if (msg instanceof HttpResponse) {
            this.responseHeader = (HttpResponse)msg;
            if (this.responseContent != null) {
                this.responseContent.clear();
            } else {
                this.responseContent = ctx.alloc().buffer();
            }
        }
        if (this.currentRequest() instanceof KeepAliveRequest) {
            if (msg instanceof LastHttpContent) {
                response = new KeepAliveResponse(ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code()), (CouchbaseRequest)this.currentRequest());
                this.responseContent.clear();
                this.responseContent.discardReadBytes();
                this.finishedDecoding();
            }
        } else if (msg instanceof HttpContent) {
            this.responseContent.writeBytes(((HttpContent)msg).content());
            boolean lastChunk = msg instanceof LastHttpContent;
            if (this.currentRequest() instanceof RawQueryRequest) {
                response = this.handleRawQueryResponse(lastChunk, ctx);
            } else if (this.currentRequest() instanceof GenericQueryRequest) {
                if (this.queryRowObservable == null) {
                    response = this.handleGenericQueryResponse(lastChunk);
                    if (response != null) {
                        this.parseQueryResponse(lastChunk);
                    }
                } else {
                    this.parseQueryResponse(lastChunk);
                }
            }
        }
        return response;
    }

    private RawQueryResponse handleRawQueryResponse(boolean lastChunk, ChannelHandlerContext ctx) {
        if (!lastChunk) {
            return null;
        }
        ResponseStatus status = ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code());
        ByteBuf responseCopy = ctx.alloc().buffer(this.responseContent.readableBytes(), this.responseContent.readableBytes());
        responseCopy.writeBytes(this.responseContent);
        this.cleanupQueryStates();
        return new RawQueryResponse(status, (CouchbaseRequest)this.currentRequest(), responseCopy, this.responseHeader.getStatus().code(), this.responseHeader.getStatus().reasonPhrase());
    }

    private boolean isEmptySection(int openBracketPos) {
        int nextColon = ByteBufJsonHelper.findNextChar(this.responseContent, ':');
        return nextColon > -1 && nextColon < openBracketPos;
    }

    private CouchbaseResponse handleGenericQueryResponse(boolean lastChunk) {
        String clientId = "";
        if (this.responseContent.readableBytes() < 82 && !lastChunk) {
            return null;
        }
        int startIndex = this.responseContent.readerIndex();
        if (this.responseContent.readableBytes() < 55) {
            return null;
        }
        this.responseContent.skipBytes(ByteBufJsonHelper.findNextChar(this.responseContent, ':'));
        this.responseContent.skipBytes(ByteBufJsonHelper.findNextChar(this.responseContent, '\"') + 1);
        int endOfId = ByteBufJsonHelper.findNextChar(this.responseContent, '\"');
        ByteBuf slice = this.responseContent.readSlice(endOfId);
        String requestId = slice.toString(CHARSET);
        if (this.responseContent.readableBytes() >= 27 && ByteBufJsonHelper.findNextChar(this.responseContent, ':') < 27) {
            this.responseContent.markReaderIndex();
            ByteBuf slice2 = this.responseContent.readSlice(ByteBufJsonHelper.findNextChar(this.responseContent, ':'));
            if (slice2.toString(CHARSET).contains("clientContextID")) {
                int openingNextToken;
                boolean hasClosingQuote;
                this.responseContent.skipBytes(ByteBufJsonHelper.findNextChar(this.responseContent, '\"') + 1);
                int clientIdSize = ByteBufJsonHelper.findNextCharNotPrefixedBy(this.responseContent, '\"', '\\');
                if (clientIdSize < 0) {
                    this.responseContent.readerIndex(startIndex);
                    return null;
                }
                clientId = this.responseContent.readSlice(clientIdSize).toString(CHARSET);
                boolean bl = hasClosingQuote = this.responseContent.readableBytes() > 0;
                if (hasClosingQuote) {
                    this.responseContent.skipBytes(1);
                }
                if ((openingNextToken = ByteBufJsonHelper.findNextChar(this.responseContent, '\"')) > -1) {
                    this.responseContent.skipBytes(openingNextToken);
                }
            } else {
                this.responseContent.resetReaderIndex();
            }
        }
        boolean success = true;
        if (this.responseContent.readableBytes() >= 20) {
            ByteBuf peekForErrors = this.responseContent.slice(this.responseContent.readerIndex(), 20);
            if (peekForErrors.toString(CHARSET).contains("errors")) {
                success = false;
            }
        } else {
            this.responseContent.readerIndex(startIndex);
            return null;
        }
        ResponseStatus status = ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code());
        if (!success) {
            status = ResponseStatus.FAILURE;
        }
        Scheduler scheduler = this.env().scheduler();
        long ttl = this.env().autoreleaseAfter();
        this.queryRowObservable = UnicastAutoReleaseSubject.create(ttl, TimeUnit.MILLISECONDS, scheduler);
        this.queryErrorObservable = UnicastAutoReleaseSubject.create(ttl, TimeUnit.MILLISECONDS, scheduler);
        this.queryStatusObservable = AsyncSubject.create();
        this.queryInfoObservable = UnicastAutoReleaseSubject.create(ttl, TimeUnit.MILLISECONDS, scheduler);
        this.querySignatureObservable = UnicastAutoReleaseSubject.create(ttl, TimeUnit.MILLISECONDS, scheduler);
        String rid = clientId == null ? requestId : clientId + " / " + requestId;
        this.queryRowObservable.withTraceIdentifier("queryRow." + rid);
        this.queryErrorObservable.withTraceIdentifier("queryError." + rid);
        this.queryInfoObservable.withTraceIdentifier("queryInfo." + rid);
        this.querySignatureObservable.withTraceIdentifier("querySignature." + rid);
        return new GenericQueryResponse(this.queryErrorObservable.onBackpressureBuffer().observeOn(scheduler), this.queryRowObservable.onBackpressureBuffer().observeOn(scheduler), this.querySignatureObservable.onBackpressureBuffer().observeOn(scheduler), this.queryStatusObservable.onBackpressureBuffer().observeOn(scheduler), this.queryInfoObservable.onBackpressureBuffer().observeOn(scheduler), (CouchbaseRequest)this.currentRequest(), status, requestId, clientId);
    }

    private void parseQueryResponse(boolean lastChunk) {
        if (this.sectionDone || this.queryParsingState == 0) {
            this.queryParsingState = this.transitionToNextToken(lastChunk);
        }
        if (this.queryParsingState == 1) {
            this.parseQuerySignature(lastChunk);
        }
        if (this.queryParsingState == 29) {
            this.decideBetweenRawAndObjects(lastChunk);
        }
        if (this.queryParsingState == 2) {
            this.parseQueryRows(lastChunk);
        } else if (this.queryParsingState == 20) {
            this.parseQueryRowsRaw(lastChunk);
        }
        if (this.queryParsingState == 3) {
            this.parseQueryError(lastChunk);
        }
        if (this.queryParsingState == 4) {
            this.parseQueryError(lastChunk);
        }
        if (this.queryParsingState == 5) {
            this.parseQueryStatus(lastChunk);
        }
        if (this.queryParsingState == 6) {
            this.parseQueryInfo(lastChunk);
        } else if (this.queryParsingState == 7) {
            this.finishInfo();
        }
        if (this.queryParsingState == 8) {
            this.sectionDone = lastChunk;
            if (this.sectionDone) {
                this.cleanupQueryStates();
            }
        }
    }

    private byte transitionToNextToken(boolean lastChunk) {
        int newState;
        int endNextToken = ByteBufJsonHelper.findNextChar(this.responseContent, ':');
        if (endNextToken < 0 && !lastChunk) {
            return this.queryParsingState;
        }
        if (endNextToken < 0 && lastChunk && this.queryParsingState >= 5) {
            return 7;
        }
        ByteBuf peekSlice = this.responseContent.readSlice(endNextToken + 1);
        String peek = peekSlice.toString(CHARSET);
        if (peek.contains("\"signature\":")) {
            newState = 1;
        } else if (peek.endsWith("\"results\":")) {
            newState = 29;
        } else if (peek.endsWith("\"status\":")) {
            newState = 5;
        } else if (peek.endsWith("\"errors\":")) {
            newState = 3;
        } else if (peek.endsWith("\"warnings\":")) {
            newState = 4;
        } else if (peek.endsWith("\"metrics\":")) {
            newState = 6;
        } else {
            if (lastChunk) {
                IllegalStateException e = new IllegalStateException("Error parsing query response (in TRANSITION) at \"" + peek + "\", enable trace to see response content");
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(this.responseContent.toString(CHARSET), e);
                }
                throw e;
            }
            return this.queryParsingState;
        }
        this.sectionDone = false;
        return (byte)newState;
    }

    private void decideBetweenRawAndObjects(boolean lastChunk) {
        this.responseContent.markReaderIndex();
        int openArrayPos = ByteBufJsonHelper.findNextChar(this.responseContent, '[');
        if (openArrayPos <= -1) {
            this.responseContent.resetReaderIndex();
            if (lastChunk) {
                throw new IllegalStateException("Unable to decide between raw and objects with content " + this.responseContent.toString(CHARSET));
            }
            return;
        }
        this.responseContent.skipBytes(openArrayPos + 1);
        int spaceToSkip = this.responseContent.forEachByte(new WhitespaceSkipper());
        if (spaceToSkip <= -1) {
            this.responseContent.resetReaderIndex();
            return;
        }
        this.responseContent.readerIndex(spaceToSkip);
        if (this.responseContent.isReadable()) {
            byte first = this.responseContent.getByte(this.responseContent.readerIndex());
            if (first == 123) {
                this.queryParsingState = (byte)2;
            } else if (first == 93) {
                this.sectionDone();
                this.queryParsingState = this.transitionToNextToken(lastChunk);
            } else {
                this.queryParsingState = (byte)20;
            }
        } else {
            this.responseContent.resetReaderIndex();
        }
    }

    private void sectionDone() {
        this.sectionDone = true;
        this.responseContent.discardReadBytes();
    }

    private void parseQuerySignature(boolean lastChunk) {
        ByteBufProcessor processor = null;
        int openPos = this.responseContent.forEachByte(new WhitespaceSkipper()) - this.responseContent.readerIndex();
        if (openPos < 0) {
            return;
        }
        char openChar = (char)this.responseContent.getByte(this.responseContent.readerIndex() + openPos);
        if (openChar == '{') {
            processor = new ClosingPositionBufProcessor('{', '}', true);
        } else if (openChar == '[') {
            processor = new ClosingPositionBufProcessor('[', ']', true);
        } else if (openChar == '\"') {
            processor = new StringClosingPositionBufProcessor();
        }
        int closePos = processor != null ? this.responseContent.forEachByte(processor) - this.responseContent.readerIndex() : ByteBufJsonHelper.findNextChar(this.responseContent, ',') - 1;
        if (closePos <= 0) {
            return;
        }
        this.responseContent.skipBytes(openPos);
        int length = closePos - openPos + 1;
        ByteBuf signature = this.responseContent.readSlice(length);
        this.querySignatureObservable.onNext(signature.copy());
        this.sectionDone();
        this.queryParsingState = this.transitionToNextToken(lastChunk);
    }

    private void parseQueryRows(boolean lastChunk) {
        while (true) {
            int openBracketPos;
            if (this.isEmptySection(openBracketPos = ByteBufJsonHelper.findNextChar(this.responseContent, '{')) || lastChunk && openBracketPos < 0) {
                this.sectionDone();
                this.queryParsingState = this.transitionToNextToken(lastChunk);
                break;
            }
            int closeBracketPos = ByteBufJsonHelper.findSectionClosingPosition(this.responseContent, '{', '}');
            if (closeBracketPos == -1) break;
            int length = closeBracketPos - openBracketPos - this.responseContent.readerIndex() + 1;
            this.responseContent.skipBytes(openBracketPos);
            ByteBuf resultSlice = this.responseContent.readSlice(length);
            this.queryRowObservable.onNext(resultSlice.copy());
            this.responseContent.discardSomeReadBytes();
        }
    }

    private void parseQueryRowsRaw(boolean lastChunk) {
        while (this.responseContent.isReadable()) {
            int splitPos = ByteBufJsonHelper.findSplitPosition(this.responseContent, ',');
            int arrayEndPos = ByteBufJsonHelper.findSplitPosition(this.responseContent, ']');
            boolean doSectionDone = false;
            if (splitPos == -1 && arrayEndPos == -1) break;
            if (arrayEndPos > 0 && (arrayEndPos < splitPos || splitPos == -1)) {
                splitPos = arrayEndPos;
                doSectionDone = true;
            }
            int length = splitPos - this.responseContent.readerIndex();
            ByteBuf resultSlice = this.responseContent.readSlice(length);
            this.queryRowObservable.onNext(resultSlice.copy());
            this.responseContent.skipBytes(1);
            this.responseContent.discardReadBytes();
            if (!doSectionDone) continue;
            this.sectionDone();
            this.queryParsingState = this.transitionToNextToken(lastChunk);
            break;
        }
    }

    private void parseQueryError(boolean lastChunk) {
        while (true) {
            int openBracketPos;
            if (this.isEmptySection(openBracketPos = ByteBufJsonHelper.findNextChar(this.responseContent, '{')) || lastChunk && openBracketPos < 0) {
                this.sectionDone();
                this.queryParsingState = this.transitionToNextToken(lastChunk);
                break;
            }
            int closeBracketPos = ByteBufJsonHelper.findSectionClosingPosition(this.responseContent, '{', '}');
            if (closeBracketPos == -1) break;
            int length = closeBracketPos - openBracketPos - this.responseContent.readerIndex() + 1;
            this.responseContent.skipBytes(openBracketPos);
            ByteBuf resultSlice = this.responseContent.readSlice(length);
            this.queryErrorObservable.onNext(resultSlice.copy());
        }
    }

    private void parseQueryStatus(boolean lastChunk) {
        this.querySignatureObservable.onCompleted();
        this.queryRowObservable.onCompleted();
        this.queryErrorObservable.onCompleted();
        this.responseContent.markReaderIndex();
        this.responseContent.skipBytes(ByteBufJsonHelper.findNextChar(this.responseContent, '\"') + 1);
        int endStatus = ByteBufJsonHelper.findNextChar(this.responseContent, '\"');
        if (endStatus <= -1) {
            this.responseContent.resetReaderIndex();
            return;
        }
        ByteBuf resultSlice = this.responseContent.readSlice(endStatus);
        this.queryStatusObservable.onNext(resultSlice.toString(CHARSET));
        this.queryStatusObservable.onCompleted();
        this.sectionDone();
        this.queryParsingState = this.transitionToNextToken(lastChunk);
    }

    private void parseQueryInfo(boolean last) {
        int openBracketPos = ByteBufJsonHelper.findNextChar(this.responseContent, '{');
        int closeBracketPos = ByteBufJsonHelper.findSectionClosingPosition(this.responseContent, '{', '}');
        if (closeBracketPos == -1) {
            if (last) {
                throw new IllegalStateException("Could not find metrics closing in last chunk");
            }
            return;
        }
        int from = this.responseContent.readerIndex() + openBracketPos;
        int to = closeBracketPos - openBracketPos - this.responseContent.readerIndex() + 1;
        this.queryInfoObservable.onNext(this.responseContent.slice(from, to).copy());
        this.responseContent.readerIndex(to + openBracketPos);
        this.finishInfo();
    }

    private void finishInfo() {
        this.queryInfoObservable.onCompleted();
        this.sectionDone();
        this.queryParsingState = (byte)8;
    }

    private void cleanupQueryStates() {
        this.finishedDecoding();
        this.queryInfoObservable = null;
        this.queryRowObservable = null;
        this.queryErrorObservable = null;
        this.queryStatusObservable = null;
        this.querySignatureObservable = null;
        this.queryParsingState = 0;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.queryRowObservable != null) {
            this.queryRowObservable.onCompleted();
        }
        if (this.queryInfoObservable != null) {
            this.queryInfoObservable.onCompleted();
        }
        if (this.queryErrorObservable != null) {
            this.queryErrorObservable.onCompleted();
        }
        if (this.queryStatusObservable != null) {
            this.queryStatusObservable.onCompleted();
        }
        if (this.querySignatureObservable != null) {
            this.querySignatureObservable.onCompleted();
        }
        this.cleanupQueryStates();
        if (this.responseContent != null && this.responseContent.refCnt() > 0) {
            this.responseContent.release();
        }
        super.handlerRemoved(ctx);
    }

    @Override
    protected CouchbaseRequest createKeepAliveRequest() {
        return new KeepAliveRequest();
    }

    @Override
    protected ServiceType serviceType() {
        return ServiceType.QUERY;
    }

    public int getQueryParsingState() {
        return this.queryParsingState;
    }

    protected static class KeepAliveResponse
    extends AbstractCouchbaseResponse {
        protected KeepAliveResponse(ResponseStatus status, CouchbaseRequest request) {
            super(status, request);
        }
    }

    protected static class KeepAliveRequest
    extends AbstractCouchbaseRequest
    implements QueryRequest,
    KeepAlive {
        protected KeepAliveRequest() {
            super(null, null);
        }
    }
}

