/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.bucket;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.config.BucketConfigRequest;
import com.couchbase.client.core.message.config.BucketConfigResponse;
import com.couchbase.client.core.message.config.GetDesignDocumentsRequest;
import com.couchbase.client.core.message.config.GetDesignDocumentsResponse;
import com.couchbase.client.core.message.view.GetDesignDocumentRequest;
import com.couchbase.client.core.message.view.GetDesignDocumentResponse;
import com.couchbase.client.core.message.view.RemoveDesignDocumentRequest;
import com.couchbase.client.core.message.view.RemoveDesignDocumentResponse;
import com.couchbase.client.core.message.view.UpsertDesignDocumentRequest;
import com.couchbase.client.core.message.view.UpsertDesignDocumentResponse;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.bucket.AsyncBucketManager;
import com.couchbase.client.java.bucket.BucketFlusher;
import com.couchbase.client.java.bucket.BucketInfo;
import com.couchbase.client.java.bucket.DefaultBucketInfo;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.CannotRetryException;
import com.couchbase.client.java.error.DesignDocumentAlreadyExistsException;
import com.couchbase.client.java.error.DesignDocumentException;
import com.couchbase.client.java.error.IndexesNotReadyException;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.query.AsyncN1qlQueryResult;
import com.couchbase.client.java.query.AsyncN1qlQueryRow;
import com.couchbase.client.java.query.Index;
import com.couchbase.client.java.query.N1qlParams;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import com.couchbase.client.java.query.core.N1qlQueryExecutor;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.Sort;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.query.dsl.path.index.IndexType;
import com.couchbase.client.java.query.dsl.path.index.UsingWithPath;
import com.couchbase.client.java.query.dsl.path.index.WherePath;
import com.couchbase.client.java.query.util.IndexInfo;
import com.couchbase.client.java.util.retry.RetryBuilder;
import com.couchbase.client.java.view.DesignDocument;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import rx.Notification;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

public class DefaultAsyncBucketManager
implements AsyncBucketManager {
    public static final String INDEX_WATCH_LOG_NAME = "indexWatch";
    private static final CouchbaseLogger INDEX_WATCH_LOG = CouchbaseLoggerFactory.getInstance("indexWatch");
    private static final int INDEX_WATCH_MAX_ATTEMPTS = 0x7FFFFFFA;
    private static final Delay INDEX_WATCH_DELAY = Delay.linear(TimeUnit.MILLISECONDS, 1000L, 50L, 500L);
    private final ClusterFacade core;
    private final String bucket;
    private final String password;
    private final N1qlQueryExecutor queryExecutor;
    private static Func1<AsyncN1qlQueryRow, IndexInfo> ROW_VALUE_TO_INDEXINFO = new Func1<AsyncN1qlQueryRow, IndexInfo>(){

        @Override
        public IndexInfo call(AsyncN1qlQueryRow asyncN1qlQueryRow) {
            return new IndexInfo(asyncN1qlQueryRow.value());
        }
    };

    DefaultAsyncBucketManager(String bucket, String password, ClusterFacade core) {
        this.bucket = bucket;
        this.password = password;
        this.core = core;
        this.queryExecutor = new N1qlQueryExecutor(core, bucket, password);
    }

    public static DefaultAsyncBucketManager create(String bucket, String password, ClusterFacade core) {
        return new DefaultAsyncBucketManager(bucket, password, core);
    }

    @Override
    public Observable<BucketInfo> info() {
        return Observable.defer(new Func0<Observable<BucketConfigResponse>>(){

            @Override
            public Observable<BucketConfigResponse> call() {
                return DefaultAsyncBucketManager.this.core.send(new BucketConfigRequest("/pools/default/buckets/", null, DefaultAsyncBucketManager.this.bucket, DefaultAsyncBucketManager.this.password));
            }
        }).map(new Func1<BucketConfigResponse, BucketInfo>(){

            @Override
            public BucketInfo call(BucketConfigResponse response) {
                try {
                    return DefaultBucketInfo.create(CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.stringToJsonObject(response.config()));
                }
                catch (Exception ex) {
                    throw new TranscodingException("Could not decode bucket info.", ex);
                }
            }
        });
    }

    @Override
    public Observable<Boolean> flush() {
        return BucketFlusher.flush(this.core, this.bucket, this.password);
    }

    @Override
    public Observable<DesignDocument> getDesignDocuments() {
        return this.getDesignDocuments(false);
    }

    @Override
    public Observable<DesignDocument> getDesignDocuments(final boolean development) {
        return Observable.defer(new Func0<Observable<GetDesignDocumentsResponse>>(){

            @Override
            public Observable<GetDesignDocumentsResponse> call() {
                return DefaultAsyncBucketManager.this.core.send(new GetDesignDocumentsRequest(DefaultAsyncBucketManager.this.bucket, DefaultAsyncBucketManager.this.password));
            }
        }).flatMap(new Func1<GetDesignDocumentsResponse, Observable<DesignDocument>>(){

            @Override
            public Observable<DesignDocument> call(GetDesignDocumentsResponse response) {
                JsonObject converted;
                try {
                    converted = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.stringToJsonObject(response.content());
                }
                catch (Exception e) {
                    throw new TranscodingException("Could not decode design document.", e);
                }
                JsonArray rows = converted.getArray("rows");
                ArrayList<DesignDocument> docs = new ArrayList<DesignDocument>();
                for (Object doc : rows) {
                    JsonObject docObj = ((JsonObject)doc).getObject("doc");
                    String id = docObj.getObject("meta").getString("id");
                    String[] idSplit = id.split("/");
                    String fullName = idSplit[1];
                    boolean isDev = fullName.startsWith("dev_");
                    if (isDev != development) continue;
                    String name = fullName.replace("dev_", "");
                    docs.add(DesignDocument.from(name, docObj.getObject("json")));
                }
                return Observable.from(docs);
            }
        });
    }

    @Override
    public Observable<DesignDocument> getDesignDocument(String name) {
        return this.getDesignDocument(name, false);
    }

    @Override
    public Observable<DesignDocument> getDesignDocument(final String name, final boolean development) {
        return Observable.defer(new Func0<Observable<GetDesignDocumentResponse>>(){

            @Override
            public Observable<GetDesignDocumentResponse> call() {
                return DefaultAsyncBucketManager.this.core.send(new GetDesignDocumentRequest(name, development, DefaultAsyncBucketManager.this.bucket, DefaultAsyncBucketManager.this.password));
            }
        }).filter(new Func1<GetDesignDocumentResponse, Boolean>(){

            @Override
            public Boolean call(GetDesignDocumentResponse response) {
                boolean success = response.status().isSuccess();
                if (!success && response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                return success;
            }
        }).map(new Func1<GetDesignDocumentResponse, DesignDocument>(){

            @Override
            public DesignDocument call(GetDesignDocumentResponse response) {
                JsonObject converted;
                try {
                    converted = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.stringToJsonObject(response.content().toString(CharsetUtil.UTF_8));
                }
                catch (Exception e) {
                    throw new TranscodingException("Could not decode design document.", e);
                }
                finally {
                    if (response.content() != null && response.content().refCnt() > 0) {
                        response.content().release();
                    }
                }
                return DesignDocument.from(response.name(), converted);
            }
        });
    }

    @Override
    public Observable<DesignDocument> insertDesignDocument(DesignDocument designDocument) {
        return this.insertDesignDocument(designDocument, false);
    }

    @Override
    public Observable<DesignDocument> insertDesignDocument(final DesignDocument designDocument, final boolean development) {
        return this.getDesignDocument(designDocument.name(), development).isEmpty().flatMap(new Func1<Boolean, Observable<DesignDocument>>(){

            @Override
            public Observable<DesignDocument> call(Boolean doesNotExist) {
                if (doesNotExist.booleanValue()) {
                    return DefaultAsyncBucketManager.this.upsertDesignDocument(designDocument, development);
                }
                return Observable.error(new DesignDocumentAlreadyExistsException());
            }
        });
    }

    @Override
    public Observable<DesignDocument> upsertDesignDocument(DesignDocument designDocument) {
        return this.upsertDesignDocument(designDocument, false);
    }

    @Override
    public Observable<DesignDocument> upsertDesignDocument(final DesignDocument designDocument, final boolean development) {
        String body;
        try {
            body = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER.jsonObjectToString(designDocument.toJsonObject());
        }
        catch (Exception e) {
            throw new TranscodingException("Could not encode design document: ", e);
        }
        final String b = body;
        return Observable.defer(new Func0<Observable<UpsertDesignDocumentResponse>>(){

            @Override
            public Observable<UpsertDesignDocumentResponse> call() {
                return DefaultAsyncBucketManager.this.core.send(new UpsertDesignDocumentRequest(designDocument.name(), b, development, DefaultAsyncBucketManager.this.bucket, DefaultAsyncBucketManager.this.password));
            }
        }).map(new Func1<UpsertDesignDocumentResponse, DesignDocument>(){

            @Override
            public DesignDocument call(UpsertDesignDocumentResponse response) {
                try {
                    if (!response.status().isSuccess()) {
                        String msg = response.content().toString(CharsetUtil.UTF_8);
                        throw new DesignDocumentException("Could not store DesignDocument: " + msg);
                    }
                }
                finally {
                    if (response.content() != null && response.content().refCnt() > 0) {
                        response.content().release();
                    }
                }
                return designDocument;
            }
        });
    }

    @Override
    public Observable<Boolean> removeDesignDocument(String name) {
        return this.removeDesignDocument(name, false);
    }

    @Override
    public Observable<Boolean> removeDesignDocument(final String name, final boolean development) {
        return Observable.defer(new Func0<Observable<RemoveDesignDocumentResponse>>(){

            @Override
            public Observable<RemoveDesignDocumentResponse> call() {
                return DefaultAsyncBucketManager.this.core.send(new RemoveDesignDocumentRequest(name, development, DefaultAsyncBucketManager.this.bucket, DefaultAsyncBucketManager.this.password));
            }
        }).map(new Func1<RemoveDesignDocumentResponse, Boolean>(){

            @Override
            public Boolean call(RemoveDesignDocumentResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                return response.status().isSuccess();
            }
        });
    }

    @Override
    public Observable<DesignDocument> publishDesignDocument(String name) {
        return this.publishDesignDocument(name, false);
    }

    @Override
    public Observable<DesignDocument> publishDesignDocument(final String name, final boolean overwrite) {
        return this.getDesignDocument(name, false).isEmpty().flatMap(new Func1<Boolean, Observable<DesignDocument>>(){

            @Override
            public Observable<DesignDocument> call(Boolean doesNotExist) {
                if (!doesNotExist.booleanValue() && !overwrite) {
                    return Observable.error(new DesignDocumentAlreadyExistsException("Document exists in production and not overwriting."));
                }
                return DefaultAsyncBucketManager.this.getDesignDocument(name, true);
            }
        }).flatMap(new Func1<DesignDocument, Observable<DesignDocument>>(){

            @Override
            public Observable<DesignDocument> call(DesignDocument designDocument) {
                return DefaultAsyncBucketManager.this.upsertDesignDocument(designDocument);
            }
        });
    }

    private static <T> Func1<List<JsonObject>, Observable<T>> errorsToThrowable(final String messagePrefix) {
        return new Func1<List<JsonObject>, Observable<T>>(){

            @Override
            public Observable<T> call(List<JsonObject> errors) {
                return Observable.error(new CouchbaseException(messagePrefix + errors));
            }
        };
    }

    @Override
    public Observable<IndexInfo> listIndexes() {
        LimitPath listIndexes = Select.select("idx.*").from(Expression.x("system:indexes").as("idx")).where(Expression.x("keyspace_id").eq(Expression.s(this.bucket))).orderBy(Sort.desc("is_primary"), Sort.asc("name"));
        final Func1 errorHandler = DefaultAsyncBucketManager.errorsToThrowable("Error while listing indexes: ");
        return this.queryExecutor.execute(N1qlQuery.simple(listIndexes, N1qlParams.build().consistency(ScanConsistency.REQUEST_PLUS))).flatMap(new Func1<AsyncN1qlQueryResult, Observable<AsyncN1qlQueryRow>>(){

            @Override
            public Observable<AsyncN1qlQueryRow> call(final AsyncN1qlQueryResult aqr) {
                return aqr.finalSuccess().flatMap(new Func1<Boolean, Observable<AsyncN1qlQueryRow>>(){

                    @Override
                    public Observable<AsyncN1qlQueryRow> call(Boolean success) {
                        if (success.booleanValue()) {
                            return aqr.rows();
                        }
                        return aqr.errors().toList().flatMap(errorHandler);
                    }
                });
            }
        }).map(ROW_VALUE_TO_INDEXINFO);
    }

    @Override
    public Observable<Boolean> createPrimaryIndex(final boolean ignoreIfExist, boolean defer) {
        UsingWithPath usingWithPath = Index.createPrimaryIndex().on(this.bucket);
        Statement createIndex = defer ? usingWithPath.withDefer() : usingWithPath;
        return this.queryExecutor.execute(N1qlQuery.simple(createIndex)).flatMap(new Func1<AsyncN1qlQueryResult, Observable<Boolean>>(){

            @Override
            public Observable<Boolean> call(final AsyncN1qlQueryResult aqr) {
                return aqr.finalSuccess().flatMap(new Func1<Boolean, Observable<Boolean>>(){

                    @Override
                    public Observable<Boolean> call(Boolean success) {
                        if (success.booleanValue()) {
                            return Observable.just(true);
                        }
                        return aqr.errors().toList().flatMap(new Func1<List<JsonObject>, Observable<Boolean>>(){

                            @Override
                            public Observable<Boolean> call(List<JsonObject> errors) {
                                if (ignoreIfExist && errors.size() == 1 && errors.get(0).getString("msg").contains("already exist")) {
                                    return Observable.just(false);
                                }
                                return Observable.error(new CouchbaseException("Error creating primary index: " + errors));
                            }
                        });
                    }
                });
            }
        });
    }

    private static Expression expressionOrIdentifier(Object o) {
        if (o instanceof Expression) {
            return (Expression)o;
        }
        if (o instanceof String) {
            return Expression.i((String)o);
        }
        throw new IllegalArgumentException("Fields for index must be either an Expression or a String identifier");
    }

    @Override
    public Observable<Boolean> createIndex(String indexName, boolean ignoreIfExist, boolean defer, Object ... fields) {
        if (fields == null || fields.length < 1) {
            throw new IllegalArgumentException("At least one field is required for secondary index");
        }
        Expression firstExpression = DefaultAsyncBucketManager.expressionOrIdentifier(fields[0]);
        Expression[] otherExpressions = new Expression[fields.length - 1];
        for (int i = 1; i < fields.length; ++i) {
            otherExpressions[i - 1] = DefaultAsyncBucketManager.expressionOrIdentifier(fields[i]);
        }
        WherePath usingWithPath = Index.createIndex(indexName).on(this.bucket, firstExpression, otherExpressions);
        Statement createIndex = defer ? usingWithPath.withDefer() : usingWithPath;
        return this.queryExecutor.execute(N1qlQuery.simple(createIndex)).compose(DefaultAsyncBucketManager.checkIndexCreation(ignoreIfExist, "Error creating secondary index " + indexName));
    }

    @Override
    public Observable<Boolean> dropPrimaryIndex(boolean ignoreIfNotExist) {
        return this.drop(ignoreIfNotExist, Index.dropPrimaryIndex(this.bucket).using(IndexType.GSI), "Error dropping primary index: ");
    }

    @Override
    public Observable<Boolean> dropIndex(String name, boolean ignoreIfNotExist) {
        return this.drop(ignoreIfNotExist, Index.dropIndex(this.bucket, name).using(IndexType.GSI), "Error dropping index \"" + name + "\"");
    }

    private Observable<Boolean> drop(final boolean ignoreIfNotExist, Statement dropIndex, final String errorPrefix) {
        return this.queryExecutor.execute(N1qlQuery.simple(dropIndex)).flatMap(new Func1<AsyncN1qlQueryResult, Observable<Boolean>>(){

            @Override
            public Observable<Boolean> call(final AsyncN1qlQueryResult aqr) {
                return aqr.finalSuccess().flatMap(new Func1<Boolean, Observable<Boolean>>(){

                    @Override
                    public Observable<Boolean> call(Boolean success) {
                        if (success.booleanValue()) {
                            return Observable.just(true);
                        }
                        return aqr.errors().toList().flatMap(new Func1<List<JsonObject>, Observable<Boolean>>(){

                            @Override
                            public Observable<Boolean> call(List<JsonObject> errors) {
                                if (ignoreIfNotExist && errors.size() == 1 && errors.get(0).getString("msg").contains("not found")) {
                                    return Observable.just(false);
                                }
                                return Observable.error(new CouchbaseException(errorPrefix + errors));
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public Observable<List<String>> buildDeferredIndexes() {
        final Func1 errorHandler = DefaultAsyncBucketManager.errorsToThrowable("Error while triggering index build: ");
        return this.listIndexes().filter(new Func1<IndexInfo, Boolean>(){

            @Override
            public Boolean call(IndexInfo indexInfo) {
                return indexInfo.state().equals("pending");
            }
        }).map(new Func1<IndexInfo, String>(){

            @Override
            public String call(IndexInfo indexInfo) {
                return indexInfo.name();
            }
        }).toList().flatMap(new Func1<List<String>, Observable<List<String>>>(){

            @Override
            public Observable<List<String>> call(final List<String> pendingIndexes) {
                if (pendingIndexes.isEmpty()) {
                    return Observable.just(pendingIndexes);
                }
                Statement buildStatement = Index.buildIndex().on(DefaultAsyncBucketManager.this.bucket).indexes(pendingIndexes).using(IndexType.GSI);
                return DefaultAsyncBucketManager.this.queryExecutor.execute(N1qlQuery.simple(buildStatement)).flatMap(new Func1<AsyncN1qlQueryResult, Observable<List<String>>>(){

                    @Override
                    public Observable<List<String>> call(final AsyncN1qlQueryResult aqr) {
                        return aqr.finalSuccess().flatMap(new Func1<Boolean, Observable<List<String>>>(){

                            @Override
                            public Observable<List<String>> call(Boolean success) {
                                if (success.booleanValue()) {
                                    return Observable.just(pendingIndexes);
                                }
                                return aqr.errors().toList().flatMap(errorHandler);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public Observable<IndexInfo> watchIndex(final String indexName, long watchTimeout, TimeUnit watchTimeUnit) {
        return this.listIndexes().flatMap(new Func1<IndexInfo, Observable<IndexInfo>>(){

            @Override
            public Observable<IndexInfo> call(IndexInfo i) {
                if (!indexName.equals(i.name())) {
                    return Observable.empty();
                }
                if (!"online".equals(i.state())) {
                    return Observable.error(new IndexesNotReadyException("Index not ready: " + i.name()));
                }
                return Observable.just(i);
            }
        }).doOnEach((Action1<Notification<IndexInfo>>)new Action1<Notification<? super IndexInfo>>(){

            @Override
            public void call(Notification<? super IndexInfo> notification) {
                if (INDEX_WATCH_LOG.isDebugEnabled()) {
                    Throwable e;
                    if (notification.isOnNext()) {
                        IndexInfo info = notification.getValue();
                        String indexShortInfo = indexName + "(" + info.state() + ")";
                        INDEX_WATCH_LOG.debug("Index ready: " + indexShortInfo);
                    } else if (notification.isOnError() && (e = notification.getThrowable()) instanceof IndexesNotReadyException) {
                        INDEX_WATCH_LOG.debug("Will retry: " + e.getMessage());
                    }
                }
            }
        }).retryWhen(RetryBuilder.anyOf(IndexesNotReadyException.class).delay(INDEX_WATCH_DELAY).max(0x7FFFFFFA).build()).compose(DefaultAsyncBucketManager.safeAbort(watchTimeout, watchTimeUnit, null));
    }

    @Override
    public Observable<IndexInfo> watchIndexes(List<String> watchList, boolean watchPrimary, final long watchTimeout, final TimeUnit watchTimeUnit) {
        HashSet<String> watchSet = new HashSet<String>(watchList);
        if (watchPrimary) {
            watchSet.add("#primary");
        }
        return Observable.from(watchSet).flatMap(new Func1<String, Observable<IndexInfo>>(){

            @Override
            public Observable<IndexInfo> call(String s) {
                return DefaultAsyncBucketManager.this.watchIndex(s, watchTimeout, watchTimeUnit);
            }
        }).compose(DefaultAsyncBucketManager.safeAbort(watchTimeout, watchTimeUnit, null));
    }

    private static Observable.Transformer<IndexInfo, IndexInfo> safeAbort(final long watchTimeout, final TimeUnit watchTimeUnit, final String indexName) {
        return new Observable.Transformer<IndexInfo, IndexInfo>(){

            @Override
            public Observable<IndexInfo> call(Observable<IndexInfo> source) {
                return source.timeout(watchTimeout, watchTimeUnit).onErrorResumeNext(new Func1<Throwable, Observable<IndexInfo>>(){

                    @Override
                    public Observable<IndexInfo> call(Throwable t) {
                        if (t instanceof TimeoutException) {
                            if (indexName == null) {
                                INDEX_WATCH_LOG.debug("Watched indexes were not all online after the given {} {}", (Object)watchTimeout, (Object)watchTimeUnit);
                            } else {
                                INDEX_WATCH_LOG.debug("Index {} was not online after the given {} {}", new Object[]{indexName, watchTimeout, watchTimeUnit});
                            }
                            return Observable.empty();
                        }
                        if (t instanceof CannotRetryException && t.getCause() instanceof IndexesNotReadyException) {
                            INDEX_WATCH_LOG.debug("{} after {} attempts", (Object)0x7FFFFFFA, (Object)t.getCause().getMessage());
                            return Observable.empty();
                        }
                        return Observable.error(t);
                    }
                });
            }
        };
    }

    private static Observable.Transformer<AsyncN1qlQueryResult, Boolean> checkIndexCreation(final boolean ignoreIfExist, final String prefixMsg) {
        return new Observable.Transformer<AsyncN1qlQueryResult, Boolean>(){

            @Override
            public Observable<Boolean> call(Observable<AsyncN1qlQueryResult> sourceObservable) {
                return sourceObservable.flatMap(new Func1<AsyncN1qlQueryResult, Observable<Boolean>>(){

                    @Override
                    public Observable<Boolean> call(final AsyncN1qlQueryResult aqr) {
                        return aqr.finalSuccess().flatMap(new Func1<Boolean, Observable<Boolean>>(){

                            @Override
                            public Observable<Boolean> call(Boolean success) {
                                if (success.booleanValue()) {
                                    return Observable.just(true);
                                }
                                return aqr.errors().toList().flatMap(new Func1<List<JsonObject>, Observable<Boolean>>(){

                                    @Override
                                    public Observable<Boolean> call(List<JsonObject> errors) {
                                        if (ignoreIfExist && errors.size() == 1 && errors.get(0).getString("msg").contains("already exist")) {
                                            return Observable.just(false);
                                        }
                                        return Observable.error(new CouchbaseException(prefixMsg + ": " + errors));
                                    }
                                });
                            }
                        });
                    }
                });
            }
        };
    }
}

