/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.N1qlParams;
import com.couchbase.client.java.query.ParameterizedN1qlQuery;
import com.couchbase.client.java.query.SerializableStatement;
import com.couchbase.client.java.query.SimpleN1qlQuery;
import com.couchbase.client.java.query.Statement;
import java.io.Serializable;

public abstract class N1qlQuery
implements Serializable {
    private static final long serialVersionUID = 3758119606237959729L;

    public abstract Statement statement();

    public abstract N1qlParams params();

    public abstract JsonObject n1ql();

    public static SimpleN1qlQuery simple(Statement statement) {
        return new SimpleN1qlQuery(statement, null);
    }

    public static SimpleN1qlQuery simple(String statement) {
        return N1qlQuery.simple(new RawStatement(statement));
    }

    public static SimpleN1qlQuery simple(Statement statement, N1qlParams params) {
        return new SimpleN1qlQuery(statement, params);
    }

    public static SimpleN1qlQuery simple(String statement, N1qlParams params) {
        return N1qlQuery.simple(new RawStatement(statement), params);
    }

    public static ParameterizedN1qlQuery parameterized(Statement statement, JsonArray positionalParams) {
        return new ParameterizedN1qlQuery(statement, positionalParams, null);
    }

    public static ParameterizedN1qlQuery parameterized(Statement statement, JsonObject namedParams) {
        return new ParameterizedN1qlQuery(statement, namedParams, null);
    }

    public static ParameterizedN1qlQuery parameterized(Statement statement, JsonArray positionalParams, N1qlParams params) {
        return new ParameterizedN1qlQuery(statement, positionalParams, params);
    }

    public static ParameterizedN1qlQuery parameterized(Statement statement, JsonObject namedParams, N1qlParams params) {
        return new ParameterizedN1qlQuery(statement, namedParams, params);
    }

    public static ParameterizedN1qlQuery parameterized(String statement, JsonArray positionalParams) {
        return new ParameterizedN1qlQuery((Statement)new RawStatement(statement), positionalParams, null);
    }

    public static ParameterizedN1qlQuery parameterized(String statement, JsonObject namedParams) {
        return new ParameterizedN1qlQuery((Statement)new RawStatement(statement), namedParams, null);
    }

    public static ParameterizedN1qlQuery parameterized(String statement, JsonArray positionalParams, N1qlParams params) {
        return new ParameterizedN1qlQuery((Statement)new RawStatement(statement), positionalParams, params);
    }

    public static ParameterizedN1qlQuery parameterized(String statement, JsonObject namedParams, N1qlParams params) {
        return new ParameterizedN1qlQuery((Statement)new RawStatement(statement), namedParams, params);
    }

    static class RawStatement
    implements SerializableStatement {
        private static final long serialVersionUID = 107907431113912054L;
        private final String rawStatement;

        public RawStatement(String rawStatement) {
            this.rawStatement = rawStatement;
        }

        public String toString() {
            return this.rawStatement;
        }
    }
}

