/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.process.ImageProcessor;
import java.awt.Polygon;

public class Wand {
    public static final int FOUR_CONNECTED = 4;
    public static final int EIGHT_CONNECTED = 8;
    public static final int LEGACY_MODE = 1;
    public int npoints;
    private int maxPoints = 1000;
    public int[] xpoints = new int[this.maxPoints];
    public int[] ypoints = new int[this.maxPoints];
    private static final int THRESHOLDED_MODE = 256;
    private ImageProcessor ip;
    private byte[] bpixels;
    private int[] cpixels;
    private short[] spixels;
    private float[] fpixels;
    private int width;
    private int height;
    private float lowerThreshold;
    private float upperThreshold;
    private int xmin;
    private boolean exactPixelValue;
    private static boolean allPoints;

    public Wand(ImageProcessor ip) {
        this.ip = ip;
        Object pixels = ip.getPixels();
        if (pixels instanceof byte[]) {
            this.bpixels = (byte[])pixels;
        } else if (pixels instanceof int[]) {
            this.cpixels = (int[])pixels;
        } else if (pixels instanceof short[]) {
            this.spixels = (short[])pixels;
        } else if (pixels instanceof float[]) {
            this.fpixels = (float[])pixels;
        }
        this.width = ip.getWidth();
        this.height = ip.getHeight();
    }

    public void autoOutline(int startX, int startY, double lower, double upper, int mode) {
        this.lowerThreshold = (float)lower;
        this.upperThreshold = (float)upper;
        this.autoOutline(startX, startY, 0.0, mode | 0x100);
    }

    public void autoOutline(int startX, int startY, double lower, double upper) {
        this.autoOutline(startX, startY, lower, upper, 257);
    }

    public void autoOutline(int startX, int startY, int lower, int upper) {
        this.autoOutline(startX, startY, lower, upper, 257);
    }

    public void autoOutline(int startX, int startY) {
        this.autoOutline(startX, startY, 0.0, 1);
    }

    public void autoOutline(int startX, int startY, double tolerance, int mode) {
        int seedX;
        int y;
        int x;
        boolean legacyMode;
        if (startX < 0 || startX >= this.width || startY < 0 || startY >= this.height) {
            return;
        }
        if (this.fpixels != null && Float.isNaN(this.getPixel(startX, startY))) {
            return;
        }
        this.exactPixelValue = tolerance == 0.0;
        boolean thresholdMode = (mode & 0x100) != 0;
        boolean bl = legacyMode = (mode & 1) != 0 && tolerance == 0.0;
        if (!thresholdMode) {
            double startValue = this.getPixel(startX, startY);
            this.lowerThreshold = (float)(startValue - tolerance);
            this.upperThreshold = (float)(startValue + tolerance);
        }
        if (this.inside(x = startX, y = startY)) {
            seedX = x;
            while (this.inside(++x, y)) {
            }
        } else {
            do {
                if (++x < this.width) continue;
                return;
            } while (!this.inside(x, y));
            seedX = x;
        }
        boolean fourConnected = legacyMode ? !thresholdMode && !this.isLine(x, y) : (mode & 4) != 0;
        boolean first = true;
        while (true) {
            boolean insideSelected = this.traceEdge(x, y, fourConnected);
            if (legacyMode) {
                return;
            }
            if (insideSelected) {
                Polygon poly;
                if (first) {
                    return;
                }
                if (this.xmin <= seedX && (poly = new Polygon(this.xpoints, this.ypoints, this.npoints)).contains(seedX, startY)) {
                    return;
                }
            }
            first = false;
            if (!this.inside(x, y)) {
                do {
                    if (++x <= this.width) continue;
                    throw new RuntimeException("Wand Malfunction");
                } while (!this.inside(x, y));
            }
            while (this.inside(++x, y)) {
            }
        }
    }

    private boolean traceEdge(int startX, int startY, boolean fourConnected) {
        int startDirection;
        this.npoints = 0;
        this.xmin = this.width;
        if (this.inside(startX, startY)) {
            startDirection = 1;
        } else {
            startDirection = 3;
            ++startY;
        }
        int x = startX;
        int y = startY;
        int direction = startDirection;
        do {
            int newDirection;
            if (fourConnected) {
                newDirection = direction;
                while (this.inside(x, y, newDirection) && ++newDirection < direction + 2) {
                }
                --newDirection;
            } else {
                newDirection = direction + 1;
                while (!this.inside(x, y, newDirection) && --newDirection >= direction) {
                }
            }
            if (allPoints || newDirection != direction) {
                this.addPoint(x, y);
            }
            switch (newDirection & 3) {
                case 0: {
                    ++x;
                    break;
                }
                case 1: {
                    --y;
                    break;
                }
                case 2: {
                    --x;
                    break;
                }
                case 3: {
                    ++y;
                }
            }
            direction = newDirection;
        } while (x != startX || y != startY || (direction & 3) != startDirection);
        if (allPoints || this.xpoints[0] != x) {
            this.addPoint(x, y);
        }
        return direction <= 0;
    }

    private void addPoint(int x, int y) {
        if (this.npoints == this.maxPoints) {
            int[] xtemp = new int[this.maxPoints * 2];
            int[] ytemp = new int[this.maxPoints * 2];
            System.arraycopy(this.xpoints, 0, xtemp, 0, this.maxPoints);
            System.arraycopy(this.ypoints, 0, ytemp, 0, this.maxPoints);
            this.xpoints = xtemp;
            this.ypoints = ytemp;
            this.maxPoints *= 2;
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        ++this.npoints;
        if (this.xmin > x) {
            this.xmin = x;
        }
    }

    private boolean inside(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return false;
        }
        float value = this.getPixel(x, y);
        return value >= this.lowerThreshold && value <= this.upperThreshold;
    }

    private boolean inside(int x, int y, int direction) {
        switch (direction & 3) {
            case 0: {
                return this.inside(x, y);
            }
            case 1: {
                return this.inside(x, y - 1);
            }
            case 2: {
                return this.inside(x - 1, y - 1);
            }
            case 3: {
                return this.inside(x - 1, y);
            }
        }
        return false;
    }

    private float getPixel(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return Float.NaN;
        }
        if (this.bpixels != null) {
            return this.bpixels[y * this.width + x] & 0xFF;
        }
        if (this.spixels != null) {
            return this.spixels[y * this.width + x] & 0xFFFF;
        }
        if (this.fpixels != null) {
            return this.fpixels[y * this.width + x];
        }
        if (this.exactPixelValue) {
            return this.cpixels[y * this.width + x] & 0xFFFFFF;
        }
        return this.ip.getPixelValue(x, y);
    }

    private boolean isLine(int xs, int ys) {
        int ymax;
        int ymin;
        int r = 5;
        int xmin = xs;
        int xmax = xs + 2 * r;
        if (xmax >= this.width) {
            xmax = this.width - 1;
        }
        if ((ymin = ys - r) < 0) {
            ymin = 0;
        }
        if ((ymax = ys + r) >= this.height) {
            ymax = this.height - 1;
        }
        int area = 0;
        int insideCount = 0;
        for (int x = xmin; x <= xmax; ++x) {
            for (int y = ymin; y <= ymax; ++y) {
                ++area;
                if (!this.inside(x, y)) continue;
                ++insideCount;
            }
        }
        if (IJ.debugMode) {
            IJ.log(((double)insideCount / (double)area < 0.25 ? "line " : "blob ") + insideCount + " " + area + " " + IJ.d2s((double)insideCount / (double)area));
        }
        return (double)insideCount / (double)area < 0.25;
    }

    public static void setAllPoints(boolean b) {
        allPoints = b;
    }

    public static boolean allPoints() {
        return allPoints;
    }
}

