/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.macro.Interpreter;
import ij.macro.Program;
import ij.plugin.frame.Editor;
import java.awt.MenuContainer;
import java.awt.PopupMenu;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class MacroRunner
implements Runnable {
    private String macro;
    private Program pgm;
    private int address;
    private String name;
    private Thread thread;
    private String argument;
    private Editor editor;

    public MacroRunner() {
    }

    public MacroRunner(String macro) {
        this(macro, (Editor)null);
    }

    public MacroRunner(String macro, Editor editor) {
        this.macro = macro;
        this.editor = editor;
        this.thread = new Thread((Runnable)this, "Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public MacroRunner(String macro, String argument) {
        this.macro = macro;
        this.argument = argument;
        this.thread = new Thread((Runnable)this, "Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public MacroRunner(File file) {
        int size = (int)file.length();
        if (size <= 0) {
            return;
        }
        try {
            String s;
            StringBuffer sb = new StringBuffer(5000);
            BufferedReader r = new BufferedReader(new FileReader(file));
            while ((s = r.readLine()) != null) {
                sb.append(s + "\n");
            }
            r.close();
            this.macro = new String(sb);
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return;
        }
        this.thread = new Thread((Runnable)this, "Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public MacroRunner(Program pgm, int address, String name) {
        this(pgm, address, name, (String)null);
    }

    public MacroRunner(Program pgm, int address, String name, String argument) {
        this.pgm = pgm;
        this.address = address;
        this.name = name;
        this.argument = argument;
        this.thread = new Thread((Runnable)this, name + "_Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public MacroRunner(Program pgm, int address, String name, Editor editor) {
        this.pgm = pgm;
        this.address = address;
        this.name = name;
        this.editor = editor;
        this.thread = new Thread((Runnable)this, name + "_Macro$");
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public void runShortcut(Program pgm, int address, String name) {
        this.pgm = pgm;
        this.address = address;
        this.name = name;
        if (pgm.queueCommands) {
            this.run();
        } else {
            this.thread = new Thread((Runnable)this, name + "_Macro$");
            this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
            this.thread.start();
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    public void run() {
        Interpreter interp = new Interpreter();
        interp.argument = this.argument;
        if (this.editor != null) {
            interp.setEditor(this.editor);
        }
        try {
            if (this.pgm == null) {
                interp.run(this.macro);
            } else {
                PopupMenu popup;
                if ("Popup Menu".equals(this.name) && (popup = Menus.getPopupMenu()) != null) {
                    ImagePlus imp = null;
                    MenuContainer parent = popup.getParent();
                    if (parent instanceof ImageCanvas) {
                        imp = ((ImageCanvas)parent).getImage();
                    }
                    if (imp != null) {
                        WindowManager.setTempCurrentImage(Thread.currentThread(), imp);
                    }
                }
                interp.runMacro(this.pgm, this.address, this.name);
            }
        }
        catch (Throwable e) {
            interp.abortMacro();
            IJ.showStatus("");
            IJ.showProgress(1.0);
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null) {
                imp.unlock();
            }
            String msg = e.getMessage();
            if (e instanceof RuntimeException && msg != null && e.getMessage().equals("Macro canceled")) {
                return;
            }
            IJ.handleException(e);
        }
    }
}

