/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Map;
import javax.lang.model.type.TypeKind;
import lombok.Lombok;
import lombok.javac.CompilerMessageSuppressor;
import lombok.javac.Javac;
import lombok.javac.JavacAST;
import lombok.javac.JavacNode;
import lombok.javac.JavacTreeMaker;
import lombok.javac.TreeMirrorMaker;

public class JavacResolution {
    private final Attr attr;
    private final CompilerMessageSuppressor messageSuppressor;

    public JavacResolution(Context context) {
        this.attr = Attr.instance(context);
        this.messageSuppressor = new CompilerMessageSuppressor(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<JCTree, JCTree> resolveMethodMember(JavacNode node) {
        ArrayDeque stack = new ArrayDeque();
        for (JavacNode n = node; n != null; n = (JavacNode)n.up()) {
            stack.push(n.get());
        }
        this.messageSuppressor.disableLoggers();
        try {
            EnvFinder finder = new EnvFinder(node.getContext());
            while (!stack.isEmpty()) {
                ((JCTree)stack.pop()).accept(finder);
            }
            TreeMirrorMaker mirrorMaker = new TreeMirrorMaker(node.getTreeMaker());
            JCTree copy = mirrorMaker.copy(finder.copyAt());
            this.attrib(copy, finder.get());
            Map<JCTree, JCTree> map = mirrorMaker.getOriginalToCopyMap();
            return map;
        }
        finally {
            this.messageSuppressor.enableLoggers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveClassMember(JavacNode node) {
        ArrayDeque stack = new ArrayDeque();
        for (JavacNode n = node; n != null; n = (JavacNode)n.up()) {
            stack.push(n.get());
        }
        this.messageSuppressor.disableLoggers();
        try {
            EnvFinder finder = new EnvFinder(node.getContext());
            while (!stack.isEmpty()) {
                ((JCTree)stack.pop()).accept(finder);
            }
            this.attrib((JCTree)node.get(), finder.get());
        }
        finally {
            this.messageSuppressor.enableLoggers();
        }
    }

    private void attrib(JCTree tree, Env<AttrContext> env) {
        if (tree instanceof JCTree.JCBlock) {
            this.attr.attribStat(tree, env);
        } else if (tree instanceof JCTree.JCMethodDecl) {
            this.attr.attribStat(((JCTree.JCMethodDecl)tree).body, env);
        } else if (tree instanceof JCTree.JCVariableDecl) {
            this.attr.attribStat(tree, env);
        } else {
            throw new IllegalStateException("Called with something that isn't a block, method decl, or variable decl");
        }
    }

    public static Type ifTypeIsIterableToComponent(Type type, JavacAST ast) {
        Types types = Types.instance(ast.getContext());
        Symtab syms = Symtab.instance(ast.getContext());
        Type boundType = ReflectiveAccess.Types_upperBound(types, type);
        Type elemTypeIfArray = types.elemtype(boundType);
        if (elemTypeIfArray != null) {
            return elemTypeIfArray;
        }
        Type base = types.asSuper(boundType, syms.iterableType.tsym);
        if (base == null) {
            return syms.objectType;
        }
        List<Type> iterableParams = base.allparams();
        return iterableParams.isEmpty() ? syms.objectType : ReflectiveAccess.Types_upperBound(types, (Type)iterableParams.head);
    }

    public static JCTree.JCExpression typeToJCTree(Type type, JavacAST ast, boolean allowVoid) throws TypeNotConvertibleException {
        return JavacResolution.typeToJCTree(type, ast, false, allowVoid);
    }

    public static JCTree.JCExpression createJavaLangObject(JavacAST ast) {
        JavacTreeMaker maker = ast.getTreeMaker();
        JCTree.JCExpression out = maker.Ident(ast.toName("java"));
        out = maker.Select(out, ast.toName("lang"));
        out = maker.Select(out, ast.toName("Object"));
        return out;
    }

    private static JCTree.JCExpression typeToJCTree(Type type, JavacAST ast, boolean allowCompound, boolean allowVoid) throws TypeNotConvertibleException {
        int dims = 0;
        Type type0 = type;
        while (type0 instanceof Type.ArrayType) {
            ++dims;
            type0 = ((Type.ArrayType)type0).elemtype;
        }
        JCTree.JCExpression result = JavacResolution.typeToJCTree0(type0, ast, allowCompound, allowVoid);
        while (dims > 0) {
            result = ast.getTreeMaker().TypeArray(result);
            --dims;
        }
        return result;
    }

    private static JCTree.JCExpression typeToJCTree0(Type type, JavacAST ast, boolean allowCompound, boolean allowVoid) throws TypeNotConvertibleException {
        String qName;
        JavacTreeMaker maker = ast.getTreeMaker();
        if (Javac.CTC_BOT.equals(JavacTreeMaker.TypeTag.typeTag(type))) {
            return JavacResolution.createJavaLangObject(ast);
        }
        if (Javac.CTC_VOID.equals(JavacTreeMaker.TypeTag.typeTag(type))) {
            return allowVoid ? JavacResolution.primitiveToJCTree(type.getKind(), maker) : JavacResolution.createJavaLangObject(ast);
        }
        if (type.isPrimitive()) {
            return JavacResolution.primitiveToJCTree(type.getKind(), maker);
        }
        if (type.isErroneous()) {
            throw new TypeNotConvertibleException("Type cannot be resolved");
        }
        Symbol.TypeSymbol symbol = type.asElement();
        List<Type> generics = type.getTypeArguments();
        JCTree.JCExpression replacement = null;
        if (symbol == null) {
            throw new TypeNotConvertibleException("Null or compound type");
        }
        if (symbol.name.length() == 0) {
            if (type instanceof Type.ClassType) {
                List<Type> ifaces = ((Type.ClassType)type).interfaces_field;
                Type supertype = ((Type.ClassType)type).supertype_field;
                if (ifaces != null && ifaces.length() == 1) {
                    return JavacResolution.typeToJCTree(ifaces.get(0), ast, allowCompound, allowVoid);
                }
                if (supertype != null) {
                    return JavacResolution.typeToJCTree(supertype, ast, allowCompound, allowVoid);
                }
            }
            throw new TypeNotConvertibleException("Anonymous inner class");
        }
        if (type instanceof Type.CapturedType || type instanceof Type.WildcardType) {
            Type lower;
            Type upper;
            if (type instanceof Type.WildcardType) {
                upper = ((Type.WildcardType)type).getExtendsBound();
                lower = ((Type.WildcardType)type).getSuperBound();
            } else {
                lower = type.getLowerBound();
                upper = type.getUpperBound();
            }
            if (allowCompound) {
                if (lower == null || Javac.CTC_BOT.equals(JavacTreeMaker.TypeTag.typeTag(lower))) {
                    if (upper == null || upper.toString().equals("java.lang.Object")) {
                        return maker.Wildcard(maker.TypeBoundKind(BoundKind.UNBOUND), null);
                    }
                    if (upper.getTypeArguments().contains(type)) {
                        return maker.Wildcard(maker.TypeBoundKind(BoundKind.UNBOUND), null);
                    }
                    return maker.Wildcard(maker.TypeBoundKind(BoundKind.EXTENDS), JavacResolution.typeToJCTree(upper, ast, false, false));
                }
                return maker.Wildcard(maker.TypeBoundKind(BoundKind.SUPER), JavacResolution.typeToJCTree(lower, ast, false, false));
            }
            if (upper != null) {
                if (upper.getTypeArguments().contains(type)) {
                    return maker.Wildcard(maker.TypeBoundKind(BoundKind.UNBOUND), null);
                }
                return JavacResolution.typeToJCTree(upper, ast, allowCompound, allowVoid);
            }
            return JavacResolution.createJavaLangObject(ast);
        }
        if (symbol.isLocal()) {
            qName = ((Name)symbol.getSimpleName()).toString();
        } else if (symbol.type != null && symbol.type.getEnclosingType() != null && JavacTreeMaker.TypeTag.typeTag(symbol.type.getEnclosingType()).equals(JavacTreeMaker.TypeTag.typeTag("CLASS"))) {
            replacement = JavacResolution.typeToJCTree0(type.getEnclosingType(), ast, false, false);
            qName = ((Name)symbol.getSimpleName()).toString();
        } else {
            qName = symbol.getQualifiedName().toString();
        }
        if (qName.isEmpty()) {
            throw new TypeNotConvertibleException("unknown type");
        }
        if (qName.startsWith("<")) {
            throw new TypeNotConvertibleException(qName);
        }
        String[] baseNames = qName.split("\\.");
        int i = 0;
        if (replacement == null) {
            replacement = maker.Ident(ast.toName(baseNames[0]));
            i = 1;
        }
        while (i < baseNames.length) {
            replacement = maker.Select(replacement, ast.toName(baseNames[i]));
            ++i;
        }
        return JavacResolution.genericsToJCTreeNodes(generics, ast, replacement);
    }

    private static JCTree.JCExpression genericsToJCTreeNodes(List<Type> generics, JavacAST ast, JCTree.JCExpression rawTypeNode) throws TypeNotConvertibleException {
        if (generics != null && !generics.isEmpty()) {
            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
            for (Type t : generics) {
                args.append(JavacResolution.typeToJCTree(t, ast, true, false));
            }
            return ast.getTreeMaker().TypeApply(rawTypeNode, args.toList());
        }
        return rawTypeNode;
    }

    private static JCTree.JCExpression primitiveToJCTree(TypeKind kind, JavacTreeMaker maker) throws TypeNotConvertibleException {
        switch (kind) {
            case BYTE: {
                return maker.TypeIdent(Javac.CTC_BYTE);
            }
            case CHAR: {
                return maker.TypeIdent(Javac.CTC_CHAR);
            }
            case SHORT: {
                return maker.TypeIdent(Javac.CTC_SHORT);
            }
            case INT: {
                return maker.TypeIdent(Javac.CTC_INT);
            }
            case LONG: {
                return maker.TypeIdent(Javac.CTC_LONG);
            }
            case FLOAT: {
                return maker.TypeIdent(Javac.CTC_FLOAT);
            }
            case DOUBLE: {
                return maker.TypeIdent(Javac.CTC_DOUBLE);
            }
            case BOOLEAN: {
                return maker.TypeIdent(Javac.CTC_BOOLEAN);
            }
            case VOID: {
                return maker.TypeIdent(Javac.CTC_VOID);
            }
        }
        throw new TypeNotConvertibleException("Nulltype");
    }

    public static boolean platformHasTargetTyping() {
        return Javac.getJavaCompilerVersion() >= 8;
    }

    private static class ReflectiveAccess {
        private static Method UPPER_BOUND;

        private ReflectiveAccess() {
        }

        public static Type Types_upperBound(Types types, Type type) {
            try {
                return (Type)UPPER_BOUND.invoke((Object)types, type);
            }
            catch (InvocationTargetException e) {
                throw Lombok.sneakyThrow(e.getCause());
            }
            catch (Exception e) {
                throw Lombok.sneakyThrow(e);
            }
        }

        static {
            Method upperBound = null;
            try {
                upperBound = Types.class.getMethod("upperBound", Type.class);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (upperBound == null) {
                try {
                    upperBound = Types.class.getMethod("wildUpperBound", Type.class);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            UPPER_BOUND = upperBound;
        }
    }

    public static class TypeNotConvertibleException
    extends Exception {
        public TypeNotConvertibleException(String msg) {
            super(msg);
        }
    }

    private static final class EnvFinder
    extends JCTree.Visitor {
        private Env<AttrContext> env = null;
        private Enter enter;
        private MemberEnter memberEnter;
        private JCTree copyAt = null;

        EnvFinder(Context context) {
            this.enter = Enter.instance(context);
            this.memberEnter = MemberEnter.instance(context);
        }

        Env<AttrContext> get() {
            return this.env;
        }

        JCTree copyAt() {
            return this.copyAt;
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit tree) {
            if (this.copyAt != null) {
                return;
            }
            this.env = this.enter.getTopLevelEnv(tree);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (this.copyAt != null) {
                return;
            }
            this.env = this.enter.getClassEnv(tree.sym);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            if (this.copyAt != null) {
                return;
            }
            this.env = this.memberEnter.getMethodEnv(tree, this.env);
            this.copyAt = tree;
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            if (this.copyAt != null) {
                return;
            }
            this.env = this.memberEnter.getInitEnv(tree, this.env);
            this.copyAt = tree;
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            if (this.copyAt != null) {
                return;
            }
            this.copyAt = tree;
        }

        @Override
        public void visitTree(JCTree that) {
        }
    }
}

