/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.version.ReadWriteVersionManager;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class VersionStorageEditor
extends DefaultEditor {
    private final NodeBuilder versionStorageNode;
    private final NodeBuilder workspaceRoot;
    private ReadWriteVersionManager vMgr;
    private final List<String> pathRemainder;
    private final SortedMap<Integer, Operation> operations = Maps.newTreeMap();

    VersionStorageEditor(@Nonnull NodeBuilder versionStorageNode, @Nonnull NodeBuilder workspaceRoot) {
        this(versionStorageNode, workspaceRoot, Arrays.asList("jcr:system", "jcr:versionStorage"));
    }

    private VersionStorageEditor(@Nonnull NodeBuilder versionStorageNode, @Nonnull NodeBuilder workspaceRoot, @Nonnull List<String> pathRemainder) {
        this.versionStorageNode = versionStorageNode;
        this.workspaceRoot = workspaceRoot;
        this.pathRemainder = Preconditions.checkNotNull(pathRemainder);
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        if (this.pathRemainder.isEmpty()) {
            return null;
        }
        if (this.pathRemainder.get(0).equals(name)) {
            return new VersionStorageEditor(this.versionStorageNode, this.workspaceRoot, this.pathRemainder.subList(1, this.pathRemainder.size()));
        }
        return null;
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        String name = after.getName();
        if ("rep:removeVersionLabels".equals(name)) {
            this.operations.put(1, new RemoveVersionLabels(after.getValue(Type.PATHS)));
            this.versionStorageNode.removeProperty(name);
        } else if ("rep:addVersionLabels".equals(name)) {
            this.operations.put(2, new AddVersionLabels(after.getValue(Type.PATHS)));
            this.versionStorageNode.removeProperty(name);
        } else if ("rep:removeVersion".equals(name)) {
            this.operations.put(3, new RemoveVersion(after.getValue(Type.PATHS)));
            this.versionStorageNode.removeProperty(name);
        }
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        for (Operation op : this.operations.values()) {
            op.perform();
        }
    }

    private ReadWriteVersionManager getVersionManager() {
        if (this.vMgr == null) {
            this.vMgr = new ReadWriteVersionManager(this.versionStorageNode, this.workspaceRoot);
        }
        return this.vMgr;
    }

    private static class VersionLabel {
        private final String versionHistoryPath;
        private final String label;
        private final String versionName;

        VersionLabel(@Nonnull String path) throws IllegalArgumentException {
            Preconditions.checkArgument(!PathUtils.isAbsolute(Preconditions.checkNotNull(path)), "Version label path must be relative");
            ArrayList<String> elements = Lists.newArrayList(PathUtils.elements(path));
            if (elements.size() != 7) {
                throw new IllegalArgumentException("Invalid version label path: " + path);
            }
            StringBuilder builder = new StringBuilder();
            String slash = "";
            for (String element : elements.subList(0, 4)) {
                builder.append(slash);
                builder.append(element);
                slash = "/";
            }
            this.versionHistoryPath = builder.toString();
            Preconditions.checkArgument(((String)elements.get(4)).equals("jcr:versionLabels"), "Invalid version label path: " + path);
            this.label = (String)elements.get(5);
            this.versionName = (String)elements.get(6);
        }
    }

    private class RemoveVersion
    implements Operation {
        private final Iterable<String> versionPaths;

        private RemoveVersion(Iterable<String> versionPaths) {
            this.versionPaths = versionPaths;
        }

        @Override
        public void perform() throws CommitFailedException {
            for (String path : this.versionPaths) {
                VersionStorageEditor.this.getVersionManager().removeVersion(path);
            }
        }
    }

    private class RemoveVersionLabels
    implements Operation {
        private Iterable<String> labelPaths;

        public RemoveVersionLabels(Iterable<String> labelPaths) {
            this.labelPaths = labelPaths;
        }

        @Override
        public void perform() throws CommitFailedException {
            for (String s : this.labelPaths) {
                VersionLabel label = new VersionLabel(s);
                VersionStorageEditor.this.getVersionManager().removeVersionLabel(label.versionHistoryPath, label.label);
            }
        }
    }

    private class AddVersionLabels
    implements Operation {
        private Iterable<String> labelPaths;

        public AddVersionLabels(Iterable<String> labelPaths) {
            this.labelPaths = labelPaths;
        }

        @Override
        public void perform() throws CommitFailedException {
            for (String s : this.labelPaths) {
                VersionLabel label = new VersionLabel(s);
                VersionStorageEditor.this.getVersionManager().addVersionLabel(label.versionHistoryPath, label.label, label.versionName);
            }
        }
    }

    static interface Operation {
        public void perform() throws CommitFailedException;
    }
}

