/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStore;
import org.apache.jackrabbit.oak.security.authorization.permission.PrincipalPermissionEntries;

public class PermissionEntryCache {
    private final Map<String, PrincipalPermissionEntries> entries = new HashMap<String, PrincipalPermissionEntries>();

    @Nonnull
    public PrincipalPermissionEntries getEntries(@Nonnull PermissionStore store, @Nonnull String principalName) {
        PrincipalPermissionEntries ppe = this.entries.get(principalName);
        if (ppe == null) {
            ppe = store.load(principalName);
            this.entries.put(principalName, ppe);
        } else if (!ppe.isFullyLoaded()) {
            ppe = store.load(principalName);
            this.entries.put(principalName, ppe);
        }
        return ppe;
    }

    public void load(@Nonnull PermissionStore store, @Nonnull Map<String, Collection<PermissionEntry>> pathEntryMap, @Nonnull String principalName) {
        PrincipalPermissionEntries ppe = this.getEntries(store, principalName);
        for (Map.Entry<String, Collection<PermissionEntry>> e : ppe.getEntries().entrySet()) {
            Collection<PermissionEntry> pathEntries = pathEntryMap.get(e.getKey());
            if (pathEntries == null) {
                pathEntries = new TreeSet<PermissionEntry>(e.getValue());
                pathEntryMap.put(e.getKey(), pathEntries);
                continue;
            }
            pathEntries.addAll(e.getValue());
        }
    }

    public void load(@Nonnull PermissionStore store, @Nonnull Collection<PermissionEntry> ret, @Nonnull String principalName, @Nonnull String path) {
        Collection<PermissionEntry> pes;
        PrincipalPermissionEntries ppe = this.entries.get(principalName);
        if (ppe == null) {
            ppe = new PrincipalPermissionEntries(principalName);
            this.entries.put(principalName, ppe);
        }
        if ((pes = ppe.getEntries().get(path)) == null) {
            pes = store.load(null, principalName, path);
            if (pes == null) {
                pes = Collections.emptySet();
            } else {
                ret.addAll(pes);
            }
            ppe.getEntries().put(path, pes);
        } else {
            ret.addAll(pes);
        }
    }

    public long getNumEntries(@Nonnull PermissionStore store, @Nonnull String principalName, long max) {
        PrincipalPermissionEntries ppe = this.entries.get(principalName);
        return ppe == null ? store.getNumEntries(principalName, max) : (long)ppe.getEntries().size();
    }

    public void flush(@Nonnull Set<String> principalNames) {
        this.entries.keySet().removeAll(principalNames);
    }
}

