/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import com.thoughtworks.xstream.XStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.accounting.AccountingProperty;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryRead;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public class JCRAccountingEntryRead
extends JCRAccountingEntry
implements AccountingEntryRead {
    private final String itemName;

    public JCRAccountingEntryRead(String id, String user, Calendar date, String itemName) {
        super(id, user, date);
        this.itemName = itemName;
        Map<AccountingProperty, String> properties = this.entryDelegate.getAccountingProperties();
        properties.put(AccountingProperty.ITEM_NAME, new XStream().toXML(itemName));
        this.entryDelegate.setEntryType(AccountingEntryType.READ);
    }

    public JCRAccountingEntryRead(AccountingDelegate node) throws RepositoryException {
        super(node);
        this.itemName = (String)new XStream().fromXML(this.entryDelegate.getAccountingProperties().get((Object)AccountingProperty.ITEM_NAME));
    }

    @Override
    public String getItemName() {
        return this.itemName;
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.READ;
    }

    @Override
    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String user = super.getUser();
        Calendar date = super.getDate();
        return String.format("[ user:%s, date:%s, itemName:%s ]", user, sdf.format(date.getTime()), this.itemName);
    }
}

