/**
 * 
 */
package org.gcube.accounting.datamodel;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.gcube.accounting.datamodel.decorators.FieldAction;
import org.gcube.accounting.datamodel.decorators.FieldDecorator;
import org.gcube.accounting.datamodel.deprecationmanagement.annotations.DeprecatedWarning;
import org.gcube.accounting.datamodel.implementations.JobUsageRecord;
import org.gcube.accounting.datamodel.implementations.PortletUsageRecord;
import org.gcube.accounting.datamodel.implementations.ServiceUsageRecord;
import org.gcube.accounting.datamodel.implementations.StorageUsageRecord;
import org.gcube.accounting.datamodel.implementations.TaskUsageRecord;
import org.gcube.accounting.datamodel.validations.annotations.NotEmpty;
import org.gcube.accounting.datamodel.validations.annotations.NotEmptyIfNotNull;
import org.gcube.accounting.datamodel.validations.validators.NotEmptyIfNotNullValidator;
import org.gcube.accounting.exception.InvalidValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
@Deprecated
public class RawUsageRecord extends BasicUsageRecord {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = 1203390363640634895L;
	
	private static Logger logger = LoggerFactory.getLogger(RawUsageRecord.class);
	
	
	@DeprecatedWarning @NotEmpty
	protected static final String RESOURCE_OWNER = "resourceOwner";
	
	@DeprecatedWarning @MoveToCreationTime
	protected static final String CREATE_TIME = "createTime";
	
	@Target(ElementType.FIELD)
	@Retention(RetentionPolicy.RUNTIME)
	@FieldDecorator(managed=MoveToCreationTimeAction.class) 
	protected @interface MoveToCreationTime { }
	protected class MoveToCreationTimeAction implements FieldAction {
		@Override
		public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException  {
			if(value instanceof Date){
				Calendar calendar = Calendar.getInstance();
				calendar.setTime((Date) value);
				value = calendar;
			}
			if(value instanceof Long){
				Calendar calendar = Calendar.getInstance();
				calendar.setTimeInMillis((Long) value);
				value = calendar;
			}
			
			if(value instanceof Calendar){
				usageRecord.setCreationTime((Calendar) value);
			}else{
				throw new InvalidValueException();
			}
			
			return value;
		}
	}
	
	private final static Map<String, String> resourceTypeMapping;
	
	private final static String JOB = "job";
	private final static String TASK = "task";
	private final static String PORTLET = "portlet";
	private final static String SERVICE = "service";
	private final static String STORAGE_USAGE = "storage-usage";
	
	static {
		resourceTypeMapping = new HashMap<String, String>();
		resourceTypeMapping.put(JOB, JobUsageRecord.class.getSimpleName());
		resourceTypeMapping.put(TASK, TaskUsageRecord.class.getSimpleName());
		resourceTypeMapping.put(PORTLET, PortletUsageRecord.class.getSimpleName());
		resourceTypeMapping.put(SERVICE, ServiceUsageRecord.class.getSimpleName());
		resourceTypeMapping.put(STORAGE_USAGE, StorageUsageRecord.class.getSimpleName());
		
	}
	
	@DeprecatedWarning @MoveToUsageRecordType
	protected static final String RESOURCE_TYPE = "resourceType";
	@Target(ElementType.FIELD)
	@Retention(RetentionPolicy.RUNTIME)
	@FieldDecorator(managed=MoveToUsageRecordTypeAction.class) 
	protected @interface MoveToUsageRecordType { }
	protected class MoveToUsageRecordTypeAction implements FieldAction {
		
		@Override
		public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException  {
			if(value instanceof String){
				String newValue  = resourceTypeMapping.get(value);
				if(newValue == null){
					throw new InvalidValueException();
				}
				resourceProperties.put(USAGE_RECORD_TYPE, newValue);
			}else{
				throw new InvalidValueException();
			}
			return value;
		}
	}
	
	
	@DeprecatedWarning @MoveToAggregatedUsageRecordId
	protected static final String AGGREGATED_ID = "aggregatedId";
	
	@Target(ElementType.FIELD)
	@Retention(RetentionPolicy.RUNTIME)
	@FieldDecorator(managed=MoveToAggregatedUsageRecordIdAction.class) 
	protected @interface MoveToAggregatedUsageRecordId { }
	protected class MoveToAggregatedUsageRecordIdAction implements FieldAction {
		@Override
		public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException  {
			NotEmptyIfNotNullValidator neinnv = new NotEmptyIfNotNullValidator();
			value = neinnv.validate(key, value, usageRecord);
			usageRecord.setAggregatedUsageRecordId((String) value);
			return value;
		}
	}
	
	@NotEmptyIfNotNull @DeprecatedWarning
	protected static final String FULLY_QUALIFIED_CONSUMER_ID = "fullyQualifiedConsumerId";
	
	public RawUsageRecord(){
		super();
		this.resourceProperties.remove(USAGE_RECORD_TYPE);
	}
	
	public RawUsageRecord(Map<String, Serializable> properties) throws InvalidValueException {
		super(properties);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setConsumerId(String consumerId) {
		try{
			setConsumerId(consumerId);
		} catch(Exception e){
			logger.error("Unable to Set {}", CONSUMER_ID);
		}
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setResourceScope(String scope) {
		try{
			setResourceScope(scope);
		}catch(Exception e){
			logger.error("Unable to Set {}", RESOURCE_SCOPE);
		}
	}
	
	/**
	 * Use {#getUsageRecordType} instead
	 * @param resourceType
	 * @return Usage Record Type
	 */
	@Deprecated
	public String getResourceType(){
		return (String) this.resourceProperties.get(RESOURCE_TYPE);
	}
	
	/**
	 * This method is not valid due to Resource Type is derived by
	 * the Usage Record Implementation class. The method is deprecated and
	 * the implementations in known classes is a NoOperation. 
	 * @param resourceType
	 */
	@Deprecated
	public void setResourceType(String resourceType){
		try {
			setResourceProperty(RESOURCE_TYPE, resourceType);
		}catch(InvalidValueException e){
			logger.error("Unable to Set {}", RESOURCE_TYPE);
		}
	}
	
	
	/**
	 * Return the creation time for this {#UsageRecord}
	 * @return the creation time for this {#UsageRecord}
	 */
	@Deprecated
	public Date getCreateTime() {
		long millis = (Long) this.resourceProperties.get(CREATION_TIME);
		return timestampStringToCalendar(millis).getTime();
	}
	
	/**
	 * Use {{@link #setCreationTime(Calendar)}} instead
	 * @param createTime
	 * @throws InvalidValueException
	 */
	@Deprecated
	public void setCreateTime(Date createTime) {
		/*
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(createTime);
		setCreationTime(calendar);
		*/
		logger.warn("The method is deprecated. Please modify your code as soon as possible");
	}
	
	
	
	/**
	 * Return the left end of the time interval covered by this usage record
	 * @return Start Time
	 */
	@Deprecated
	public Date getStartTime() {
		long millis = (Long) this.resourceProperties.get(START_TIME);
		return timestampStringToCalendar(millis).getTime();
	}
	
	/**
	 * @param createTime
	 * @throws InvalidValueException
	 */
	@Deprecated
	public void setStartTime(Date startTime) throws InvalidValueException {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(startTime);
		setStartTime(calendar);
	}
	
	
	/**
	 * Return the right end of the time interval covered by this usage record
	 * @return End Time
	 */
	@Deprecated
	public Date getEndTime() {
		long millis = (Long) this.resourceProperties.get(END_TIME);
		return timestampStringToCalendar(millis).getTime();
	}

	/**
	 * @param endTime
	 * @throws InvalidValueException
	 */
	@Deprecated
	public void setEndTime(Date endTime) throws InvalidValueException {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(endTime);
		setEndTime(calendar);
	}
	
	
	/**
	 * Return the identity id of the accounting owner
	 * @return The identity id of the accounting owner
	 */
	@Deprecated
	public String getResourceOwner() {
		return (String) this.resourceProperties.get(RESOURCE_OWNER);
	}

	/**
	 * Set the identity id of the accounting owner
	 * @param ownerID The identity id of the accounting owner
	 * @throws InvalidValueException
	 */
	@Deprecated
	public void setResourceOwner(String owner) {
		try {
			setResourceProperty(RESOURCE_OWNER, owner);
		} catch (InvalidValueException e) {
			logger.error("Unable to Set {}", RESOURCE_OWNER);
		}
	}
	
	/**
	 * Return the id of the usage record aggregating this, null if this record
	 * has not been aggregated by any record.
	 * This method id deprecated. Use {@link #getAggregatedUsageRecordId()}
	 * instead.
	 * @return Aggregated Id The ID of the aggregation Record
	 */
	@Deprecated
	public String getAggregatedId() {
		return (String) this.resourceProperties.get(AGGREGATED_ID);
	}


	/**
	 * Set the id of the usage record aggregating this.
	 * This method id deprecated. Use {@link #setAggregatedUsageRecordId()}
	 * instead.
	 * @param aggregatedId The ID of the aggregation Record
	 * @throws InvalidValueException
	 */
	@Deprecated
	public void setAggregatedId(String aggregatedId)  throws InvalidValueException {
		setResourceProperty(AGGREGATED_ID, aggregatedId);
	}
	
	/**
	 * Return all resource properties
	 * Use {@link #getResourceSpecificProperties()}
	 * @return a Map containing the properties
	 */
	@Deprecated
	public Map<String, String> getResourceSpecificProperties() {
		Map<String, String> ret = new HashMap<String, String>();
		for(String key : this.resourceProperties.keySet()){
			String value = this.resourceProperties.get(key).toString();
			ret.put(key, value);
		}
		return ret;
	}

	/**
	 * Set all resource properties, replacing existing ones
	 * Use {@link #setResourceSpecificProperties()}
	 */
	@Deprecated
	public void setResourceSpecificProperties(Map<String, String> properties) throws InvalidValueException {
		Map<String, Serializable> map = new HashMap<String, Serializable>(properties);
		setResourceProperties(map);
	}
	
	/**
	 * Return the value of the given resource property.
	 * @param key the key of the requested property
	 * @return the value of the given resource property
	 */
	@Deprecated
	public String getResourceSpecificProperty(String key) {
		return getResourceProperty(key).toString();
	}
	
	/**
	 * Set the value of the given resource property.
	 * If the key has the value of one of the predefined property, the value
	 * is validated.
	 * @param key the key of the requested property 
	 * @param value the value of the given resource property
	 */
	@Deprecated
	public void setResourceSpecificProperty(String key, Serializable value) {
		try {
			setResourceProperty(key, value);
		} catch (InvalidValueException e) {
			logger.error("Unable to Set {}", key);
		}
		
	}
	
	/**
	 * The method is deprecated and the implementations in known classes
	 * return Consumer ID
	 * @return Consumer ID
	 */
	@Deprecated
	public String getFullyQualifiedConsumerId() {
		return (String) this.resourceProperties.get(FULLY_QUALIFIED_CONSUMER_ID);
	}
	
	/**
	 * The method is deprecated and the implementations in known classes is 
	 * a NoOperation.
	 * @param fqcid Fully Qualified Consumer Id
	 */
	@Deprecated
	public void setFullyQualifiedConsumerId(String fqcid) {
		try {
			setResourceProperty(FULLY_QUALIFIED_CONSUMER_ID, fqcid);
		} catch (InvalidValueException e) {
			logger.error("Unable to Set {}", FULLY_QUALIFIED_CONSUMER_ID);
		}
	}
	
	
}
