/**
 * 
 */
package org.gcube.accounting.datamodel.implementations;

import java.io.Serializable;
import java.util.Map;

import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.SingleUsageRecord;
import org.gcube.accounting.datamodel.decorators.AggregatedField;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.deprecationmanagement.annotations.DeprecatedWarning;
import org.gcube.accounting.datamodel.validations.annotations.NotEmpty;
import org.gcube.accounting.datamodel.validations.annotations.ValidIP;
import org.gcube.accounting.datamodel.validations.annotations.ValidInteger;
import org.gcube.accounting.datamodel.validations.annotations.ValidLong;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class ServiceUsageRecord extends BasicUsageRecord implements SingleUsageRecord {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -4214891294699473587L;

	@ValidIP
	public static final String CALLER_IP = "callerIP";
	@RequiredField @NotEmpty
	public static final String CALLER_SCOPE = "callerScope";
	@RequiredField @NotEmpty
	public static final String REF_HOST = "refHost";
	@RequiredField @NotEmpty
	public static final String REF_VM = "refVM";
	
	@NotEmpty @DeprecatedWarning
	protected static final String DOMAIN = "domain";
	
	@ValidInteger @AggregatedField
	protected static final String INVOCATION_COUNT = "invocationCount";
	@ValidInteger @AggregatedField
	protected static final String AVERAGE_INVOCATION_COUNT = "averageInvocationTime";
	@RequiredField @NotEmpty
	public static final String SERVICE_CLASS = "serviceClass";
	@RequiredField @NotEmpty
	public static final String SERVICE_NAME = "serviceName";
	
	@RequiredField @ValidLong
	public static final String DURATION = "duration";
	
	public ServiceUsageRecord(){
		super();
	}
	
	public ServiceUsageRecord(Map<String, Serializable> properties) throws InvalidValueException {
		super(properties);
	}
	
	public String getCallerIP() {
		return (String) this.resourceProperties.get(CALLER_IP);
	}

	public void setCallerIP(String callerIP) throws InvalidValueException {
		setResourceProperty(CALLER_IP, callerIP);
	}
	
	public String getCallerScope() {
		return (String) this.resourceProperties.get(CALLER_SCOPE);
	}

	public void setCallerScope(String callerScope) throws InvalidValueException {
		setResourceProperty(CALLER_SCOPE, callerScope);
	}
	
	public String getRefHost() {
		return (String) this.resourceProperties.get(REF_HOST);
	}

	public void setRefHost(String refHost) throws InvalidValueException {
		setResourceProperty(REF_HOST, refHost);
	}
	
	public String getRefVM() {
		return (String) this.resourceProperties.get(REF_VM);
	}

	public void setRefVM(String refVM) throws InvalidValueException {
		setResourceProperty(REF_VM, refVM);
	}
	
	/*
	protected String getDomain() {
		return (String) this.resourceProperties.get(DOMAIN);
	}

	protected void setDomain(String domain) throws InvalidValueException {
		setResourceProperty(DOMAIN, domain);
	}
	
	public String getInvocationCount() {
		return (String) this.resourceProperties.get(INVOCATION_COUNT);
	}

	public void setInvocationCount(String invocationCount) throws InvalidValueException {
		setResourceProperty(INVOCATION_COUNT, invocationCount);
	}

	public String getAverageInvocationTime() {
		return (String) this.resourceProperties.get(AVERAGE_INVOCATION_COUNT);
	}

	public void setAverageInvocationTime(String averageInvocationTime) throws InvalidValueException {
		setResourceProperty(AVERAGE_INVOCATION_COUNT, averageInvocationTime);
	}
	*/
	
	public String getServiceClass() {
		return (String) this.resourceProperties.get(SERVICE_CLASS);
	}

	public void setServiceClass(String serviceClass) throws InvalidValueException {
		setResourceProperty(SERVICE_CLASS, serviceClass);
	}
	
	public String getServiceName() {
		return (String) this.resourceProperties.get(SERVICE_NAME);
	}

	public void setServiceName(String serviceName) throws InvalidValueException {
		setResourceProperty(SERVICE_NAME, serviceName);
	}
	
	public Long getDuration() {
		return (Long) this.resourceProperties.get(DURATION);
	}

	public void setDuration(Long duration) throws InvalidValueException {
		setResourceProperty(DURATION, duration);
	}
}
